/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.persister;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.platform.jaxrs.RestCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import ru.i_novus.ms.rdm.sync.api.mapping.FieldMapping;
import ru.i_novus.ms.rdm.sync.api.mapping.VersionMapping;
import ru.i_novus.ms.rdm.sync.api.model.AttributeTypeEnum;
import ru.i_novus.ms.rdm.sync.api.model.DataCriteria;
import ru.i_novus.ms.rdm.sync.api.model.RefBookVersion;
import ru.i_novus.ms.rdm.sync.api.model.RowDiff;
import ru.i_novus.ms.rdm.sync.api.model.RowDiffStatusEnum;
import ru.i_novus.ms.rdm.sync.api.model.VersionsDiff;
import ru.i_novus.ms.rdm.sync.api.model.VersionsDiffCriteria;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceService;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;
import ru.i_novus.ms.rdm.sync.model.DataTypeEnum;
import ru.i_novus.ms.rdm.sync.service.RdmMappingService;
import ru.i_novus.ms.rdm.sync.service.persister.PersisterService;
import ru.i_novus.ms.rdm.sync.util.PageIterator;

@Service
public class NotVersionedPersisterService
implements PersisterService {
    private static final Logger logger = LoggerFactory.getLogger(NotVersionedPersisterService.class);
    private final RdmSyncDao dao;
    private final int maxSize;
    private final RdmMappingService mappingService;

    public NotVersionedPersisterService(RdmSyncDao dao, @Value(value="${rdm-sync.load.size: 1000}") int maxSize, RdmMappingService mappingService) {
        this.maxSize = maxSize;
        this.dao = dao;
        this.mappingService = mappingService;
    }

    @Override
    public void firstWrite(RefBookVersion newVersion, VersionMapping versionMapping, SyncSourceService syncSourceService) {
        List<FieldMapping> fieldMappings = this.dao.getFieldMappings(versionMapping.getId());
        FieldMapping primaryField = fieldMappings.stream().filter(mapping -> mapping.getSysField().equals(versionMapping.getPrimaryField())).findFirst().orElse(null);
        List<Object> existingDataIds = this.dao.getDataIds(versionMapping.getTable(), primaryField);
        DataCriteria searchDataCriteria = new DataCriteria();
        searchDataCriteria.setCode(versionMapping.getCode());
        searchDataCriteria.setVersion(newVersion.getVersion());
        searchDataCriteria.setPageSize(this.maxSize);
        PageIterator iter = new PageIterator(arg_0 -> ((SyncSourceService)syncSourceService).getData(arg_0), searchDataCriteria, true);
        while (iter.hasNext()) {
            Page page = iter.next();
            this.insertOrUpdateRows(page.getContent(), existingDataIds, versionMapping, fieldMappings, newVersion);
            this.logProgress(versionMapping.getCode(), (RestCriteria)searchDataCriteria, page);
        }
    }

    @Override
    public void merge(RefBookVersion newVersion, String synchedVersion, VersionMapping versionMapping, SyncSourceService syncSourceService) {
        List<FieldMapping> fieldMappings = this.dao.getFieldMappings(versionMapping.getId());
        VersionsDiffCriteria versionsDiffCriteria = new VersionsDiffCriteria(versionMapping.getCode(), newVersion.getVersion(), synchedVersion);
        VersionsDiff diff = syncSourceService.getDiff(versionsDiffCriteria);
        if (diff.isStructureChanged()) {
            this.dao.markDeleted(versionMapping.getTable(), versionMapping.getDeletedField(), newVersion.getFrom(), true);
            this.firstWrite(newVersion, versionMapping, syncSourceService);
            return;
        }
        if (!diff.getRows().isEmpty()) {
            PageIterator iter = new PageIterator(criteria -> syncSourceService.getDiff(criteria).getRows(), versionsDiffCriteria, true);
            while (iter.hasNext()) {
                Page page = iter.next();
                for (RowDiff rowDiff : page.getContent()) {
                    this.mergeRow(newVersion, rowDiff, versionMapping, fieldMappings);
                }
            }
        }
    }

    @Override
    public void repeatVersion(RefBookVersion newVersion, VersionMapping versionMapping, SyncSourceService syncSourceService) {
        this.dao.markDeleted(versionMapping.getTable(), versionMapping.getDeletedField(), newVersion.getFrom(), true);
        this.firstWrite(newVersion, versionMapping, syncSourceService);
    }

    private void mergeRow(RefBookVersion newVersion, RowDiff rowDiff, VersionMapping versionMapping, List<FieldMapping> fieldMappings) {
        HashMap<String, Object> mappedRow = new HashMap<String, Object>();
        for (Map.Entry entry : rowDiff.getRow().entrySet()) {
            Map<String, Object> mappedValue = this.mapValue(newVersion, (String)entry.getKey(), entry.getValue(), fieldMappings);
            if (mappedValue == null) continue;
            mappedRow.putAll(mappedValue);
        }
        String table = versionMapping.getTable();
        String primaryField = versionMapping.getPrimaryField();
        Object primaryValue = mappedRow.get(primaryField);
        boolean idExists = this.dao.isIdExists(table, primaryField, primaryValue);
        if (RowDiffStatusEnum.DELETED.equals((Object)rowDiff.getStatus())) {
            this.dao.markDeleted(table, primaryField, versionMapping.getDeletedField(), primaryValue, newVersion.getFrom(), true);
        } else if (RowDiffStatusEnum.INSERTED.equals((Object)rowDiff.getStatus()) && !idExists) {
            this.dao.insertRow(table, mappedRow, true);
        } else {
            this.dao.markDeleted(table, primaryField, versionMapping.getDeletedField(), primaryValue, null, true);
            this.dao.updateRow(table, primaryField, mappedRow, true);
        }
    }

    private void insertOrUpdateRows(List<? extends Map<String, ?>> rows, List<Object> existingDataIds, VersionMapping versionMapping, List<FieldMapping> fieldMappings, RefBookVersion newVersion) {
        String primaryField = versionMapping.getPrimaryField();
        ArrayList<Map<String, Object>> insertRows = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updateRows = new ArrayList<Map<String, Object>>();
        for (Map<String, ?> row : rows) {
            HashMap<String, Object> mappedRow = new HashMap<String, Object>();
            for (Map.Entry<String, ?> fieldValue : row.entrySet()) {
                Map<String, Object> mappedValue = this.mapValue(newVersion, fieldValue.getKey(), fieldValue.getValue(), fieldMappings);
                if (mappedValue == null) continue;
                mappedRow.putAll(mappedValue);
            }
            fieldMappings.forEach(mapping -> {
                if (!mappedRow.containsKey(mapping.getSysField())) {
                    mappedRow.put(mapping.getSysField(), null);
                }
            });
            Object primaryValue = mappedRow.get(primaryField);
            if (existingDataIds.contains(primaryValue)) {
                HashMap<String, Object> updatedRow = new HashMap<String, Object>(mappedRow);
                updatedRow.put(versionMapping.getDeletedField(), null);
                updateRows.add(updatedRow);
                continue;
            }
            insertRows.add(mappedRow);
        }
        if (!updateRows.isEmpty()) {
            this.dao.updateRows(versionMapping.getTable(), versionMapping.getPrimaryField(), updateRows, true);
        }
        if (!insertRows.isEmpty()) {
            this.dao.insertRows(versionMapping.getTable(), insertRows, true);
        }
    }

    private void logProgress(String refBookCode, RestCriteria criteria, Page currentPage) {
        int totalPages;
        int n = totalPages = currentPage.getContent().isEmpty() ? 1 : (int)Math.ceil((double)currentPage.getTotalElements() / (double)criteria.getPageSize());
        if (criteria.getPageNumber() % 5 == 0) {
            logger.info("refbook {} {} rows of {} synchronized", new Object[]{refBookCode, criteria.getPageNumber() * criteria.getPageSize() + currentPage.getContent().size(), currentPage.getTotalElements()});
        } else if (totalPages == criteria.getPageNumber() + 1) {
            logger.info("refbook {} {} rows of {} synchronized", new Object[]{refBookCode, currentPage.getTotalElements(), currentPage.getTotalElements()});
        }
    }

    private Map<String, Object> mapValue(RefBookVersion newVersion, String rdmField, Object value, List<FieldMapping> fieldMappings) {
        FieldMapping fieldMapping = fieldMappings.stream().filter(mapping -> mapping.getRdmField().equals(rdmField)).findAny().orElse(null);
        if (fieldMapping == null) {
            return null;
        }
        AttributeTypeEnum attributeType = (AttributeTypeEnum)newVersion.getStructure().getAttributesAndTypes().get(fieldMapping.getRdmField());
        DataTypeEnum clientType = DataTypeEnum.getByDataType(fieldMapping.getSysDataType());
        HashMap<String, Object> mappedValue = new HashMap<String, Object>();
        mappedValue.put(fieldMapping.getSysField(), this.mappingService.map(attributeType, clientType, value));
        return mappedValue;
    }
}

