/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.service.updater;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import ru.i_novus.ms.rdm.sync.api.mapping.LoadedVersion;
import ru.i_novus.ms.rdm.sync.api.model.RefBookVersion;
import ru.i_novus.ms.rdm.sync.api.model.SyncRefBook;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceService;
import ru.i_novus.ms.rdm.sync.dao.RdmSyncDao;

public class RefBookVersionIterator
implements Iterator<String> {
    private Iterator<String> versions;
    private List<VersionsRange> ranges = new ArrayList<VersionsRange>();

    public RefBookVersionIterator(SyncRefBook refBook, RdmSyncDao rdmSyncDao, SyncSourceService syncSourceService) {
        this.init(refBook, rdmSyncDao, syncSourceService);
    }

    @Override
    public boolean hasNext() {
        return this.versions.hasNext();
    }

    @Override
    public String next() {
        return this.versions.next();
    }

    private void init(SyncRefBook refBook, RdmSyncDao rdmSyncDao, SyncSourceService syncSourceService) {
        List loadedVersions = rdmSyncDao.getLoadedVersions(refBook.getCode()).stream().map(LoadedVersion::getVersion).collect(Collectors.toList());
        List allVersions = syncSourceService.getVersions(refBook.getCode());
        this.initRanges(refBook.getRange(), allVersions);
        this.versions = allVersions.stream().filter(refBookVersion -> this.ranges.stream().anyMatch(range -> range.contains((RefBookVersion)refBookVersion))).map(RefBookVersion::getVersion).filter(version -> !loadedVersions.contains(version)).collect(Collectors.toList()).iterator();
    }

    private void initRanges(String range, List<RefBookVersion> versions) {
        if (range.contains(",")) {
            Arrays.stream(range.split(",")).forEach(splitRange -> this.initRanges((String)splitRange, versions));
        } else if (range.contains("-")) {
            RefBookVersion left = null;
            RefBookVersion right = null;
            String[] splitRange2 = range.split("-");
            if (splitRange2.length != 2) {
                throw new IllegalArgumentException("cannot parse " + range);
            }
            for (RefBookVersion version2 : versions) {
                if (version2.getVersion().equals(splitRange2[0])) {
                    left = version2;
                }
                if (!version2.getVersion().equals(splitRange2[1])) continue;
                right = version2;
            }
            if (left != null || right != null) {
                this.ranges.add(new VersionsRange(left, right));
            }
        } else if (range.equals("*")) {
            this.ranges.add(new VersionsRange(null, null));
        } else {
            Optional<RefBookVersion> refBookVersion = versions.stream().filter(version -> version.getVersion().equals(range)).findAny();
            refBookVersion.ifPresent(version -> this.ranges.add(new VersionsRange((RefBookVersion)version, (RefBookVersion)version)));
        }
    }

    private static class VersionsRange {
        private RefBookVersion left;
        private RefBookVersion right;

        VersionsRange(RefBookVersion left, RefBookVersion right) {
            this.left = left;
            this.right = right;
        }

        boolean contains(RefBookVersion refBookVersion) {
            return !(this.left != null && this.left.getFrom().isAfter(refBookVersion.getFrom()) || this.right != null && this.right.getFrom().isBefore(refBookVersion.getFrom()));
        }
    }
}

