/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.util.Pair;
import org.springframework.util.ReflectionUtils;
import ru.i_novus.ms.rdm.api.util.StringUtils;
import ru.i_novus.ms.rdm.sync.api.mapping.FieldMapping;

public final class RdmSyncDataUtils {
    public static final HashMap<String, Object> INTERNAL_TAG = new HashMap();

    private RdmSyncDataUtils() {
        throw new UnsupportedOperationException();
    }

    public static void reindex(List<FieldMapping> fieldMappings, Map<String, Object> map) {
        HashSet<String> sysProcessed = new HashSet<String>();
        for (FieldMapping fieldMapping : fieldMappings) {
            String sys = fieldMapping.getSysField();
            String rdm = fieldMapping.getRdmField();
            if (sysProcessed.contains(rdm)) continue;
            if (!sys.equals(rdm)) {
                Object v1 = map.get(sys);
                Object v2 = map.get(rdm);
                map.put(rdm, v1);
                if (v2 != null) {
                    map.put(sys, v2);
                }
            }
            sysProcessed.add(sys);
        }
    }

    public static <T extends Serializable> List<Object> extractSnakeCaseKey(String snakeCaseKey, List<? extends T> ts) {
        if (ts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Serializable t : ts) {
            var v = new Object(){
                Object val = null;
            };
            if (t instanceof Map) {
                Map m = (Map)((Object)t);
                if (m.containsKey(snakeCaseKey)) {
                    v.val = m.get(snakeCaseKey);
                } else {
                    for (Map.Entry e : m.entrySet()) {
                        if (!StringUtils.camelCaseToSnakeCase((String)((String)e.getKey())).equals(snakeCaseKey)) continue;
                        v.val = e.getValue();
                        break;
                    }
                }
            } else {
                ReflectionUtils.doWithFields(t.getClass(), field -> {
                    if (StringUtils.camelCaseToSnakeCase((String)field.getName()).equals(snakeCaseKey)) {
                        field.setAccessible(true);
                        v.val = field.get(t);
                    }
                });
            }
            if (v.val == null) continue;
            list.add(v.val);
        }
        return list;
    }

    public static <T extends Serializable> Map<String, Object> mapForPgInsert(T t, List<Pair<String, String>> columnTypes) {
        Set<String> columnsSnakeCase = columnTypes.stream().map(Pair::getFirst).collect(Collectors.toSet());
        return RdmSyncDataUtils.tToMap(t, true, columnsSnakeCase);
    }

    public static <T extends Serializable> Map<String, Object> tToMap(T t, boolean toSnakeCase, Set<String> schema) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!(t instanceof Map)) {
            ReflectionUtils.doWithFields(t.getClass(), field -> {
                field.setAccessible(true);
                String snakeCase = StringUtils.camelCaseToSnakeCase((String)field.getName());
                if (RdmSyncDataUtils.shouldConsiderThisField(snakeCase, schema)) {
                    map.put(toSnakeCase ? snakeCase : field.getName(), field.get(t));
                }
            });
        } else {
            for (Map.Entry e : ((Map)((Object)t)).entrySet()) {
                String snakeCase = StringUtils.camelCaseToSnakeCase((String)((String)e.getKey()));
                if (!RdmSyncDataUtils.shouldConsiderThisField(snakeCase, schema)) continue;
                map.put(toSnakeCase ? snakeCase : (String)e.getKey(), e.getValue());
            }
        }
        if (schema != null) {
            for (String s : schema) {
                map.putIfAbsent(s, null);
            }
        }
        return map;
    }

    private static boolean shouldConsiderThisField(String fieldName, Set<String> schema) {
        return schema == null || schema.contains(fieldName);
    }
}

