/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.i_novus.ms.rdm.sync.api.model.RefBookVersion;

public class RefBookReferenceSort {
    private RefBookReferenceSort() {
    }

    public static List<String> getSortedCodes(List<RefBookVersion> refBooks) {
        HashMap<String, DictionaryNode> refCodes = new HashMap<String, DictionaryNode>();
        for (RefBookVersion refbook : refBooks) {
            refCodes.put(refbook.getCode(), new DictionaryNode());
        }
        for (RefBookVersion version : refBooks) {
            DictionaryNode node = (DictionaryNode)refCodes.get(version.getCode());
            version.getStructure().getReferences().forEach(referenceCode -> {
                if (refCodes.containsKey(referenceCode)) {
                    node.child.add((String)referenceCode);
                }
            });
        }
        List<String> topologicalOrder = RefBookReferenceSort.topologicalSort(refCodes);
        LinkedList<String> inverseOrder = new LinkedList<String>();
        for (String s : topologicalOrder) {
            inverseOrder.push(s);
        }
        return inverseOrder;
    }

    private static List<String> topologicalSort(Map<String, DictionaryNode> refCodes) {
        HashSet<String> visited = new HashSet<String>();
        LinkedList<String> stack = new LinkedList<String>();
        for (Map.Entry<String, DictionaryNode> e : refCodes.entrySet()) {
            String refBookCode = e.getKey();
            if (visited.contains(refBookCode)) continue;
            RefBookReferenceSort.topologicalSort0(stack, visited, refCodes, refBookCode);
        }
        return stack;
    }

    private static void topologicalSort0(LinkedList<String> stack, Set<String> visited, Map<String, DictionaryNode> refCodes, String refBookCode) {
        visited.add(refBookCode);
        for (String referenceCode : refCodes.get((Object)refBookCode).child) {
            if (visited.contains(referenceCode)) continue;
            RefBookReferenceSort.topologicalSort0(stack, visited, refCodes, referenceCode);
        }
        stack.push(refBookCode);
    }

    private static class DictionaryNode {
        private final Collection<String> child = new LinkedList<String>();

        private DictionaryNode() {
        }
    }
}

