/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.gatling.kafka.javaapi.request.builder.expressions;

import io.gatling.commons.validation.Validation;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Expressions;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Serde;
import scala.Function1;

public abstract class ExpressionBuilder<V> {
    private final Function<Session, V> javaExpression;
    private final Class<V> type;
    private final Serde<V> serde;

    protected ExpressionBuilder(Function<Session, V> function, Class<V> clazz, Serde<V> serde) {
        this.javaExpression = function;
        this.type = clazz;
        this.serde = serde;
    }

    Function1<io.gatling.core.session.Session, Validation<byte[]>> bytes(String string) {
        return Expressions.javaFunctionToExpression(this.javaExpression.andThen(object -> this.serde.serializer().serialize(string, object)));
    }

    public Function1<io.gatling.core.session.Session, Validation<V>> gatlingExpression() {
        return Expressions.javaFunctionToExpression(this.javaExpression);
    }

    public Class<V> getType() {
        return this.type;
    }

    public Serde<V> getSerde() {
        return this.serde;
    }
}

