/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.vyarus.java.generics.resolver.context.ConstructorGenericsContext;
import ru.vyarus.java.generics.resolver.context.GenericDeclarationScope;
import ru.vyarus.java.generics.resolver.context.GenericsContext;
import ru.vyarus.java.generics.resolver.context.GenericsInfo;
import ru.vyarus.java.generics.resolver.context.MethodGenericsContext;
import ru.vyarus.java.generics.resolver.error.UnknownGenericException;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;

public abstract class AbstractGenericsContext {
    protected final GenericsInfo genericsInfo;
    protected final Class<?> currentType;
    protected final Map<String, Type> typeGenerics;

    public AbstractGenericsContext(GenericsInfo genericsInfo, Class<?> type) {
        if (type.isPrimitive()) {
            throw new IllegalArgumentException(String.format("Primitive type %s can't be used for generics context building", type.getSimpleName()));
        }
        this.genericsInfo = genericsInfo;
        this.currentType = type;
        this.typeGenerics = genericsInfo.getTypeGenerics(type);
    }

    public Class<?> currentClass() {
        return this.currentType;
    }

    public List<Type> genericTypes() {
        return new ArrayList<Type>(this.typeGenerics.values());
    }

    public List<Class<?>> generics() {
        ArrayList res = new ArrayList();
        for (Type type : this.typeGenerics.values()) {
            res.add(this.resolveClass(type));
        }
        return res;
    }

    public List<String> genericsAsString() {
        ArrayList<String> res = new ArrayList<String>();
        for (Type type : this.contextGenerics().values()) {
            res.add(this.toStringType(type));
        }
        return res;
    }

    public Type genericType(int position) {
        return this.genericTypes().get(position);
    }

    public Type genericType(String genericName) {
        return this.contextGenerics().get(this.checkGenericName(genericName));
    }

    public Class<?> generic(int position) {
        return this.resolveClass(this.genericTypes().get(position));
    }

    public Class<?> generic(String genericName) {
        return this.resolveClass(this.contextGenerics().get(this.checkGenericName(genericName)));
    }

    public String genericAsString(int position) {
        return this.toStringType(this.genericType(position));
    }

    public String genericAsString(String genericName) {
        return this.toStringType(this.contextGenerics().get(this.checkGenericName(genericName)));
    }

    public Map<String, Type> genericsMap() {
        return new LinkedHashMap<String, Type>(this.typeGenerics);
    }

    public Map<String, Type> visibleGenericsMap() {
        return new LinkedHashMap<String, Type>(this.contextGenerics());
    }

    public GenericsInfo getGenericsInfo() {
        return this.genericsInfo;
    }

    public Class<?> resolveClass(Type type) {
        return GenericsUtils.resolveClass(type, this.chooseContext(type).contextGenerics());
    }

    public Class<?> resolveFieldClass(Field field) {
        return this.switchContext4field(field).resolveClass(field.getGenericType());
    }

    public List<Class<?>> resolveGenericsOf(Type type) {
        return GenericsUtils.resolveGenericsOf(type, this.chooseContext(type).contextGenerics());
    }

    public List<Class<?>> resolveFieldGenerics(Field field) {
        return this.switchContext4field(field).resolveGenericsOf(field.getGenericType());
    }

    public Class<?> resolveGenericOf(Type type) {
        List<Class<?>> res = this.resolveGenericsOf(type);
        return res.isEmpty() ? null : res.get(0);
    }

    public Class<?> resolveFieldGeneric(Field field) {
        return this.switchContext4field(field).resolveGenericOf(field.getGenericType());
    }

    public Type resolveFieldType(Field field) {
        return this.switchContext4field(field).resolveType(field.getGenericType());
    }

    public Type resolveType(Type type) {
        return GenericsUtils.resolveTypeVariables(type, this.chooseContext(type).contextGenerics());
    }

    public List<Type> resolveTypeGenerics(Type type) {
        Map<String, Type> generics = this.chooseContext(type).contextGenerics();
        return Arrays.asList(GenericsUtils.resolveTypeVariables(GenericsUtils.getGenerics(type, generics), generics));
    }

    public String toStringType(Type type) {
        return TypeToStringUtils.toStringType(type, this.chooseContext(type).contextGenerics());
    }

    public abstract GenericsContext type(Class<?> var1);

    public abstract MethodGenericsContext method(Method var1);

    public abstract ConstructorGenericsContext constructor(Constructor var1);

    public GenericsContext fieldType(Field field) {
        return this.switchContext4field(field).inlyingType(field.getGenericType());
    }

    public GenericsContext fieldTypeAs(Field field, Class<?> asType) {
        return this.switchContext4field(field).inlyingTypeAs(field.getGenericType(), asType);
    }

    public abstract GenericsContext inlyingType(Type var1);

    public abstract GenericsContext inlyingTypeAs(Type var1, Class<?> var2);

    public abstract GenericsContext chooseContext(Type var1);

    public String toStringCurrentClass() {
        return TypeToStringUtils.toStringWithGenerics(this.currentType, this.typeGenerics);
    }

    public String toStringCurrentClassDeclaration() {
        return TypeToStringUtils.toStringWithNamedGenerics(this.currentType);
    }

    public abstract GenericDeclarationScope getGenericsScope();

    public abstract GenericDeclaration getGenericsSource();

    protected abstract Map<String, Type> contextGenerics();

    protected abstract GenericsContext switchContext(Class var1, String var2);

    private GenericsContext switchContext4field(Field field) {
        return this.switchContext(field.getDeclaringClass(), "Field '" + field.getName() + "'");
    }

    private String checkGenericName(String genericName) {
        if (!this.contextGenerics().containsKey(genericName)) {
            throw new UnknownGenericException(this.currentType, genericName, null);
        }
        return genericName;
    }
}

