
package ru.yandex.qatools.allure.model;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for parameter-kind.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="parameter-kind">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="argument"/>
 *     &lt;enumeration value="system-property"/>
 *     &lt;enumeration value="environment-variable"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "parameter-kind")
@XmlEnum
public enum ParameterKind {

    @XmlEnumValue("argument")
    ARGUMENT("argument"),
    @XmlEnumValue("system-property")
    SYSTEM_PROPERTY("system-property"),
    @XmlEnumValue("environment-variable")
    ENVIRONMENT_VARIABLE("environment-variable");
    private final String value;

    ParameterKind(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static ParameterKind fromValue(String v) {
        for (ParameterKind c: ParameterKind.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
