
package ru.yandex.qatools.allure.model;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for severity-level.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="severity-level">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="blocker"/>
 *     &lt;enumeration value="critical"/>
 *     &lt;enumeration value="normal"/>
 *     &lt;enumeration value="minor"/>
 *     &lt;enumeration value="trivial"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "severity-level")
@XmlEnum
public enum SeverityLevel {

    @XmlEnumValue("blocker")
    BLOCKER("blocker"),
    @XmlEnumValue("critical")
    CRITICAL("critical"),
    @XmlEnumValue("normal")
    NORMAL("normal"),
    @XmlEnumValue("minor")
    MINOR("minor"),
    @XmlEnumValue("trivial")
    TRIVIAL("trivial");
    private final String value;

    SeverityLevel(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static SeverityLevel fromValue(String v) {
        for (SeverityLevel c: SeverityLevel.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
