/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.loader.decorator;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;
import ru.yandex.qatools.htmlelements.loader.HtmlElementLoader;
import ru.yandex.qatools.htmlelements.loader.decorator.ProxyFactory;
import ru.yandex.qatools.htmlelements.loader.decorator.proxyhandlers.HtmlElementListNamedProxyHandler;
import ru.yandex.qatools.htmlelements.loader.decorator.proxyhandlers.TypifiedElementListNamedProxyHandler;
import ru.yandex.qatools.htmlelements.loader.decorator.proxyhandlers.WebElementListNamedProxyHandler;
import ru.yandex.qatools.htmlelements.loader.decorator.proxyhandlers.WebElementNamedProxyHandler;
import ru.yandex.qatools.htmlelements.pagefactory.CustomElementLocatorFactory;
import ru.yandex.qatools.htmlelements.utils.HtmlElementUtils;

public class HtmlElementDecorator
implements FieldDecorator {
    protected ElementLocatorFactory factory;

    public HtmlElementDecorator(CustomElementLocatorFactory factory) {
        this.factory = factory;
    }

    public Object decorate(ClassLoader loader, Field field) {
        try {
            if (HtmlElementUtils.isTypifiedElement(field)) {
                return this.decorateTypifiedElement(loader, field);
            }
            if (HtmlElementUtils.isHtmlElement(field)) {
                return this.decorateHtmlElement(loader, field);
            }
            if (HtmlElementUtils.isWebElement(field) && !field.getName().equals("wrappedElement")) {
                return this.decorateWebElement(loader, field);
            }
            if (HtmlElementUtils.isTypifiedElementList(field)) {
                return this.decorateTypifiedElementList(loader, field);
            }
            if (HtmlElementUtils.isHtmlElementList(field)) {
                return this.decorateHtmlElementList(loader, field);
            }
            if (HtmlElementUtils.isWebElementList(field)) {
                return this.decorateWebElementList(loader, field);
            }
            return null;
        }
        catch (ClassCastException ignore) {
            return null;
        }
    }

    protected <T extends TypifiedElement> T decorateTypifiedElement(ClassLoader loader, Field field) {
        WebElement elementToWrap = this.decorateWebElement(loader, field);
        return (T)HtmlElementLoader.createTypifiedElement(field.getType(), elementToWrap, HtmlElementUtils.getElementName(field));
    }

    protected <T extends HtmlElement> T decorateHtmlElement(ClassLoader loader, Field field) {
        WebElement elementToWrap = this.decorateWebElement(loader, field);
        return (T)HtmlElementLoader.createHtmlElement(field.getType(), elementToWrap, HtmlElementUtils.getElementName(field));
    }

    protected WebElement decorateWebElement(ClassLoader loader, Field field) {
        ElementLocator locator = this.factory.createLocator(field);
        WebElementNamedProxyHandler handler = new WebElementNamedProxyHandler(locator, HtmlElementUtils.getElementName(field));
        return ProxyFactory.createWebElementProxy(loader, (InvocationHandler)((Object)handler));
    }

    protected <T extends TypifiedElement> List<T> decorateTypifiedElementList(ClassLoader loader, Field field) {
        Class elementClass = HtmlElementUtils.getGenericParameterClass(field);
        ElementLocator locator = this.factory.createLocator(field);
        String name = HtmlElementUtils.getElementName(field);
        TypifiedElementListNamedProxyHandler handler = new TypifiedElementListNamedProxyHandler(elementClass, locator, name);
        return ProxyFactory.createTypifiedElementListProxy(loader, handler);
    }

    protected <T extends HtmlElement> List<T> decorateHtmlElementList(ClassLoader loader, Field field) {
        Class elementClass = HtmlElementUtils.getGenericParameterClass(field);
        ElementLocator locator = this.factory.createLocator(field);
        String name = HtmlElementUtils.getElementName(field);
        HtmlElementListNamedProxyHandler handler = new HtmlElementListNamedProxyHandler(elementClass, locator, name);
        return ProxyFactory.createHtmlElementListProxy(loader, handler);
    }

    protected List<WebElement> decorateWebElementList(ClassLoader loader, Field field) {
        ElementLocator locator = this.factory.createLocator(field);
        WebElementListNamedProxyHandler handler = new WebElementListNamedProxyHandler(locator, HtmlElementUtils.getElementName(field));
        return ProxyFactory.createWebElementListProxy(loader, (InvocationHandler)((Object)handler));
    }
}

