/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.loader.decorator;

import java.lang.reflect.Field;
import org.openqa.selenium.By;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.Annotations;
import ru.yandex.qatools.htmlelements.exceptions.HtmlElementsException;
import ru.yandex.qatools.htmlelements.utils.HtmlElementUtils;

public class HtmlElementFieldAnnotationsHandler
extends Annotations {
    public HtmlElementFieldAnnotationsHandler(Field field) {
        super(field);
    }

    public By buildBy() {
        if (HtmlElementUtils.isHtmlElement(this.getField()) || HtmlElementUtils.isTypifiedElement(this.getField())) {
            return this.buildByFromHtmlElementAnnotations();
        }
        if (HtmlElementUtils.isHtmlElementList(this.getField()) || HtmlElementUtils.isTypifiedElementList(this.getField())) {
            return this.buildByFromHtmlElementListAnnotations();
        }
        return super.buildBy();
    }

    private By buildByFromFindAnnotations() {
        if (this.getField().isAnnotationPresent(FindBys.class)) {
            FindBys findBys = this.getField().getAnnotation(FindBys.class);
            return new FindBys.FindByBuilder().buildIt((Object)findBys, null);
        }
        if (this.getField().isAnnotationPresent(FindAll.class)) {
            FindAll findAll = this.getField().getAnnotation(FindAll.class);
            return new FindAll.FindByBuilder().buildIt((Object)findAll, null);
        }
        if (this.getField().isAnnotationPresent(FindBy.class)) {
            FindBy findBy = this.getField().getAnnotation(FindBy.class);
            return new FindBy.FindByBuilder().buildIt((Object)findBy, null);
        }
        return null;
    }

    private By buildByFromHtmlElementAnnotations() {
        this.assertValidAnnotations();
        By result = this.buildByFromFindAnnotations();
        if (result != null) {
            return result;
        }
        for (Class<?> fieldClass = this.getField().getType(); fieldClass != Object.class; fieldClass = fieldClass.getSuperclass()) {
            if (!fieldClass.isAnnotationPresent(FindBy.class)) continue;
            return new FindBy.FindByBuilder().buildIt((Object)fieldClass.getAnnotation(FindBy.class), null);
        }
        return this.buildByFromDefault();
    }

    private By buildByFromHtmlElementListAnnotations() {
        this.assertValidAnnotations();
        By result = this.buildByFromFindAnnotations();
        if (result != null) {
            return result;
        }
        for (Class listParameterClass = HtmlElementUtils.getGenericParameterClass(this.getField()); listParameterClass != Object.class; listParameterClass = listParameterClass.getSuperclass()) {
            if (!listParameterClass.isAnnotationPresent(FindBy.class)) continue;
            return new FindBy.FindByBuilder().buildIt((Object)listParameterClass.getAnnotation(FindBy.class), null);
        }
        throw new HtmlElementsException(String.format("Cannot determine how to locate element %s", this.getField()));
    }
}

