/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.loader.decorator.proxyhandlers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;
import ru.yandex.qatools.htmlelements.loader.HtmlElementLoader;

public class TypifiedElementListNamedProxyHandler<T extends TypifiedElement>
implements InvocationHandler {
    private final Class<T> elementClass;
    private final ElementLocator locator;
    private final String name;

    public TypifiedElementListNamedProxyHandler(Class<T> elementClass, ElementLocator locator, String name) {
        this.elementClass = elementClass;
        this.locator = locator;
        this.name = name;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        if ("toString".equals(method.getName())) {
            return this.name;
        }
        LinkedList<T> elements = new LinkedList<T>();
        int elementNumber = 0;
        for (WebElement element : this.locator.findElements()) {
            String newName = String.format("%s [%d]", this.name, elementNumber++);
            elements.add(HtmlElementLoader.createTypifiedElement(this.elementClass, element, newName));
        }
        try {
            return method.invoke(elements, objects);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

