/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.loader.decorator.proxyhandlers;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementHandler;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.SystemClock;

public class WebElementNamedProxyHandler
extends LocatingElementHandler {
    public static final int DEFAULT_TIMEOUT = 5;
    private final long timeOutInSeconds;
    private final Clock clock;
    private final String name;

    public WebElementNamedProxyHandler(ElementLocator locator, String name) {
        super(locator);
        this.name = name;
        this.clock = new SystemClock();
        this.timeOutInSeconds = Integer.getInteger("webdriver.timeouts.implicitlywait", 5).intValue();
    }

    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        if ("toString".equals(method.getName())) {
            return this.name;
        }
        long end = this.clock.laterBy(TimeUnit.SECONDS.toMillis(this.timeOutInSeconds));
        StaleElementReferenceException lasException = null;
        while (this.clock.isNowBefore(end)) {
            try {
                return super.invoke(o, method, objects);
            }
            catch (StaleElementReferenceException e) {
                lasException = e;
                this.waitFor();
            }
        }
        throw lasException;
    }

    protected long sleepFor() {
        return 500L;
    }

    private void waitFor() throws InterruptedException {
        Thread.sleep(this.sleepFor());
    }
}

