/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.knn;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.max$;
import breeze.stats.MeanAndVariance;
import org.apache.log4j.Logger;
import org.apache.spark.ml.knn.KNN;
import org.apache.spark.ml.knn.KNN$;
import org.apache.spark.ml.knn.KNN$$anonfun$14$;
import org.apache.spark.ml.knn.MetricTree;
import org.apache.spark.ml.knn.Tree;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KNN$
implements Serializable {
    public static final KNN$ MODULE$;
    private final Logger logger;

    static {
        new KNN$();
    }

    public Logger logger() {
        return this.logger;
    }

    public double estimateTau(RDD<KNN.RowWithVector> data, int[] sampleSize, long seed) {
        double d;
        long total = data.count();
        RDD samples = data.mapPartitionsWithIndex((Function2)new Serializable(sampleSize, seed, total){
            public static final long serialVersionUID = 0L;
            public final int[] sampleSize$1;
            private final long seed$1;
            public final long total$1;

            public final Iterator<Tuple2<Object, KNN.RowWithVector>> apply(int x0$6, Iterator<KNN.RowWithVector> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$6), x1$1);
                if (tuple2 != null) {
                    int partitionId = tuple2._1$mcI$sp();
                    Iterator itr = (Iterator)tuple2._2();
                    XORShiftRandom rand = new XORShiftRandom(scala.util.hashing.package$.MODULE$.byteswap64(this.seed$1 ^ (long)partitionId));
                    Iterator iterator2 = itr.flatMap((Function1)new Serializable(this, rand){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.14 $outer;
                        public final XORShiftRandom rand$1;

                        public final ArrayOps<Tuple2<Object, KNN.RowWithVector>> apply(KNN.RowWithVector p) {
                            return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(this.$outer.sampleSize$1).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$14$$anonfun$apply$6 $outer;

                                public final boolean apply(Tuple2<Object, Object> x0$7) {
                                    Tuple2<Object, Object> tuple2 = x0$7;
                                    if (tuple2 != null) {
                                        int size = tuple2._1$mcI$sp();
                                        boolean bl = this.$outer.rand$1.nextDouble() * (double)this.$outer.org$apache$spark$ml$knn$KNN$$anonfun$$anonfun$$$outer().total$1 < (double)size;
                                        return bl;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            })).map((Function1)new Serializable(this, p){
                                public static final long serialVersionUID = 0L;
                                private final KNN.RowWithVector p$1;

                                public final Tuple2<Object, KNN.RowWithVector> apply(Tuple2<Object, Object> x0$8) {
                                    Tuple2<Object, Object> tuple2 = x0$8;
                                    if (tuple2 != null) {
                                        int index = tuple2._2$mcI$sp();
                                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), (Object)this.p$1);
                                        return tuple22;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    this.p$1 = p$1;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))));
                        }

                        public /* synthetic */ anonfun.14 org$apache$spark$ml$knn$KNN$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rand$1 = rand$1;
                        }
                    });
                    return iterator2;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.sampleSize$1 = sampleSize$1;
                this.seed$1 = seed$1;
                this.total$1 = total$1;
            }
        }, data.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        Tuple2[] estimators = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(samples, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(KNN.RowWithVector.class), (Ordering)Ordering.Int$.MODULE$).groupByKey().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Iterable<KNN.RowWithVector>> x0$9) {
                Tuple2<Object, Iterable<KNN.RowWithVector>> tuple2 = x0$9;
                if (tuple2 != null) {
                    Iterable points = (Iterable)tuple2._2();
                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(points.size(), KNN$.MODULE$.org$apache$spark$ml$knn$KNN$$computeAverageDistance((Iterable<KNN.RowWithVector>)points));
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).collect()).distinct();
        DenseVector x = DenseVector$.MODULE$.apply$mDc$sp((double[])Predef$.MODULE$.refArrayOps((Object[])estimators).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x0$10) {
                Tuple2<Object, Object> tuple2 = x0$10;
                if (tuple2 != null) {
                    int n = tuple2._1$mcI$sp();
                    double d = package$.MODULE$.log((double)n);
                    return d;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        DenseVector y = DenseVector$.MODULE$.apply$mDc$sp((double[])Predef$.MODULE$.refArrayOps((Object[])estimators).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x0$11) {
                Tuple2<Object, Object> tuple2 = x0$11;
                if (tuple2 != null) {
                    double d = tuple2._2$mcD$sp();
                    double d2 = package$.MODULE$.log(d);
                    return d2;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        MeanAndVariance xMeanVariance = (MeanAndVariance)breeze.stats.package$.MODULE$.meanAndVariance().apply((Object)x, breeze.stats.package$.MODULE$.meanAndVariance().reduce_Double(DenseVector$.MODULE$.canIterateValues()));
        double xmean = xMeanVariance.mean();
        MeanAndVariance yMeanVariance = (MeanAndVariance)breeze.stats.package$.MODULE$.meanAndVariance().apply((Object)y, breeze.stats.package$.MODULE$.meanAndVariance().reduce_Double(DenseVector$.MODULE$.canIterateValues()));
        double ymean = yMeanVariance.mean();
        double corr = (BoxesRunTime.unboxToDouble((Object)breeze.stats.package$.MODULE$.mean().apply(x.$colon$times((Object)y, DenseVector$.MODULE$.dv_dv_Op_Double_OpMulScalar()), breeze.stats.package$.MODULE$.mean().reduce_Double(DenseVector$.MODULE$.canIterateValues()))) - xmean * ymean) / package$.MODULE$.sqrt((BoxesRunTime.unboxToDouble((Object)breeze.stats.package$.MODULE$.mean().apply(x.$colon$times((Object)x, DenseVector$.MODULE$.dv_dv_Op_Double_OpMulScalar()), breeze.stats.package$.MODULE$.mean().reduce_Double(DenseVector$.MODULE$.canIterateValues()))) - xmean * xmean) * (BoxesRunTime.unboxToDouble((Object)breeze.stats.package$.MODULE$.mean().apply(y.$colon$times((Object)y, DenseVector$.MODULE$.dv_dv_Op_Double_OpMulScalar()), breeze.stats.package$.MODULE$.mean().reduce_Double(DenseVector$.MODULE$.canIterateValues()))) - ymean * ymean));
        double beta = corr * yMeanVariance.stdDev() / xMeanVariance.stdDev();
        double alpha = ymean - beta * xmean;
        double rs = package$.MODULE$.exp(alpha + beta * package$.MODULE$.log((double)total));
        if (beta > 0.0 || Predef$.MODULE$.double2Double(beta).isNaN() || Predef$.MODULE$.double2Double(rs).isNaN()) {
            double yMax = BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply((Object)y, max$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
            this.logger().error((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to estimate Tau with positive beta: ", ". This maybe because data is too small.\n            |Setting to ", " which is the maximum average distance we found in the sample.\n            |This may leads to poor accuracy. Consider manually set bufferSize instead.\n            |You can also try setting balanceThreshold to zero so only metric trees are built."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)beta), BoxesRunTime.boxToDouble((double)yMax)})))).stripMargin());
            d = yMax;
        } else {
            d = rs / package$.MODULE$.sqrt((double)-1 / beta);
        }
        return d;
    }

    public double org$apache$spark$ml$knn$KNN$$computeAverageDistance(Iterable<KNN.RowWithVector> points) {
        Iterable distances = (Iterable)((TraversableLike)points.map((Function1)new Serializable(points){
            public static final long serialVersionUID = 0L;
            private final Iterable points$1;

            public final double apply(KNN.RowWithVector point) {
                return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.points$1.map((Function1)new Serializable(this, point){
                    public static final long serialVersionUID = 0L;
                    private final KNN.RowWithVector point$1;

                    public final double apply(KNN.RowWithVector p) {
                        return p.vector().fastSquaredDistance(this.point$1.vector());
                    }
                    {
                        this.point$1 = point$1;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$6) {
                        return this.apply$mcZD$sp(x$6);
                    }

                    public boolean apply$mcZD$sp(double x$6) {
                        return x$6 > 0.0;
                    }
                })).min((Ordering)Ordering.Double$.MODULE$));
            }
            {
                this.points$1 = points$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return package$.MODULE$.sqrt(x);
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return BoxesRunTime.unboxToDouble((Object)distances.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)distances.size();
    }

    public int searchIndex(KNN.RowWithVector v, Tree tree, int acc) {
        Tree tree2;
        while ((tree2 = tree) instanceof MetricTree) {
            double rightDistance;
            MetricTree metricTree = (MetricTree)tree2;
            double leftDistance = metricTree.leftPivot().fastSquaredDistance(v.vector());
            if (leftDistance < (rightDistance = metricTree.rightPivot().fastSquaredDistance(v.vector()))) {
                tree = metricTree.leftChild();
                continue;
            }
            acc += metricTree.leftChild().leafCount();
            tree = metricTree.rightChild();
        }
        int n = acc;
        return n;
    }

    public int searchIndex$default$3() {
        return 0;
    }

    public Seq<Object> searchIndices(KNN.VectorWithNorm v, Tree tree, double tau, int acc) {
        Seq seq;
        Tree tree2 = tree;
        if (tree2 instanceof MetricTree) {
            MetricTree metricTree = (MetricTree)tree2;
            double leftDistance = metricTree.leftPivot().fastDistance(v);
            double rightDistance = metricTree.rightPivot().fastDistance(v);
            ArrayBuffer buffer = new ArrayBuffer();
            Object object = leftDistance - rightDistance <= tau ? buffer.$plus$plus$eq(this.searchIndices(v, metricTree.leftChild(), tau, acc)) : BoxedUnit.UNIT;
            Object object2 = rightDistance - leftDistance <= tau ? buffer.$plus$plus$eq(this.searchIndices(v, metricTree.rightChild(), tau, acc + metricTree.leftChild().leafCount())) : BoxedUnit.UNIT;
            seq = buffer;
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{acc}));
        }
        return seq;
    }

    public int searchIndices$default$4() {
        return 0;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private KNN$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(KNN.class);
    }
}

