/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.knn;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.KNNClassificationModel;
import org.apache.spark.ml.knn.KNNModelParams;
import org.apache.spark.ml.knn.KNNModelParams$class;
import org.apache.spark.ml.knn.Tree;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasInputCols;
import org.apache.spark.ml.regression.KNNRegressionModel;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u00015\u0011\u0001b\u0013(O\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\t1a\u001b8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003E\u0002\u0010!Ii\u0011\u0001B\u0005\u0003#\u0011\u0011Q!T8eK2\u0004\"a\u0005\u0001\u000e\u0003\t\u0001\"aE\u000b\n\u0005Y\u0011!AD&O\u001d6{G-\u001a7QCJ\fWn\u001d\u0005\t1\u0001\u0011)\u0019!C!3\u0005\u0019Q/\u001b3\u0016\u0003i\u0001\"aG\u0011\u000f\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0002\rA\u0013X\rZ3g\u0013\t\u00113E\u0001\u0004TiJLgn\u001a\u0006\u0003AuA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0005k&$\u0007\u0005\u0003\u0005(\u0001\t\u0015\r\u0011\"\u0001)\u0003\u001d!x\u000e\u001d+sK\u0016,\u0012!\u000b\t\u0004U5zS\"A\u0016\u000b\u000512\u0011!\u00032s_\u0006$7-Y:u\u0013\tq3FA\u0005Ce>\fGmY1tiB\u00111\u0003M\u0005\u0003c\t\u0011A\u0001\u0016:fK\"A1\u0007\u0001B\u0001B\u0003%\u0011&\u0001\u0005u_B$&/Z3!\u0011!)\u0004A!b\u0001\n\u00031\u0014\u0001C:vER\u0013X-Z:\u0016\u0003]\u00022\u0001O\u001e0\u001b\u0005I$B\u0001\u001e\u0007\u0003\r\u0011H\rZ\u0005\u0003ye\u00121A\u0015#E\u0011!q\u0004A!A!\u0002\u00139\u0014!C:vER\u0013X-Z:!\u0011\u0019\u0001\u0005\u0001\"\u0001\u0005\u0003\u00061A(\u001b8jiz\"BA\u0005\"D\t\")\u0001d\u0010a\u00015!)qe\u0010a\u0001S!)Qg\u0010a\u0001o!)a\t\u0001C\u0001\u000f\u0006y1/\u001a;OK&<\u0007NY8sg\u000e{G\u000e\u0006\u0002I\u00136\t\u0001\u0001C\u0003K\u000b\u0002\u0007!$A\u0003wC2,X\rC\u0003M\u0001\u0011\u0005Q*\u0001\btKR$\u0015n\u001d;b]\u000e,7i\u001c7\u0015\u0005!s\u0005\"\u0002&L\u0001\u0004Q\u0002\"\u0002)\u0001\t\u0003\t\u0016\u0001B:fi.#\"\u0001\u0013*\t\u000b){\u0005\u0019A*\u0011\u0005q!\u0016BA+\u001e\u0005\rIe\u000e\u001e\u0005\u0006/\u0002!\t\u0001W\u0001\u000fg\u0016$X*\u0019=ESN$\u0018M\\2f)\tA\u0015\fC\u0003K-\u0002\u0007!\f\u0005\u0002\u001d7&\u0011A,\b\u0002\u0007\t>,(\r\\3\t\u000by\u0003A\u0011A0\u0002\u001bM,GOQ;gM\u0016\u00148+\u001b>f)\tA\u0005\rC\u0003K;\u0002\u0007!\fC\u0003c\u0001\u0011\u00053-A\u0005ue\u0006t7OZ8s[R\u0011A\r\u001f\t\u0003KVt!A\u001a:\u000f\u0005\u001d\u0004hB\u00015p\u001d\tIgN\u0004\u0002k[6\t1N\u0003\u0002m\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005E4\u0011aA:rY&\u00111\u000f^\u0001\ba\u0006\u001c7.Y4f\u0015\t\th!\u0003\u0002wo\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003gRDQ!_1A\u0002i\fq\u0001Z1uCN,G\u000fM\u0002|\u0003\u0007\u00012\u0001`?\u0000\u001b\u0005!\u0018B\u0001@u\u0005\u001d!\u0015\r^1tKR\u0004B!!\u0001\u0002\u00041\u0001AaCA\u0003q\u0006\u0005\t\u0011!B\u0001\u0003\u000f\u00111a\u0018\u00133#\u0011\tI!a\u0004\u0011\u0007q\tY!C\u0002\u0002\u000eu\u0011qAT8uQ&tw\rE\u0002\u001d\u0003#I1!a\u0005\u001e\u0005\r\te.\u001f\u0005\b\u0003/\u0001A\u0011IA\r\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BA\u000e\u0003O\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C!\u0018!\u0002;za\u0016\u001c\u0018\u0002BA\u0013\u0003?\u0011!b\u0015;sk\u000e$H+\u001f9f\u0011!\tI#!\u0006A\u0002\u0005m\u0011AB:dQ\u0016l\u0017\rC\u0004\u0002.\u0001!\t%a\f\u0002\t\r|\u0007/\u001f\u000b\u0004%\u0005E\u0002\u0002CA\u001a\u0003W\u0001\r!!\u000e\u0002\u000b\u0015DHO]1\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f\u0005\u0003\u0015\u0001\u0018M]1n\u0013\u0011\ty$!\u000f\u0003\u0011A\u000b'/Y7NCBDq!a\u0011\u0001\t\u0003\t)%\u0001\ru_:+wo\u00117bgNLg-[2bi&|g.T8eK2$b!a\u0012\u0002T\u0005U\u0003\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055C!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\n\t\u0005E\u00131\n\u0002\u0017\u0017:s5\t\\1tg&4\u0017nY1uS>tWj\u001c3fY\"1\u0001$!\u0011A\u0002iAq!a\u0016\u0002B\u0001\u00071+\u0001\u0006ok6\u001cE.Y:tKNDq!a\u0017\u0001\t\u0003\ti&\u0001\u000bu_:+wOU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\u000b\u0005\u0003?\nY\u0007\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)\u0007B\u0001\u000be\u0016<'/Z:tS>t\u0017\u0002BA5\u0003G\u0012!c\u0013(O%\u0016<'/Z:tS>tWj\u001c3fY\"1\u0001$!\u0017A\u0002i\u0001")
public class KNNModel
extends Model<KNNModel>
implements KNNModelParams {
    private final String uid;
    private final Broadcast<Tree> topTree;
    private final RDD<Tree> subTrees;
    private final Param<String> neighborsCol;
    private final Param<String> distanceCol;
    private final IntParam k;
    private final DoubleParam maxDistance;
    private final DoubleParam bufferSize;
    private final StringArrayParam inputCols;
    private final Param<String> featuresCol;

    @Override
    public Param<String> neighborsCol() {
        return this.neighborsCol;
    }

    @Override
    public Param<String> distanceCol() {
        return this.distanceCol;
    }

    @Override
    public IntParam k() {
        return this.k;
    }

    @Override
    public DoubleParam maxDistance() {
        return this.maxDistance;
    }

    @Override
    public DoubleParam bufferSize() {
        return this.bufferSize;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNModelParams$_setter_$neighborsCol_$eq(Param x$1) {
        this.neighborsCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNModelParams$_setter_$distanceCol_$eq(Param x$1) {
        this.distanceCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNModelParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNModelParams$_setter_$maxDistance_$eq(DoubleParam x$1) {
        this.maxDistance = x$1;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNModelParams$_setter_$bufferSize_$eq(DoubleParam x$1) {
        this.bufferSize = x$1;
    }

    @Override
    public String getNeighborsCol() {
        return KNNModelParams$class.getNeighborsCol(this);
    }

    @Override
    public String getDistanceCol() {
        return KNNModelParams$class.getDistanceCol(this);
    }

    @Override
    public int getK() {
        return KNNModelParams$class.getK(this);
    }

    @Override
    public double getMaxDistance() {
        return KNNModelParams$class.getMaxDistance(this);
    }

    @Override
    public double getBufferSize() {
        return KNNModelParams$class.getBufferSize(this);
    }

    @Override
    public RDD<Tuple2<Object, Tuple2<Row, Object>[]>> transform(RDD<Vector> data, Broadcast<Tree> topTree, RDD<Tree> subTrees) {
        return KNNModelParams$class.transform((KNNModelParams)this, data, topTree, subTrees);
    }

    @Override
    public RDD<Tuple2<Object, Tuple2<Row, Object>[]>> transform(Dataset<?> dataset, Broadcast<Tree> topTree, RDD<Tree> subTrees) {
        return KNNModelParams$class.transform((KNNModelParams)this, dataset, topTree, subTrees);
    }

    public final StringArrayParam inputCols() {
        return this.inputCols;
    }

    public final void org$apache$spark$ml$param$shared$HasInputCols$_setter_$inputCols_$eq(StringArrayParam x$1) {
        this.inputCols = x$1;
    }

    public final String[] getInputCols() {
        return HasInputCols.class.getInputCols((HasInputCols)this);
    }

    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    public final String getFeaturesCol() {
        return HasFeaturesCol.class.getFeaturesCol((HasFeaturesCol)this);
    }

    public String uid() {
        return this.uid;
    }

    public Broadcast<Tree> topTree() {
        return this.topTree;
    }

    public RDD<Tree> subTrees() {
        return this.subTrees;
    }

    public KNNModel setNeighborsCol(String value) {
        return (KNNModel)this.set(this.neighborsCol(), value);
    }

    public KNNModel setDistanceCol(String value) {
        return (KNNModel)this.set(this.distanceCol(), value);
    }

    public KNNModel setK(int value) {
        return (KNNModel)this.set((Param)this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public KNNModel setMaxDistance(double value) {
        return (KNNModel)this.set((Param)this.maxDistance(), BoxesRunTime.boxToDouble((double)value));
    }

    public KNNModel setBufferSize(double value) {
        return (KNNModel)this.set((Param)this.bufferSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        RDD<Tuple2<Object, Tuple2<Row, Object>[]>> merged = this.transform(dataset, this.topTree(), this.subTrees());
        boolean withDistance = new StringOps(Predef$.MODULE$.augmentString((String)this.$(this.distanceCol()))).nonEmpty();
        return dataset.sqlContext().createDataFrame(RDD$.MODULE$.rddToPairRDDFunctions(dataset.toDF().rdd().zipWithIndex().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Row> apply(Tuple2<Row, Object> x0$4) {
                Tuple2<Row, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    Row row = (Row)tuple2._1();
                    long i = tuple2._2$mcJ$sp();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)i), (Object)row);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Row.class), (Ordering)Ordering.Long$.MODULE$).leftOuterJoin(merged).map((Function1)new Serializable(this, withDistance){
            public static final long serialVersionUID = 0L;
            private final boolean withDistance$1;

            public final Row apply(Tuple2<Object, Tuple2<Row, Option<Tuple2<Row, Object>[]>>> x0$5) {
                Tuple2 tuple2;
                Tuple2<Object, Tuple2<Row, Option<Tuple2<Row, Object>[]>>> tuple22 = x0$5;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                    Row row = (Row)tuple2._1();
                    Option neighborsAndDistances = (Option)tuple2._2();
                    Tuple2 tuple23 = (Tuple2)neighborsAndDistances.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Row[], double[]> apply(Tuple2<Row, Object>[] x$4) {
                            return Predef$.MODULE$.refArrayOps((Object[])x$4).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(Row.class), ClassTag$.MODULE$.Double());
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Row[], double[]> apply() {
                            return new Tuple2(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Row.class)), Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                        }
                    });
                    if (tuple23 != null) {
                        Tuple2 tuple24;
                        Row[] neighbors = (Row[])tuple23._1();
                        double[] distances = (double[])tuple23._2();
                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)neighbors, (Object)distances);
                        Row[] neighbors2 = (Row[])tuple25._1();
                        double[] distances2 = (double[])tuple25._2();
                        Row row2 = this.withDistance$1 ? Row$.MODULE$.fromSeq((Seq)((SeqLike)row.toSeq().$colon$plus((Object)neighbors2, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)distances2, Seq$.MODULE$.canBuildFrom())) : Row$.MODULE$.fromSeq((Seq)row.toSeq().$colon$plus((Object)neighbors2, Seq$.MODULE$.canBuildFrom()));
                        return row2;
                    }
                    throw new MatchError((Object)tuple23);
                }
                throw new MatchError(tuple22);
            }
            {
                this.withDistance$1 = withDistance$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class)), this.transformSchema(dataset.schema()));
    }

    public StructType transformSchema(StructType schema) {
        StructField[] auxFeatures = (StructField[])Predef$.MODULE$.refArrayOps((Object[])this.$((Param)this.inputCols())).map((Function1)new Serializable(this, schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final StructField apply(String c) {
                return this.schema$1.apply(c);
            }
            {
                this.schema$1 = schema$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        StructType schemaWithNeighbors = SchemaUtils$.MODULE$.appendColumn(schema, (String)this.$(this.neighborsCol()), (DataType)ArrayType$.MODULE$.apply((DataType)new StructType(auxFeatures)), SchemaUtils$.MODULE$.appendColumn$default$4());
        return ((String)this.$(this.distanceCol())).isEmpty() ? schemaWithNeighbors : SchemaUtils$.MODULE$.appendColumn(schemaWithNeighbors, (String)this.$(this.distanceCol()), (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    public KNNModel copy(ParamMap extra) {
        KNNModel copied = new KNNModel(this.uid(), this.topTree(), this.subTrees());
        return (KNNModel)((Model)this.copyValues((Params)copied, extra)).setParent(this.parent());
    }

    public KNNClassificationModel toNewClassificationModel(String uid, int numClasses) {
        return (KNNClassificationModel)this.copyValues((Params)new KNNClassificationModel(uid, this.topTree(), this.subTrees(), numClasses), this.copyValues$default$2());
    }

    public KNNRegressionModel toNewRegressionModel(String uid) {
        return (KNNRegressionModel)this.copyValues((Params)new KNNRegressionModel(uid, this.topTree(), this.subTrees()), this.copyValues$default$2());
    }

    public KNNModel(String uid, Broadcast<Tree> topTree, RDD<Tree> subTrees) {
        this.uid = uid;
        this.topTree = topTree;
        this.subTrees = subTrees;
        HasFeaturesCol.class.$init$((HasFeaturesCol)this);
        HasInputCols.class.$init$((HasInputCols)this);
        KNNModelParams$class.$init$(this);
        StorageLevel storageLevel = subTrees.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        Predef$.MODULE$.require(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "KNNModel is not designed to work with Trees that have not been cached";
            }
        });
    }
}

