/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.knn.KNN;
import org.apache.spark.ml.knn.KNNModelParams;
import org.apache.spark.ml.knn.KNNModelParams$class;
import org.apache.spark.ml.knn.KNNParams;
import org.apache.spark.ml.knn.KNNParams$class;
import org.apache.spark.ml.knn.Tree;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntArrayParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.param.shared.HasInputCols;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.KNNRegressionModel;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u00015\u0011Qb\u0013(O%\u0016<'/Z:tS>t'BA\u0002\u0005\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001du\u0019\u0003#B\b\u0011%aQR\"\u0001\u0003\n\u0005E!!!\u0003)sK\u0012L7\r^8s!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0004mS:\fGnZ\u0005\u0003/Q\u0011aAV3di>\u0014\bCA\r\u0001\u001b\u0005\u0011\u0001CA\r\u001c\u0013\ta\"A\u0001\nL\u001d:\u0013Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0005\u0003\rYgN\\\u0005\u0003E}\u0011\u0011b\u0013(O!\u0006\u0014\u0018-\\:\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013AB:iCJ,GM\u0003\u0002)\t\u0005)\u0001/\u0019:b[&\u0011!&\n\u0002\r\u0011\u0006\u001cx+Z5hQR\u001cu\u000e\u001c\u0005\tY\u0001\u0011)\u0019!C![\u0005\u0019Q/\u001b3\u0016\u00039\u0002\"aL\u001b\u000f\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0002\rA\u0013X\rZ3g\u0013\t1tG\u0001\u0004TiJLgn\u001a\u0006\u0003iEB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAL\u0001\u0005k&$\u0007\u0005C\u0003<\u0001\u0011\u0005A(\u0001\u0004=S:LGO\u0010\u000b\u00031uBQ\u0001\f\u001eA\u00029BQa\u000f\u0001\u0005\u0002}\"\u0012\u0001\u0007\u0005\u0006\u0003\u0002!\tEQ\u0001\u000fg\u0016$h)Z1ukJ,7oQ8m)\t\u0019E)D\u0001\u0001\u0011\u0015)\u0005\t1\u0001/\u0003\u00151\u0018\r\\;f\u0011\u00159\u0005\u0001\"\u0011I\u0003-\u0019X\r\u001e'bE\u0016d7i\u001c7\u0015\u0005\rK\u0005\"B#G\u0001\u0004q\u0003\"B&\u0001\t\u0003a\u0015\u0001D:fi^+\u0017n\u001a5u\u0007>dGCA\"N\u0011\u0015)%\n1\u0001/\u0011\u0015y\u0005\u0001\"\u0001Q\u0003\u0011\u0019X\r^&\u0015\u0005\r\u000b\u0006\"B#O\u0001\u0004\u0011\u0006C\u0001\u0019T\u0013\t!\u0016GA\u0002J]RDQA\u0016\u0001\u0005\u0002]\u000bab]3u)>\u0004HK]3f'&TX\r\u0006\u0002D1\")Q)\u0016a\u0001%\")!\f\u0001C\u00017\u0006\u00112/\u001a;U_B$&/Z3MK\u000647+\u001b>f)\t\u0019E\fC\u0003F3\u0002\u0007!\u000bC\u0003_\u0001\u0011\u0005q,\u0001\ntKR\u001cVO\u0019+sK\u0016dU-\u00194TSj,GCA\"a\u0011\u0015)U\f1\u0001S\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003a\u0019X\r\u001e\"vM\u001a,'oU5{KN\u000bW\u000e\u001d7f'&TXm\u001d\u000b\u0003\u0007\u0012DQ!R1A\u0002\u0015\u00042\u0001\r4S\u0013\t9\u0017GA\u0003BeJ\f\u0017\u0010C\u0003j\u0001\u0011\u0005!.A\ntKR\u0014\u0015\r\\1oG\u0016$\u0006N]3tQ>dG\r\u0006\u0002DW\")Q\t\u001ba\u0001YB\u0011\u0001'\\\u0005\u0003]F\u0012a\u0001R8vE2,\u0007\"\u00029\u0001\t\u0003\t\u0018aB:fiN+W\r\u001a\u000b\u0003\u0007JDQ!R8A\u0002M\u0004\"\u0001\r;\n\u0005U\f$\u0001\u0002'p]\u001eDQa\u001e\u0001\u0005Ra\fQ\u0001\u001e:bS:$\"AG=\t\u000bi4\b\u0019A>\u0002\u000f\u0011\fG/Y:fiB\u001aA0!\u0003\u0011\u000bu\f\t!!\u0002\u000e\u0003yT!a \u0004\u0002\u0007M\fH.C\u0002\u0002\u0004y\u0014q\u0001R1uCN,G\u000f\u0005\u0003\u0002\b\u0005%A\u0002\u0001\u0003\f\u0003\u0017I\u0018\u0011!A\u0001\u0006\u0003\tiAA\u0002`IE\nB!a\u0004\u0002\u0016A\u0019\u0001'!\u0005\n\u0007\u0005M\u0011GA\u0004O_RD\u0017N\\4\u0011\u0007A\n9\"C\u0002\u0002\u001aE\u00121!\u00118z\u0011\u001d\ti\u0002\u0001C!\u0003?\t1AZ5u)\rQ\u0012\u0011\u0005\u0005\bu\u0006m\u0001\u0019AA\u0012a\u0011\t)#!\u000b\u0011\u000bu\f\t!a\n\u0011\t\u0005\u001d\u0011\u0011\u0006\u0003\r\u0003W\t\t#!A\u0001\u0002\u000b\u0005\u0011Q\u0002\u0002\u0004?\u0012\u0012\u0004bBA\u0018\u0001\u0011\u0005\u0013\u0011G\u0001\u0005G>\u0004\u0018\u0010F\u0002\u0019\u0003gA\u0001\"!\u000e\u0002.\u0001\u0007\u0011qG\u0001\u0006Kb$(/\u0019\t\u0005\u0003s\tY$D\u0001(\u0013\r\tid\n\u0002\t!\u0006\u0014\u0018-\\'ba\u0002")
public class KNNRegression
extends Predictor<Vector, KNNRegression, KNNRegressionModel>
implements KNNParams,
HasWeightCol {
    private final String uid;
    private final Param<String> weightCol;
    private final IntParam topTreeSize;
    private final IntParam topTreeLeafSize;
    private final IntParam subTreeLeafSize;
    private final IntArrayParam bufferSizeSampleSizes;
    private final DoubleParam balanceThreshold;
    private final LongParam seed;
    private final Param<String> neighborsCol;
    private final Param<String> distanceCol;
    private final IntParam k;
    private final DoubleParam maxDistance;
    private final DoubleParam bufferSize;
    private final StringArrayParam inputCols;

    public final Param<String> weightCol() {
        return this.weightCol;
    }

    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    public final String getWeightCol() {
        return HasWeightCol.class.getWeightCol((HasWeightCol)this);
    }

    @Override
    public IntParam topTreeSize() {
        return this.topTreeSize;
    }

    @Override
    public IntParam topTreeLeafSize() {
        return this.topTreeLeafSize;
    }

    @Override
    public IntParam subTreeLeafSize() {
        return this.subTreeLeafSize;
    }

    @Override
    public IntArrayParam bufferSizeSampleSizes() {
        return this.bufferSizeSampleSizes;
    }

    @Override
    public DoubleParam balanceThreshold() {
        return this.balanceThreshold;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNParams$_setter_$topTreeSize_$eq(IntParam x$1) {
        this.topTreeSize = x$1;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNParams$_setter_$topTreeLeafSize_$eq(IntParam x$1) {
        this.topTreeLeafSize = x$1;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNParams$_setter_$subTreeLeafSize_$eq(IntParam x$1) {
        this.subTreeLeafSize = x$1;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNParams$_setter_$bufferSizeSampleSizes_$eq(IntArrayParam x$1) {
        this.bufferSizeSampleSizes = x$1;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNParams$_setter_$balanceThreshold_$eq(DoubleParam x$1) {
        this.balanceThreshold = x$1;
    }

    @Override
    public int getTopTreeSize() {
        return KNNParams$class.getTopTreeSize(this);
    }

    @Override
    public int getTopTreeLeafSize() {
        return KNNParams$class.getTopTreeLeafSize(this);
    }

    @Override
    public int getSubTreeLeafSize() {
        return KNNParams$class.getSubTreeLeafSize(this);
    }

    @Override
    public int[] getBufferSizeSampleSizes() {
        return KNNParams$class.getBufferSizeSampleSizes(this);
    }

    @Override
    public double getBalanceThreshold() {
        return KNNParams$class.getBalanceThreshold(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return KNNParams$class.validateAndTransformSchema(this, schema);
    }

    public final LongParam seed() {
        return this.seed;
    }

    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    public final long getSeed() {
        return HasSeed.class.getSeed((HasSeed)this);
    }

    @Override
    public Param<String> neighborsCol() {
        return this.neighborsCol;
    }

    @Override
    public Param<String> distanceCol() {
        return this.distanceCol;
    }

    @Override
    public IntParam k() {
        return this.k;
    }

    @Override
    public DoubleParam maxDistance() {
        return this.maxDistance;
    }

    @Override
    public DoubleParam bufferSize() {
        return this.bufferSize;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNModelParams$_setter_$neighborsCol_$eq(Param x$1) {
        this.neighborsCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNModelParams$_setter_$distanceCol_$eq(Param x$1) {
        this.distanceCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNModelParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNModelParams$_setter_$maxDistance_$eq(DoubleParam x$1) {
        this.maxDistance = x$1;
    }

    @Override
    public void org$apache$spark$ml$knn$KNNModelParams$_setter_$bufferSize_$eq(DoubleParam x$1) {
        this.bufferSize = x$1;
    }

    @Override
    public String getNeighborsCol() {
        return KNNModelParams$class.getNeighborsCol(this);
    }

    @Override
    public String getDistanceCol() {
        return KNNModelParams$class.getDistanceCol(this);
    }

    @Override
    public int getK() {
        return KNNModelParams$class.getK(this);
    }

    @Override
    public double getMaxDistance() {
        return KNNModelParams$class.getMaxDistance(this);
    }

    @Override
    public double getBufferSize() {
        return KNNModelParams$class.getBufferSize(this);
    }

    @Override
    public RDD<Tuple2<Object, Tuple2<Row, Object>[]>> transform(RDD<Vector> data, Broadcast<Tree> topTree, RDD<Tree> subTrees) {
        return KNNModelParams$class.transform((KNNModelParams)this, data, topTree, subTrees);
    }

    @Override
    public RDD<Tuple2<Object, Tuple2<Row, Object>[]>> transform(Dataset<?> dataset, Broadcast<Tree> topTree, RDD<Tree> subTrees) {
        return KNNModelParams$class.transform((KNNModelParams)this, dataset, topTree, subTrees);
    }

    public final StringArrayParam inputCols() {
        return this.inputCols;
    }

    public final void org$apache$spark$ml$param$shared$HasInputCols$_setter_$inputCols_$eq(StringArrayParam x$1) {
        this.inputCols = x$1;
    }

    public final String[] getInputCols() {
        return HasInputCols.class.getInputCols((HasInputCols)this);
    }

    public String uid() {
        return this.uid;
    }

    public KNNRegression setFeaturesCol(String value) {
        return (KNNRegression)this.set(this.featuresCol(), value);
    }

    public KNNRegression setLabelCol(String value) {
        this.set(this.labelCol(), value);
        return ((String)this.$(this.weightCol())).isEmpty() ? (KNNRegression)this.set((Param)this.inputCols(), new String[]{value}) : (KNNRegression)this.set((Param)this.inputCols(), new String[]{value, (String)this.$(this.weightCol())});
    }

    public KNNRegression setWeightCol(String value) {
        this.set(this.weightCol(), value);
        return value.isEmpty() ? (KNNRegression)this.set((Param)this.inputCols(), new String[]{(String)this.$(this.labelCol())}) : (KNNRegression)this.set((Param)this.inputCols(), new String[]{(String)this.$(this.labelCol()), value});
    }

    public KNNRegression setK(int value) {
        return (KNNRegression)this.set((Param)this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public KNNRegression setTopTreeSize(int value) {
        return (KNNRegression)this.set((Param)this.topTreeSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public KNNRegression setTopTreeLeafSize(int value) {
        return (KNNRegression)this.set((Param)this.topTreeLeafSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public KNNRegression setSubTreeLeafSize(int value) {
        return (KNNRegression)this.set((Param)this.subTreeLeafSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public KNNRegression setBufferSizeSampleSizes(int[] value) {
        return (KNNRegression)this.set((Param)this.bufferSizeSampleSizes(), value);
    }

    public KNNRegression setBalanceThreshold(double value) {
        return (KNNRegression)this.set((Param)this.balanceThreshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public KNNRegression setSeed(long value) {
        return (KNNRegression)this.set((Param)this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public KNNRegressionModel train(Dataset<?> dataset) {
        Model knnModel = ((KNN)this.copyValues((Params)new KNN(), this.copyValues$default$2())).fit((Dataset)dataset);
        return knnModel.toNewRegressionModel(this.uid());
    }

    public KNNRegressionModel fit(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        PredictionModel model = this.train((Dataset)dataset);
        double bufferSize = model.getBufferSize();
        return ((KNNRegressionModel)this.copyValues((Params)model.setParent((Estimator)this), this.copyValues$default$2())).setBufferSize(bufferSize);
    }

    public KNNRegression copy(ParamMap extra) {
        return (KNNRegression)this.defaultCopy(extra);
    }

    public KNNRegression(String uid) {
        this.uid = uid;
        HasInputCols.class.$init$((HasInputCols)this);
        KNNModelParams$class.$init$(this);
        HasSeed.class.$init$((HasSeed)this);
        KNNParams$class.$init$(this);
        HasWeightCol.class.$init$((HasWeightCol)this);
        this.setDefault((Param)this.inputCols(), new String[]{(String)this.$(this.labelCol())});
        this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.weightCol().$minus$greater((Object)"")}));
    }

    public KNNRegression() {
        this(Identifiable$.MODULE$.randomUID("knnr"));
    }
}

