/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import se.bjurr.gitchangelog.internal.util.Preconditions;

public class Commit
implements Serializable {
    private static final long serialVersionUID = 6622555148468372816L;
    private final String authorEmailAddress;
    private final String authorName;
    private final String commitTime;
    private final Long commitTimeLong;
    private final String hash;
    private final String hashFull;
    private final Boolean merge;
    private final String message;

    private static List<String> notFirst(List<String> stringList) {
        return stringList.subList(1, stringList.size());
    }

    private static String toHash(String input) {
        return input.substring(0, 15);
    }

    private static List<String> toNoEmptyStringsList(String message) {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (String part : message.split("\n")) {
            if (part.isEmpty()) continue;
            toReturn.add(part);
        }
        return toReturn;
    }

    static String toMessageBody(String message) {
        List<String> stringList = Commit.toNoEmptyStringsList(message);
        if (stringList.size() > 1) {
            List<String> notFirst = Commit.notFirst(stringList);
            return notFirst.stream().collect(Collectors.joining("\n"));
        }
        return "";
    }

    static List<String> toMessageItems(String message) {
        ArrayList<String> toReturn = new ArrayList<String>();
        List<String> stringList = Commit.toNoEmptyStringsList(message);
        if (stringList.size() > 1) {
            List<String> notFirst = Commit.notFirst(stringList);
            for (String part : notFirst) {
                String candidate = part.trim();
                if (candidate.startsWith("*")) {
                    candidate = candidate.substring(1).trim();
                }
                if (candidate.isEmpty()) continue;
                toReturn.add(candidate);
            }
        }
        return toReturn;
    }

    static String toMessageTitle(String message) {
        List<String> stringList = Commit.toNoEmptyStringsList(message);
        if (stringList.size() > 0) {
            return stringList.get(0).trim();
        }
        return "";
    }

    public Commit(String authorName, String authorEmailAddress, String commitTime, Long commitTimeLong, String message, String hash, Boolean merge) {
        this.authorName = Preconditions.checkNotNull(authorName, "authorName");
        this.authorEmailAddress = Preconditions.checkNotNull(authorEmailAddress, "authorEmailAddress");
        this.message = Preconditions.checkNotNull(message, "message").trim();
        this.commitTime = Preconditions.checkNotNull(commitTime, "commitTime");
        this.commitTimeLong = Preconditions.checkNotNull(commitTimeLong, "commitTimeLong");
        this.hash = Commit.toHash(Preconditions.checkNotNull(hash, "hash"));
        this.hashFull = Preconditions.checkNotNull(hash, "hashFull");
        this.merge = Preconditions.checkNotNull(merge, "merge");
    }

    public String getAuthorEmailAddress() {
        return this.authorEmailAddress;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getCommitTime() {
        return this.commitTime;
    }

    public Long getCommitTimeLong() {
        return this.commitTimeLong;
    }

    public String getHash() {
        return this.hash;
    }

    public String getHashFull() {
        return this.hashFull;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageBody() {
        return Commit.toMessageBody(this.message);
    }

    public List<String> getMessageBodyItems() {
        return Commit.toMessageItems(this.message);
    }

    public String getMessageTitle() {
        return Commit.toMessageTitle(this.message);
    }

    public Boolean isMerge() {
        return this.merge;
    }

    public String toString() {
        return "hash: " + this.hash + " message: " + this.message;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authorEmailAddress == null ? 0 : this.authorEmailAddress.hashCode());
        result = 31 * result + (this.authorName == null ? 0 : this.authorName.hashCode());
        result = 31 * result + (this.commitTime == null ? 0 : this.commitTime.hashCode());
        result = 31 * result + (this.commitTimeLong == null ? 0 : this.commitTimeLong.hashCode());
        result = 31 * result + (this.hash == null ? 0 : this.hash.hashCode());
        result = 31 * result + (this.hashFull == null ? 0 : this.hashFull.hashCode());
        result = 31 * result + (this.merge == null ? 0 : this.merge.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Commit other = (Commit)obj;
        if (this.authorEmailAddress == null ? other.authorEmailAddress != null : !this.authorEmailAddress.equals(other.authorEmailAddress)) {
            return false;
        }
        if (this.authorName == null ? other.authorName != null : !this.authorName.equals(other.authorName)) {
            return false;
        }
        if (this.commitTime == null ? other.commitTime != null : !this.commitTime.equals(other.commitTime)) {
            return false;
        }
        if (this.commitTimeLong == null ? other.commitTimeLong != null : !this.commitTimeLong.equals(other.commitTimeLong)) {
            return false;
        }
        if (this.hash == null ? other.hash != null : !this.hash.equals(other.hash)) {
            return false;
        }
        if (this.hashFull == null ? other.hashFull != null : !this.hashFull.equals(other.hashFull)) {
            return false;
        }
        if (this.merge == null ? other.merge != null : !this.merge.equals(other.merge)) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }
}

