/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api.model;

import java.io.Serializable;
import java.util.List;
import se.bjurr.gitchangelog.api.model.Author;
import se.bjurr.gitchangelog.api.model.Commit;
import se.bjurr.gitchangelog.api.model.Issue;
import se.bjurr.gitchangelog.api.model.IssueType;
import se.bjurr.gitchangelog.api.model.interfaces.IAuthors;
import se.bjurr.gitchangelog.api.model.interfaces.ICommits;
import se.bjurr.gitchangelog.api.model.interfaces.IIssues;
import se.bjurr.gitchangelog.internal.util.Preconditions;

public class Tag
implements ICommits,
IAuthors,
IIssues,
Serializable {
    private static final long serialVersionUID = 2140208294219785889L;
    private final String annotation;
    private final List<Author> authors;
    private final List<Commit> commits;
    private final List<Issue> issues;
    private final List<IssueType> issueTypes;
    private final String name;
    private final String tagTime;
    private final Long tagTimeLong;
    private final boolean hasTagTime;

    public Tag(String name, String annotation, List<Commit> commits, List<Author> authors, List<Issue> issues, List<IssueType> issueTypes, String tagTime, Long tagTimeLong) {
        this.commits = commits;
        this.authors = authors;
        this.issues = issues;
        this.name = name;
        this.annotation = annotation;
        this.issueTypes = issueTypes;
        this.tagTime = tagTime;
        this.tagTimeLong = tagTimeLong;
        this.hasTagTime = !Preconditions.isNullOrEmpty(tagTime);
    }

    public String getAnnotation() {
        return this.annotation;
    }

    @Override
    public List<Author> getAuthors() {
        return this.authors;
    }

    public Commit getCommit() {
        return this.commits.get(0);
    }

    @Override
    public List<Commit> getCommits() {
        return this.commits;
    }

    @Override
    public List<Issue> getIssues() {
        return this.issues;
    }

    public List<IssueType> getIssueTypes() {
        return this.issueTypes;
    }

    public String getName() {
        return this.name;
    }

    public String getTagTime() {
        return this.tagTime;
    }

    public Long getTagTimeLong() {
        return this.tagTimeLong;
    }

    public boolean isHasTagTime() {
        return this.hasTagTime;
    }

    public String toString() {
        return "name: " + this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotation == null ? 0 : this.annotation.hashCode());
        result = 31 * result + (this.authors == null ? 0 : this.authors.hashCode());
        result = 31 * result + (this.commits == null ? 0 : this.commits.hashCode());
        result = 31 * result + (this.hasTagTime ? 1231 : 1237);
        result = 31 * result + (this.issueTypes == null ? 0 : this.issueTypes.hashCode());
        result = 31 * result + (this.issues == null ? 0 : this.issues.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.tagTime == null ? 0 : this.tagTime.hashCode());
        result = 31 * result + (this.tagTimeLong == null ? 0 : this.tagTimeLong.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        if (this.annotation == null ? other.annotation != null : !this.annotation.equals(other.annotation)) {
            return false;
        }
        if (this.authors == null ? other.authors != null : !this.authors.equals(other.authors)) {
            return false;
        }
        if (this.commits == null ? other.commits != null : !this.commits.equals(other.commits)) {
            return false;
        }
        if (this.hasTagTime != other.hasTagTime) {
            return false;
        }
        if (this.issueTypes == null ? other.issueTypes != null : !this.issueTypes.equals(other.issueTypes)) {
            return false;
        }
        if (this.issues == null ? other.issues != null : !this.issues.equals(other.issues)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.tagTime == null ? other.tagTime != null : !this.tagTime.equals(other.tagTime)) {
            return false;
        }
        return !(this.tagTimeLong == null ? other.tagTimeLong != null : !this.tagTimeLong.equals(other.tagTimeLong));
    }
}

