/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class ApacheCommonsLoggingCleanUp
implements ClassLoaderPreMortemCleanUp {
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        Class<?> logFactory = preventor.findClass("org.apache.commons.logging.LogFactory");
        if (logFactory != null) {
            preventor.info("Releasing web app classloader from Apache Commons Logging");
            try {
                logFactory.getMethod("release", ClassLoader.class).invoke(null, preventor.getClassLoader());
            }
            catch (Exception ex) {
                preventor.error(ex);
            }
        }
    }
}

