/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class BeanELResolverCleanUp
implements ClassLoaderPreMortemCleanUp {
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        Introspector.flushCaches();
        Class<?> beanElResolverClass = preventor.findClass("javax.el.BeanELResolver");
        if (beanElResolverClass != null) {
            Field propertiesField;
            boolean cleared = false;
            try {
                Method purgeBeanClasses = beanElResolverClass.getDeclaredMethod("purgeBeanClasses", ClassLoader.class);
                purgeBeanClasses.setAccessible(true);
                purgeBeanClasses.invoke(beanElResolverClass.newInstance(), preventor.getClassLoader());
                cleared = true;
            }
            catch (NoSuchMethodException purgeBeanClasses) {
            }
            catch (Exception e) {
                preventor.error(e);
            }
            if (!cleared && (propertiesField = preventor.findField(beanElResolverClass, "properties")) != null) {
                try {
                    Map properties = (Map)propertiesField.get(null);
                    properties.clear();
                }
                catch (Exception e) {
                    preventor.error(e);
                }
            }
        }
    }
}

