/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.util.ArrayList;
import java.util.Map;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class ShutdownHookCleanUp
implements ClassLoaderPreMortemCleanUp {
    public static final int SHUTDOWN_HOOK_WAIT_MS_DEFAULT = 10000;
    protected boolean executeShutdownHooks = true;
    protected int shutdownHookWaitMs = 10000;

    public ShutdownHookCleanUp() {
        this(true, 10000);
    }

    public ShutdownHookCleanUp(boolean executeShutdownHooks, int shutdownHookWaitMs) {
        this.executeShutdownHooks = executeShutdownHooks;
        this.shutdownHookWaitMs = shutdownHookWaitMs;
    }

    public void setExecuteShutdownHooks(boolean executeShutdownHooks) {
        this.executeShutdownHooks = executeShutdownHooks;
    }

    public void setShutdownHookWaitMs(int shutdownHookWaitMs) {
        this.shutdownHookWaitMs = shutdownHookWaitMs;
    }

    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        Map shutdownHooks = (Map)preventor.getStaticFieldValue("java.lang.ApplicationShutdownHooks", "hooks");
        if (shutdownHooks != null) {
            for (Thread shutdownHook : new ArrayList(shutdownHooks.keySet())) {
                if (!preventor.isThreadInClassLoader(shutdownHook)) continue;
                this.removeShutdownHook(preventor, shutdownHook);
            }
        }
    }

    protected void removeShutdownHook(ClassLoaderLeakPreventor preventor, Thread shutdownHook) {
        String displayString = "'" + shutdownHook + "' of type " + shutdownHook.getClass().getName();
        preventor.error("Removing shutdown hook: " + displayString);
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
        if (this.executeShutdownHooks) {
            preventor.info("Executing shutdown hook now: " + displayString);
            shutdownHook.start();
            if (this.shutdownHookWaitMs > 0) {
                try {
                    shutdownHook.join(this.shutdownHookWaitMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (shutdownHook.isAlive()) {
                    preventor.warn(shutdownHook + "still running after " + this.shutdownHookWaitMs + " ms - Stopping!");
                    shutdownHook.stop();
                }
            }
        }
    }
}

