/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;
import se.jiderhamn.classloader.leak.prevention.JULLogger;
import se.jiderhamn.classloader.leak.prevention.Logger;
import se.jiderhamn.classloader.leak.prevention.MustBeAfter;
import se.jiderhamn.classloader.leak.prevention.PreClassLoaderInitiator;
import se.jiderhamn.classloader.leak.prevention.ReplaceDOMNormalizerSerializerAbortException;
import se.jiderhamn.classloader.leak.prevention.cleanup.ApacheCommonsLoggingCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.BeanELResolverCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.BeanIntrospectorCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.BeanValidationCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.DefaultAuthenticatorCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.DriverManagerCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.GeoToolsCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.IIOServiceProviderCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.IntrospectionUtilsCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.JDK8151486CleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.JavaServerFaces2746CleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.JavaUtilLoggingLevelCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.JceSecurityCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.KeepAliveTimerCacheCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.MBeanCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.MXBeanNotificationListenersCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.PropertyEditorCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.ProxySelectorCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.ResourceBundleCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.RmiTargetsCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.SAAJEnvelopeFactoryParserPoolCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.SecurityProviderCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.ShutdownHookCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.StopThreadsCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.ThreadGroupCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.ThreadGroupContextCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.ThreadLocalCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.X509TrustManagerImplUnparseableExtensionCleanUp;
import se.jiderhamn.classloader.leak.prevention.preinit.AwtToolkitInitiator;
import se.jiderhamn.classloader.leak.prevention.preinit.DatatypeConverterImplInitiator;
import se.jiderhamn.classloader.leak.prevention.preinit.DocumentBuilderFactoryInitiator;
import se.jiderhamn.classloader.leak.prevention.preinit.JarUrlConnectionInitiator;
import se.jiderhamn.classloader.leak.prevention.preinit.Java2dDisposerInitiator;
import se.jiderhamn.classloader.leak.prevention.preinit.Java2dRenderQueueInitiator;
import se.jiderhamn.classloader.leak.prevention.preinit.JavaxSecurityLoginConfigurationInitiator;
import se.jiderhamn.classloader.leak.prevention.preinit.JdbcDriversInitiator;
import se.jiderhamn.classloader.leak.prevention.preinit.LdapPoolManagerInitiator;
import se.jiderhamn.classloader.leak.prevention.preinit.OracleJdbcThreadInitiator;
import se.jiderhamn.classloader.leak.prevention.preinit.SecurityPolicyInitiator;
import se.jiderhamn.classloader.leak.prevention.preinit.SecurityProvidersInitiator;
import se.jiderhamn.classloader.leak.prevention.preinit.SunAwtAppContextInitiator;
import se.jiderhamn.classloader.leak.prevention.preinit.SunGCInitiator;

public class ClassLoaderLeakPreventorFactory {
    protected final ClassLoader leakSafeClassLoader;
    protected Logger logger = new JULLogger();
    protected final Map<String, PreClassLoaderInitiator> preInitiators = Collections.synchronizedMap(new LinkedHashMap());
    protected final Map<String, ClassLoaderPreMortemCleanUp> cleanUps = Collections.synchronizedMap(new LinkedHashMap());

    public ClassLoaderLeakPreventorFactory() {
        this(ClassLoader.getSystemClassLoader());
    }

    public ClassLoaderLeakPreventorFactory(ClassLoader leakSafeClassLoader) {
        this.leakSafeClassLoader = leakSafeClassLoader;
        this.configureDefaults();
    }

    public void configureDefaults() {
        this.addPreInitiator(new AwtToolkitInitiator());
        this.addPreInitiator(new JdbcDriversInitiator());
        this.addPreInitiator(new SunAwtAppContextInitiator());
        this.addPreInitiator(new SecurityPolicyInitiator());
        this.addPreInitiator(new SecurityProvidersInitiator());
        this.addPreInitiator(new DocumentBuilderFactoryInitiator());
        this.addPreInitiator(new ReplaceDOMNormalizerSerializerAbortException());
        this.addPreInitiator(new DatatypeConverterImplInitiator());
        this.addPreInitiator(new JavaxSecurityLoginConfigurationInitiator());
        this.addPreInitiator(new JarUrlConnectionInitiator());
        this.addPreInitiator(new LdapPoolManagerInitiator());
        this.addPreInitiator(new Java2dDisposerInitiator());
        this.addPreInitiator(new Java2dRenderQueueInitiator());
        this.addPreInitiator(new SunGCInitiator());
        this.addPreInitiator(new OracleJdbcThreadInitiator());
        this.addCleanUp(new BeanIntrospectorCleanUp());
        this.addCleanUp(new BeanELResolverCleanUp());
        this.addCleanUp(new BeanValidationCleanUp());
        this.addCleanUp(new JavaServerFaces2746CleanUp());
        this.addCleanUp(new GeoToolsCleanUp());
        this.addCleanUp(new IntrospectionUtilsCleanUp());
        this.addCleanUp(new IIOServiceProviderCleanUp());
        this.addCleanUp(new ThreadGroupContextCleanUp());
        this.addCleanUp(new X509TrustManagerImplUnparseableExtensionCleanUp());
        this.addCleanUp(new SAAJEnvelopeFactoryParserPoolCleanUp());
        this.addCleanUp(new DriverManagerCleanUp());
        this.addCleanUp(new DefaultAuthenticatorCleanUp());
        this.addCleanUp(new MBeanCleanUp());
        this.addCleanUp(new MXBeanNotificationListenersCleanUp());
        this.addCleanUp(new ShutdownHookCleanUp());
        this.addCleanUp(new PropertyEditorCleanUp());
        this.addCleanUp(new SecurityProviderCleanUp());
        this.addCleanUp(new JceSecurityCleanUp());
        this.addCleanUp(new ProxySelectorCleanUp());
        this.addCleanUp(new RmiTargetsCleanUp());
        this.addCleanUp(new StopThreadsCleanUp());
        this.addCleanUp(new ThreadGroupCleanUp());
        this.addCleanUp(new ThreadLocalCleanUp());
        this.addCleanUp(new KeepAliveTimerCacheCleanUp());
        this.addCleanUp(new ResourceBundleCleanUp());
        this.addCleanUp(new JDK8151486CleanUp());
        this.addCleanUp(new JavaUtilLoggingLevelCleanUp());
        this.addCleanUp(new ApacheCommonsLoggingCleanUp());
    }

    public ClassLoaderLeakPreventor newLeakPreventor() {
        return this.newLeakPreventor(Thread.currentThread().getContextClassLoader());
    }

    public ClassLoaderLeakPreventor newLeakPreventor(ClassLoader classLoader) {
        return new ClassLoaderLeakPreventor(this.leakSafeClassLoader, classLoader, this.logger, new ArrayList<PreClassLoaderInitiator>(this.preInitiators.values()), new ArrayList<ClassLoaderPreMortemCleanUp>(this.cleanUps.values()));
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void addPreInitiator(PreClassLoaderInitiator preClassLoaderInitiator) {
        this.addConsideringOrder(this.preInitiators, preClassLoaderInitiator);
    }

    public void addCleanUp(ClassLoaderPreMortemCleanUp classLoaderPreMortemCleanUp) {
        this.addConsideringOrder(this.cleanUps, classLoaderPreMortemCleanUp);
    }

    private <I> void addConsideringOrder(Map<String, I> map, I newEntry) {
        for (Map.Entry<String, I> entry : map.entrySet()) {
            Class<I>[] existingMustBeAfter;
            if (!(entry.getValue() instanceof MustBeAfter)) continue;
            for (Class clazz : existingMustBeAfter = ((MustBeAfter)entry.getValue()).mustBeBeforeMe()) {
                if (!clazz.isAssignableFrom(newEntry.getClass())) continue;
                throw new IllegalStateException(clazz.getName() + " must be added after " + newEntry.getClass());
            }
        }
        map.put(newEntry.getClass().getName(), newEntry);
    }

    public void addCleanUp(String name, ClassLoaderPreMortemCleanUp classLoaderPreMortemCleanUp) {
        this.cleanUps.put(name, classLoaderPreMortemCleanUp);
    }

    public void clearPreInitiators() {
        this.cleanUps.clear();
    }

    public void clearCleanUps() {
        this.cleanUps.clear();
    }

    public <C extends PreClassLoaderInitiator> C getPreInitiator(Class<C> clazz) {
        return (C)this.preInitiators.get(clazz.getName());
    }

    public <C extends ClassLoaderPreMortemCleanUp> C getCleanUp(Class<C> clazz) {
        return (C)this.cleanUps.get(clazz.getName());
    }

    public <C extends PreClassLoaderInitiator> void removePreInitiator(Class<C> clazz) {
        this.preInitiators.remove(clazz.getName());
    }

    public <C extends ClassLoaderPreMortemCleanUp> void removeCleanUp(Class<C> clazz) {
        this.cleanUps.remove(clazz.getName());
    }
}

