/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class JavaUtilLoggingLevelCleanUp
implements ClassLoaderPreMortemCleanUp {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        Class<?> knownLevelClass = preventor.findClass("java.util.logging.Level$KnownLevel");
        if (knownLevelClass != null) {
            Field levelObjectField = preventor.findField(knownLevelClass, "levelObject");
            if (levelObjectField != null) {
                Class<?> clazz = knownLevelClass;
                synchronized (clazz) {
                    Map nameToLevels = (Map)preventor.getStaticFieldValue(knownLevelClass, "nameToLevels");
                    Map intToLevels = (Map)preventor.getStaticFieldValue(knownLevelClass, "intToLevels");
                    if (nameToLevels != null) {
                        Set removed = this.process(preventor, knownLevelClass, levelObjectField, nameToLevels);
                        if (intToLevels != null) {
                            for (List knownLevels : intToLevels.values()) {
                                knownLevels.removeAll(removed);
                            }
                        }
                    } else if (intToLevels != null) {
                        this.process(preventor, knownLevelClass, levelObjectField, intToLevels);
                    }
                }
            } else {
                preventor.warn("Found " + knownLevelClass + " but not levelObject field");
            }
        }
    }

    private Set process(ClassLoaderLeakPreventor preventor, Class<?> knownLevelClass, Field levelObjectField, Map<?, List> levelsMaps) {
        HashSet output = new HashSet();
        for (List knownLevels : levelsMaps.values()) {
            ListIterator iter = knownLevels.listIterator();
            while (iter.hasNext()) {
                Object knownLevel = iter.next();
                Level levelObject = (Level)preventor.getFieldValue(levelObjectField, knownLevel);
                if (!preventor.isLoadedInClassLoader(levelObject)) continue;
                preventor.warn(Level.class.getName() + " subclass loaded by protected ClassLoader: " + levelObject.getClass() + "; removing from " + knownLevelClass);
                iter.remove();
                output.add(knownLevel);
            }
        }
        return output;
    }
}

