/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.lang.management.PlatformManagedObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class MXBeanNotificationListenersCleanUp
implements ClassLoaderPreMortemCleanUp {
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        Class<?> platformComponentClass = preventor.findClass("java.lang.management.PlatformComponent");
        Method getMXBeans = preventor.findMethod(platformComponentClass, "getMXBeans", Class.class);
        if (platformComponentClass != null && getMXBeans != null) {
            ?[] platformComponents;
            boolean canProcessNotificationEmitterSupport;
            Class<?> notificationEmitterSupportClass = preventor.findClass("sun.management.NotificationEmitterSupport");
            Field listenerListField = preventor.findField(notificationEmitterSupportClass, "listenerList");
            Class<?> listenerInfoClass = preventor.findClass("sun.management.NotificationEmitterSupport$ListenerInfo");
            Field listenerField = preventor.findField(listenerInfoClass, "listener");
            Field filterField = preventor.findField(listenerInfoClass, "filter");
            Field handbackField = preventor.findField(listenerInfoClass, "handback");
            boolean bl = canProcessNotificationEmitterSupport = listenerListField != null && listenerInfoClass != null && listenerField != null && filterField != null && handbackField != null;
            if (!canProcessNotificationEmitterSupport) {
                preventor.warn("Unable to unregister NotificationEmitterSupport listeners, because details could not be found using reflection");
            }
            if ((platformComponents = platformComponentClass.getEnumConstants()) != null) {
                for (Object platformComponent : platformComponents) {
                    List mxBeans = null;
                    try {
                        mxBeans = (List)getMXBeans.invoke(platformComponent, new Object[]{null});
                    }
                    catch (IllegalAccessException ex) {
                        preventor.error(ex);
                    }
                    catch (InvocationTargetException ex) {
                        preventor.error(ex);
                    }
                    if (mxBeans == null) continue;
                    for (PlatformManagedObject mxBean : mxBeans) {
                        if (!(mxBean instanceof NotificationEmitter)) continue;
                        if (canProcessNotificationEmitterSupport && notificationEmitterSupportClass.isAssignableFrom(mxBean.getClass())) {
                            List listenerList = (List)preventor.getFieldValue(listenerListField, mxBean);
                            if (listenerList == null) continue;
                            for (Object listenerInfo : listenerList) {
                                NotificationListener listener = (NotificationListener)preventor.getFieldValue(listenerField, listenerInfo);
                                NotificationFilter filter = (NotificationFilter)preventor.getFieldValue(filterField, listenerInfo);
                                Object handback = preventor.getFieldValue(handbackField, listenerInfo);
                                if (!preventor.isLoadedInClassLoader(listener) && !preventor.isLoadedInClassLoader(filter) && !preventor.isLoadedInClassLoader(handback)) continue;
                                preventor.warn("Listener '" + listener + "' (or its filter or handback) of MXBean " + mxBean + " of PlatformComponent " + platformComponent + " was loaded in protected ClassLoader; removing");
                                try {
                                    ((NotificationEmitter)((Object)mxBean)).removeNotificationListener(listener, filter, handback);
                                }
                                catch (ListenerNotFoundException e) {
                                    preventor.error(e);
                                }
                            }
                            continue;
                        }
                        if (!(mxBean instanceof NotificationBroadcasterSupport)) continue;
                        this.unregisterNotificationListeners(preventor, (NotificationBroadcasterSupport)((Object)mxBean));
                    }
                }
            }
        }
    }

    protected void unregisterNotificationListeners(ClassLoaderLeakPreventor preventor, NotificationBroadcasterSupport mBean) {
        Field listenerListField = preventor.findField(NotificationBroadcasterSupport.class, "listenerList");
        if (listenerListField != null) {
            Class<?> listenerInfoClass = preventor.findClass("javax.management.NotificationBroadcasterSupport$ListenerInfo");
            List listenerList = (List)preventor.getFieldValue(listenerListField, mBean);
            if (listenerList != null) {
                Field listenerField = preventor.findField(listenerInfoClass, "listener");
                Field filterField = preventor.findField(listenerInfoClass, "filter");
                Field handbackField = preventor.findField(listenerInfoClass, "handback");
                for (Object listenerInfo : listenerList) {
                    NotificationListener listener = (NotificationListener)preventor.getFieldValue(listenerField, listenerInfo);
                    NotificationFilter filter = (NotificationFilter)preventor.getFieldValue(filterField, listenerInfo);
                    Object handback = preventor.getFieldValue(handbackField, listenerInfo);
                    if (!preventor.isLoadedInClassLoader(listener) && !preventor.isLoadedInClassLoader(filter) && !preventor.isLoadedInClassLoader(handback)) continue;
                    preventor.warn("Listener '" + listener + "' (or its filter or handback) of MBean " + mBean + " was loaded in protected ClassLoader; removing");
                    try {
                        mBean.removeNotificationListener(listener, filter, handback);
                    }
                    catch (ListenerNotFoundException e) {
                        preventor.error(e);
                    }
                }
            }
        }
    }
}

