/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class RmiTargetsCleanUp
implements ClassLoaderPreMortemCleanUp {
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        try {
            Class<?> objectTableClass = preventor.findClass("sun.rmi.transport.ObjectTable");
            if (objectTableClass != null) {
                this.clearRmiTargetsMap(preventor, (Map)preventor.getStaticFieldValue(objectTableClass, "objTable"));
                this.clearRmiTargetsMap(preventor, (Map)preventor.getStaticFieldValue(objectTableClass, "implTable"));
            }
        }
        catch (Exception ex) {
            preventor.error(ex);
        }
    }

    protected void clearRmiTargetsMap(ClassLoaderLeakPreventor preventor, Map<?, ?> rmiTargetsMap) {
        try {
            Field cclField = preventor.findFieldOfClass("sun.rmi.transport.Target", "ccl");
            preventor.debug("Looping " + rmiTargetsMap.size() + " RMI Targets to find leaks");
            Iterator<?> iter = rmiTargetsMap.values().iterator();
            while (iter.hasNext()) {
                Object target = iter.next();
                ClassLoader ccl = (ClassLoader)cclField.get(target);
                if (!preventor.isClassLoaderOrChild(ccl)) continue;
                preventor.warn("Removing RMI Target: " + target);
                iter.remove();
            }
        }
        catch (Exception ex) {
            preventor.error(ex);
        }
    }
}

