/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class StopThreadsCleanUp
implements ClassLoaderPreMortemCleanUp {
    protected static final String JURT_ASYNCHRONOUS_FINALIZER = "com.sun.star.lib.util.AsynchronousFinalizer";
    private Field oracleTarget;
    private Field ibmRunnable;
    protected boolean stopThreads;
    protected int threadWaitMs = 5000;
    protected boolean stopTimerThreads;

    public StopThreadsCleanUp() {
        this(true, true);
    }

    public StopThreadsCleanUp(boolean stopThreads, boolean stopTimerThreads) {
        this.stopThreads = stopThreads;
        this.stopTimerThreads = stopTimerThreads;
    }

    public void setStopThreads(boolean stopThreads) {
        this.stopThreads = stopThreads;
    }

    public void setStopTimerThreads(boolean stopTimerThreads) {
        this.stopTimerThreads = stopTimerThreads;
    }

    public void setThreadWaitMs(int threadWaitMs) {
        this.threadWaitMs = threadWaitMs;
    }

    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        this.forceStartOpenOfficeJurtCleanup(preventor);
        this.stopThreads(preventor);
    }

    protected void forceStartOpenOfficeJurtCleanup(ClassLoaderLeakPreventor preventor) {
        if (this.stopThreads) {
            if (preventor.isLoadedByClassLoader(preventor.findClass(JURT_ASYNCHRONOUS_FINALIZER))) {
                preventor.info("OpenOffice JURT AsynchronousFinalizer thread started - forcing garbage collection to invoke finalizers");
                ClassLoaderLeakPreventor.gc();
            }
        } else if (preventor.getClassLoader().getResource("com/sun/star/lib/util/AsynchronousFinalizer.class") != null) {
            preventor.warn("OpenOffice JURT AsynchronousFinalizer thread will not be stopped if started, as stopThreads is false");
            ClassLoaderLeakPreventor.gc();
        }
    }

    protected void stopThreads(ClassLoaderLeakPreventor preventor) {
        Class<?> workerClass = preventor.findClass("java.util.concurrent.ThreadPoolExecutor$Worker");
        boolean waitForThreads = this.threadWaitMs > 0;
        for (Thread thread : preventor.getAllThreads()) {
            Runnable runnable = this.getRunnable(preventor, thread);
            boolean threadLoadedByClassLoader = preventor.isLoadedInClassLoader(thread);
            boolean threadGroupLoadedByClassLoader = preventor.isLoadedInClassLoader(thread.getThreadGroup());
            boolean runnableLoadedByClassLoader = preventor.isLoadedInClassLoader(runnable);
            boolean hasContextClassLoader = preventor.isClassLoaderOrChild(thread.getContextClassLoader());
            if (thread == Thread.currentThread() || !threadLoadedByClassLoader && !threadGroupLoadedByClassLoader && !hasContextClassLoader && !runnableLoadedByClassLoader) continue;
            if (thread.getClass().getName().startsWith(JURT_ASYNCHRONOUS_FINALIZER)) {
                if (this.stopThreads) {
                    preventor.info("Found JURT thread " + thread.getName() + "; starting " + JURTKiller.class.getSimpleName());
                    new JURTKiller(preventor, thread).start();
                    continue;
                }
                preventor.warn("JURT thread " + thread.getName() + " is still running in protected ClassLoader");
                continue;
            }
            if (thread.getThreadGroup() != null && ("system".equals(thread.getThreadGroup().getName()) || "RMI Runtime".equals(thread.getThreadGroup().getName()))) {
                if (!"Keep-Alive-Timer".equals(thread.getName())) continue;
                thread.setContextClassLoader(preventor.getLeakSafeClassLoader());
                preventor.debug("Changed contextClassLoader of HTTP keep alive thread");
                continue;
            }
            if (!thread.isAlive()) continue;
            if (thread.getClass().getName().startsWith("java.util.Timer")) {
                if (thread.getName() != null && thread.getName().startsWith("PostgreSQL-JDBC-SharedTimer-")) {
                    Field inheritedAccessControlContext;
                    if (hasContextClassLoader) {
                        Class<?> postgresqlDriver = preventor.findClass("org.postgresql.Driver");
                        ClassLoader postgresqlCL = postgresqlDriver != null && !preventor.isLoadedByClassLoader(postgresqlDriver) ? postgresqlDriver.getClassLoader() : preventor.getLeakSafeClassLoader();
                        thread.setContextClassLoader(postgresqlCL);
                        preventor.warn("Changing contextClassLoader of " + thread + " to " + postgresqlCL);
                    }
                    if ((inheritedAccessControlContext = preventor.findField(Thread.class, "inheritedAccessControlContext")) == null) continue;
                    try {
                        AccessControlContext acc = preventor.createAccessControlContext();
                        inheritedAccessControlContext.set(thread, acc);
                        preventor.removeDomainCombiner(thread, acc);
                    }
                    catch (Exception e) {
                        preventor.error(e);
                    }
                    continue;
                }
                if (this.stopTimerThreads) {
                    preventor.warn("Stopping Timer thread '" + thread.getName() + "' running in protected ClassLoader. " + preventor.getStackTrace(thread));
                    this.stopTimerThread(preventor, thread);
                    continue;
                }
                preventor.info("Timer thread is running in protected ClassLoader, but will not be stopped. " + preventor.getStackTrace(thread));
                continue;
            }
            String displayString = "Thread '" + thread + "'" + (threadLoadedByClassLoader ? " of type " + thread.getClass().getName() + " loaded by protected ClassLoader" : "") + (runnableLoadedByClassLoader ? " with Runnable of type " + runnable.getClass().getName() + " loaded by protected ClassLoader" : "") + (threadGroupLoadedByClassLoader ? " with ThreadGroup of type " + thread.getThreadGroup().getClass().getName() + " loaded by protected ClassLoader" : "") + (hasContextClassLoader ? " with contextClassLoader = protected ClassLoader or child" : "");
            if (workerClass != null && workerClass.isInstance(runnable)) {
                try {
                    Field workerExecutor = preventor.findField(workerClass, "this$0");
                    ThreadPoolExecutor executor = (ThreadPoolExecutor)preventor.getFieldValue(workerExecutor, runnable);
                    if (executor != null) {
                        if ("org.apache.tomcat.util.threads.ThreadPoolExecutor".equals(executor.getClass().getName())) {
                            preventor.debug(displayString + " is worker of " + executor.getClass().getName());
                        } else if (preventor.isLoadedInClassLoader(executor) || preventor.isLoadedInClassLoader(executor.getThreadFactory())) {
                            if (this.stopThreads) {
                                preventor.warn("Shutting down ThreadPoolExecutor of type " + executor.getClass().getName());
                                executor.shutdownNow();
                            } else {
                                preventor.warn("ThreadPoolExecutor of type " + executor.getClass().getName() + " should be shut down.");
                            }
                        } else {
                            preventor.info(displayString + " is a ThreadPoolExecutor.Worker of " + executor.getClass().getName() + " but found no reason to shut down ThreadPoolExecutor.");
                        }
                    }
                }
                catch (Exception ex) {
                    preventor.error(ex);
                }
            }
            if (!(threadLoadedByClassLoader || runnableLoadedByClassLoader || threadGroupLoadedByClassLoader)) {
                if (waitForThreads) {
                    preventor.warn(displayString + "; waiting " + this.threadWaitMs + " ms. " + preventor.getStackTrace(thread));
                    preventor.waitForThread(thread, this.threadWaitMs, false);
                }
                if (!thread.isAlive() || !preventor.isClassLoaderOrChild(thread.getContextClassLoader())) continue;
                preventor.warn(displayString + (waitForThreads ? " still" : "") + " alive; changing context ClassLoader to leak safe (" + preventor.getLeakSafeClassLoader() + "). " + preventor.getStackTrace(thread));
                thread.setContextClassLoader(preventor.getLeakSafeClassLoader());
                continue;
            }
            if (this.stopThreads) {
                if (waitForThreads) {
                    preventor.warn("Waiting for " + displayString + " for " + this.threadWaitMs + " ms. " + preventor.getStackTrace(thread));
                    preventor.waitForThread(thread, this.threadWaitMs, true);
                }
                if (thread.isAlive()) {
                    preventor.warn("Stopping " + displayString + ". " + preventor.getStackTrace(thread));
                    thread.stop();
                    continue;
                }
                preventor.info(displayString + " no longer alive - no action needed.");
                continue;
            }
            preventor.warn(displayString + " would cause leak. " + preventor.getStackTrace(thread));
        }
    }

    private Runnable getRunnable(ClassLoaderLeakPreventor preventor, Thread thread) {
        if (this.oracleTarget == null && this.ibmRunnable == null) {
            this.oracleTarget = preventor.findField(Thread.class, "target");
            this.ibmRunnable = preventor.findField(Thread.class, "runnable");
        }
        return this.oracleTarget != null ? (Runnable)preventor.getFieldValue(this.oracleTarget, thread) : (Runnable)preventor.getFieldValue(this.ibmRunnable, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTimerThread(ClassLoaderLeakPreventor preventor, Thread thread) {
        try {
            Field newTasksMayBeScheduled = preventor.findField(thread.getClass(), "newTasksMayBeScheduled");
            Object queue = preventor.findField(thread.getClass(), "queue").get(thread);
            Method clear = preventor.findMethod(queue.getClass(), "clear", new Class[0]);
            Object object = queue;
            synchronized (object) {
                newTasksMayBeScheduled.set(thread, Boolean.FALSE);
                clear.invoke(queue, new Object[0]);
                queue.notify();
            }
        }
        catch (Exception ex) {
            preventor.error(ex);
        }
    }

    protected class JURTKiller
    extends Thread {
        private final ClassLoaderLeakPreventor preventor;
        private final Thread jurtThread;
        private final List<?> jurtQueue;

        public JURTKiller(ClassLoaderLeakPreventor preventor, Thread jurtThread) {
            super("JURTKiller");
            this.preventor = preventor;
            this.jurtThread = jurtThread;
            this.jurtQueue = (List)preventor.getStaticFieldValue(StopThreadsCleanUp.JURT_ASYNCHRONOUS_FINALIZER, "queue");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.jurtQueue == null || this.jurtThread == null) {
                this.preventor.error(this.getName() + ": No queue or thread!?");
                return;
            }
            if (!this.jurtThread.isAlive()) {
                this.preventor.warn(this.getName() + ": " + this.jurtThread.getName() + " is already dead?");
            }
            boolean queueIsEmpty = false;
            while (!queueIsEmpty) {
                try {
                    this.preventor.debug(this.getName() + " goes to sleep for " + 5000 + " ms");
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (Thread.State.RUNNABLE != this.jurtThread.getState()) {
                    this.preventor.debug(this.getName() + " about to force Garbage Collection");
                    ClassLoaderLeakPreventor.gc();
                    List<?> list = this.jurtQueue;
                    synchronized (list) {
                        queueIsEmpty = this.jurtQueue.isEmpty();
                        this.preventor.debug(this.getName() + ": JURT queue is empty? " + queueIsEmpty);
                        continue;
                    }
                }
                this.preventor.debug(this.getName() + ": JURT thread " + this.jurtThread.getName() + " is executing Job");
            }
            this.preventor.info(this.getName() + " about to kill " + this.jurtThread);
            if (this.jurtThread.isAlive()) {
                this.jurtThread.stop();
            }
        }
    }
}

