/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.mwaa;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.mwaa.CfnEnvironment;
import software.amazon.awscdk.services.mwaa.CfnEnvironmentProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mwaa.CfnEnvironment")
public class CfnEnvironment
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnEnvironment.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnEnvironment(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEnvironment(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnEnvironment(@NotNull Construct scope, @NotNull String id, @NotNull CfnEnvironmentProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLoggingConfigurationDagProcessingLogsCloudWatchLogGroupArn() {
        return (String)Kernel.get((Object)this, (String)"attrLoggingConfigurationDagProcessingLogsCloudWatchLogGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLoggingConfigurationSchedulerLogsCloudWatchLogGroupArn() {
        return (String)Kernel.get((Object)this, (String)"attrLoggingConfigurationSchedulerLogsCloudWatchLogGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLoggingConfigurationTaskLogsCloudWatchLogGroupArn() {
        return (String)Kernel.get((Object)this, (String)"attrLoggingConfigurationTaskLogsCloudWatchLogGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLoggingConfigurationWebserverLogsCloudWatchLogGroupArn() {
        return (String)Kernel.get((Object)this, (String)"attrLoggingConfigurationWebserverLogsCloudWatchLogGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLoggingConfigurationWorkerLogsCloudWatchLogGroupArn() {
        return (String)Kernel.get((Object)this, (String)"attrLoggingConfigurationWorkerLogsCloudWatchLogGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrWebserverUrl() {
        return (String)Kernel.get((Object)this, (String)"attrWebserverUrl", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getAirflowConfigurationOptions() {
        return Kernel.get((Object)this, (String)"airflowConfigurationOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAirflowConfigurationOptions(@NotNull Object value) {
        Kernel.set((Object)this, (String)"airflowConfigurationOptions", (Object)Objects.requireNonNull(value, "airflowConfigurationOptions is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getAirflowVersion() {
        return (String)Kernel.get((Object)this, (String)"airflowVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setAirflowVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"airflowVersion", (Object)value);
    }

    @Nullable
    public String getDagS3Path() {
        return (String)Kernel.get((Object)this, (String)"dagS3Path", (NativeType)NativeType.forClass(String.class));
    }

    public void setDagS3Path(@Nullable String value) {
        Kernel.set((Object)this, (String)"dagS3Path", (Object)value);
    }

    @Nullable
    public String getEnvironmentClass() {
        return (String)Kernel.get((Object)this, (String)"environmentClass", (NativeType)NativeType.forClass(String.class));
    }

    public void setEnvironmentClass(@Nullable String value) {
        Kernel.set((Object)this, (String)"environmentClass", (Object)value);
    }

    @Nullable
    public String getExecutionRoleArn() {
        return (String)Kernel.get((Object)this, (String)"executionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setExecutionRoleArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"executionRoleArn", (Object)value);
    }

    @Nullable
    public String getKmsKey() {
        return (String)Kernel.get((Object)this, (String)"kmsKey", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKey(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsKey", (Object)value);
    }

    @Nullable
    public Object getLoggingConfiguration() {
        return Kernel.get((Object)this, (String)"loggingConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLoggingConfiguration(@Nullable LoggingConfigurationProperty value) {
        Kernel.set((Object)this, (String)"loggingConfiguration", (Object)value);
    }

    public void setLoggingConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"loggingConfiguration", (Object)value);
    }

    @Nullable
    public Number getMaxWorkers() {
        return (Number)Kernel.get((Object)this, (String)"maxWorkers", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxWorkers(@Nullable Number value) {
        Kernel.set((Object)this, (String)"maxWorkers", (Object)value);
    }

    @Nullable
    public Number getMinWorkers() {
        return (Number)Kernel.get((Object)this, (String)"minWorkers", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMinWorkers(@Nullable Number value) {
        Kernel.set((Object)this, (String)"minWorkers", (Object)value);
    }

    @Nullable
    public Object getNetworkConfiguration() {
        return Kernel.get((Object)this, (String)"networkConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNetworkConfiguration(@Nullable NetworkConfigurationProperty value) {
        Kernel.set((Object)this, (String)"networkConfiguration", (Object)value);
    }

    public void setNetworkConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"networkConfiguration", (Object)value);
    }

    @Nullable
    public String getPluginsS3ObjectVersion() {
        return (String)Kernel.get((Object)this, (String)"pluginsS3ObjectVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setPluginsS3ObjectVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"pluginsS3ObjectVersion", (Object)value);
    }

    @Nullable
    public String getPluginsS3Path() {
        return (String)Kernel.get((Object)this, (String)"pluginsS3Path", (NativeType)NativeType.forClass(String.class));
    }

    public void setPluginsS3Path(@Nullable String value) {
        Kernel.set((Object)this, (String)"pluginsS3Path", (Object)value);
    }

    @Nullable
    public String getRequirementsS3ObjectVersion() {
        return (String)Kernel.get((Object)this, (String)"requirementsS3ObjectVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setRequirementsS3ObjectVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"requirementsS3ObjectVersion", (Object)value);
    }

    @Nullable
    public String getRequirementsS3Path() {
        return (String)Kernel.get((Object)this, (String)"requirementsS3Path", (NativeType)NativeType.forClass(String.class));
    }

    public void setRequirementsS3Path(@Nullable String value) {
        Kernel.set((Object)this, (String)"requirementsS3Path", (Object)value);
    }

    @Nullable
    public Number getSchedulers() {
        return (Number)Kernel.get((Object)this, (String)"schedulers", (NativeType)NativeType.forClass(Number.class));
    }

    public void setSchedulers(@Nullable Number value) {
        Kernel.set((Object)this, (String)"schedulers", (Object)value);
    }

    @Nullable
    public String getSourceBucketArn() {
        return (String)Kernel.get((Object)this, (String)"sourceBucketArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setSourceBucketArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"sourceBucketArn", (Object)value);
    }

    @Nullable
    public String getWebserverAccessMode() {
        return (String)Kernel.get((Object)this, (String)"webserverAccessMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setWebserverAccessMode(@Nullable String value) {
        Kernel.set((Object)this, (String)"webserverAccessMode", (Object)value);
    }

    @Nullable
    public String getWeeklyMaintenanceWindowStart() {
        return (String)Kernel.get((Object)this, (String)"weeklyMaintenanceWindowStart", (NativeType)NativeType.forClass(String.class));
    }

    public void setWeeklyMaintenanceWindowStart(@Nullable String value) {
        Kernel.set((Object)this, (String)"weeklyMaintenanceWindowStart", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnEnvironment> {
        private final Construct scope;
        private final String id;
        private final CfnEnvironmentProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnEnvironmentProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder airflowConfigurationOptions(Object airflowConfigurationOptions) {
            this.props.airflowConfigurationOptions(airflowConfigurationOptions);
            return this;
        }

        public Builder airflowVersion(String airflowVersion) {
            this.props.airflowVersion(airflowVersion);
            return this;
        }

        public Builder dagS3Path(String dagS3Path) {
            this.props.dagS3Path(dagS3Path);
            return this;
        }

        public Builder environmentClass(String environmentClass) {
            this.props.environmentClass(environmentClass);
            return this;
        }

        public Builder executionRoleArn(String executionRoleArn) {
            this.props.executionRoleArn(executionRoleArn);
            return this;
        }

        public Builder kmsKey(String kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        public Builder loggingConfiguration(LoggingConfigurationProperty loggingConfiguration) {
            this.props.loggingConfiguration(loggingConfiguration);
            return this;
        }

        public Builder loggingConfiguration(IResolvable loggingConfiguration) {
            this.props.loggingConfiguration(loggingConfiguration);
            return this;
        }

        public Builder maxWorkers(Number maxWorkers) {
            this.props.maxWorkers(maxWorkers);
            return this;
        }

        public Builder minWorkers(Number minWorkers) {
            this.props.minWorkers(minWorkers);
            return this;
        }

        public Builder networkConfiguration(NetworkConfigurationProperty networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }

        public Builder networkConfiguration(IResolvable networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }

        public Builder pluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.props.pluginsS3ObjectVersion(pluginsS3ObjectVersion);
            return this;
        }

        public Builder pluginsS3Path(String pluginsS3Path) {
            this.props.pluginsS3Path(pluginsS3Path);
            return this;
        }

        public Builder requirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.props.requirementsS3ObjectVersion(requirementsS3ObjectVersion);
            return this;
        }

        public Builder requirementsS3Path(String requirementsS3Path) {
            this.props.requirementsS3Path(requirementsS3Path);
            return this;
        }

        public Builder schedulers(Number schedulers) {
            this.props.schedulers(schedulers);
            return this;
        }

        public Builder sourceBucketArn(String sourceBucketArn) {
            this.props.sourceBucketArn(sourceBucketArn);
            return this;
        }

        public Builder tags(Object tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder webserverAccessMode(String webserverAccessMode) {
            this.props.webserverAccessMode(webserverAccessMode);
            return this;
        }

        public Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.props.weeklyMaintenanceWindowStart(weeklyMaintenanceWindowStart);
            return this;
        }

        public CfnEnvironment build() {
            return new CfnEnvironment(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mwaa.CfnEnvironment.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        @Nullable
        default public List<String> getSubnetIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            List<String> securityGroupIds;
            List<String> subnetIds;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public NetworkConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mwaa.CfnEnvironment.ModuleLoggingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ModuleLoggingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCloudWatchLogGroupArn() {
            return null;
        }

        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public String getLogLevel() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ModuleLoggingConfigurationProperty> {
            String cloudWatchLogGroupArn;
            Object enabled;
            String logLevel;

            public Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
                this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder logLevel(String logLevel) {
                this.logLevel = logLevel;
                return this;
            }

            public ModuleLoggingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mwaa.CfnEnvironment.LoggingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoggingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDagProcessingLogs() {
            return null;
        }

        @Nullable
        default public Object getSchedulerLogs() {
            return null;
        }

        @Nullable
        default public Object getTaskLogs() {
            return null;
        }

        @Nullable
        default public Object getWebserverLogs() {
            return null;
        }

        @Nullable
        default public Object getWorkerLogs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoggingConfigurationProperty> {
            Object dagProcessingLogs;
            Object schedulerLogs;
            Object taskLogs;
            Object webserverLogs;
            Object workerLogs;

            public Builder dagProcessingLogs(ModuleLoggingConfigurationProperty dagProcessingLogs) {
                this.dagProcessingLogs = dagProcessingLogs;
                return this;
            }

            public Builder dagProcessingLogs(IResolvable dagProcessingLogs) {
                this.dagProcessingLogs = dagProcessingLogs;
                return this;
            }

            public Builder schedulerLogs(ModuleLoggingConfigurationProperty schedulerLogs) {
                this.schedulerLogs = schedulerLogs;
                return this;
            }

            public Builder schedulerLogs(IResolvable schedulerLogs) {
                this.schedulerLogs = schedulerLogs;
                return this;
            }

            public Builder taskLogs(ModuleLoggingConfigurationProperty taskLogs) {
                this.taskLogs = taskLogs;
                return this;
            }

            public Builder taskLogs(IResolvable taskLogs) {
                this.taskLogs = taskLogs;
                return this;
            }

            public Builder webserverLogs(ModuleLoggingConfigurationProperty webserverLogs) {
                this.webserverLogs = webserverLogs;
                return this;
            }

            public Builder webserverLogs(IResolvable webserverLogs) {
                this.webserverLogs = webserverLogs;
                return this;
            }

            public Builder workerLogs(ModuleLoggingConfigurationProperty workerLogs) {
                this.workerLogs = workerLogs;
                return this;
            }

            public Builder workerLogs(IResolvable workerLogs) {
                this.workerLogs = workerLogs;
                return this;
            }

            public LoggingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

