/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.rds.CfnDBProxy;
import software.amazon.awscdk.services.rds.CfnDBProxyProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBProxy")
public class CfnDBProxy
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDBProxy.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDBProxy(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBProxy(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDBProxy(@NotNull Construct scope, @NotNull String id, @NotNull CfnDBProxyProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrDbProxyArn() {
        return (String)Kernel.get((Object)this, (String)"attrDbProxyArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEndpoint() {
        return (String)Kernel.get((Object)this, (String)"attrEndpoint", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrVpcId() {
        return (String)Kernel.get((Object)this, (String)"attrVpcId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getAuth() {
        return Kernel.get((Object)this, (String)"auth", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAuth(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"auth", (Object)Objects.requireNonNull(value, "auth is required"));
    }

    public void setAuth(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof AuthFormatProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.rds.CfnDBProxy.AuthFormatProperty, software.amazon.awscdk.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"auth", Objects.requireNonNull(value, "auth is required"));
    }

    @NotNull
    public String getDbProxyName() {
        return (String)Kernel.get((Object)this, (String)"dbProxyName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbProxyName(@NotNull String value) {
        Kernel.set((Object)this, (String)"dbProxyName", (Object)Objects.requireNonNull(value, "dbProxyName is required"));
    }

    @NotNull
    public String getEngineFamily() {
        return (String)Kernel.get((Object)this, (String)"engineFamily", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngineFamily(@NotNull String value) {
        Kernel.set((Object)this, (String)"engineFamily", (Object)Objects.requireNonNull(value, "engineFamily is required"));
    }

    @NotNull
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"roleArn", (Object)Objects.requireNonNull(value, "roleArn is required"));
    }

    @NotNull
    public List<String> getVpcSubnetIds() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"vpcSubnetIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    public void setVpcSubnetIds(@NotNull List<String> value) {
        Kernel.set((Object)this, (String)"vpcSubnetIds", Objects.requireNonNull(value, "vpcSubnetIds is required"));
    }

    @Nullable
    public Object getDebugLogging() {
        return Kernel.get((Object)this, (String)"debugLogging", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDebugLogging(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"debugLogging", (Object)value);
    }

    public void setDebugLogging(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"debugLogging", (Object)value);
    }

    @Nullable
    public Number getIdleClientTimeout() {
        return (Number)Kernel.get((Object)this, (String)"idleClientTimeout", (NativeType)NativeType.forClass(Number.class));
    }

    public void setIdleClientTimeout(@Nullable Number value) {
        Kernel.set((Object)this, (String)"idleClientTimeout", (Object)value);
    }

    @Nullable
    public Object getRequireTls() {
        return Kernel.get((Object)this, (String)"requireTls", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRequireTls(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"requireTls", (Object)value);
    }

    public void setRequireTls(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"requireTls", (Object)value);
    }

    @Nullable
    public List<TagFormatProperty> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(TagFormatProperty.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<TagFormatProperty> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Nullable
    public List<String> getVpcSecurityGroupIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"vpcSecurityGroupIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setVpcSecurityGroupIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"vpcSecurityGroupIds", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDBProxy> {
        private final Construct scope;
        private final String id;
        private final CfnDBProxyProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDBProxyProps.Builder();
        }

        public Builder auth(IResolvable auth) {
            this.props.auth(auth);
            return this;
        }

        public Builder auth(List<? extends Object> auth) {
            this.props.auth(auth);
            return this;
        }

        public Builder dbProxyName(String dbProxyName) {
            this.props.dbProxyName(dbProxyName);
            return this;
        }

        public Builder engineFamily(String engineFamily) {
            this.props.engineFamily(engineFamily);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder vpcSubnetIds(List<String> vpcSubnetIds) {
            this.props.vpcSubnetIds(vpcSubnetIds);
            return this;
        }

        public Builder debugLogging(Boolean debugLogging) {
            this.props.debugLogging(debugLogging);
            return this;
        }

        public Builder debugLogging(IResolvable debugLogging) {
            this.props.debugLogging(debugLogging);
            return this;
        }

        public Builder idleClientTimeout(Number idleClientTimeout) {
            this.props.idleClientTimeout(idleClientTimeout);
            return this;
        }

        public Builder requireTls(Boolean requireTls) {
            this.props.requireTls(requireTls);
            return this;
        }

        public Builder requireTls(IResolvable requireTls) {
            this.props.requireTls(requireTls);
            return this;
        }

        public Builder tags(List<? extends TagFormatProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            this.props.vpcSecurityGroupIds(vpcSecurityGroupIds);
            return this;
        }

        public CfnDBProxy build() {
            return new CfnDBProxy(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBProxy.TagFormatProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagFormatProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKey() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagFormatProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TagFormatProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBProxy.AuthFormatProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthFormatProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAuthScheme() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public String getIamAuth() {
            return null;
        }

        @Nullable
        default public String getSecretArn() {
            return null;
        }

        @Nullable
        default public String getUserName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthFormatProperty> {
            String authScheme;
            String description;
            String iamAuth;
            String secretArn;
            String userName;

            public Builder authScheme(String authScheme) {
                this.authScheme = authScheme;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder iamAuth(String iamAuth) {
                this.iamAuth = iamAuth;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder userName(String userName) {
                this.userName = userName;
                return this;
            }

            public AuthFormatProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

