/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.secretsmanager;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.SecretValue;
import software.amazon.awscdk.services.iam.AddToResourcePolicyResult;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget;
import software.amazon.awscdk.services.secretsmanager.ReplicaRegion;
import software.amazon.awscdk.services.secretsmanager.RotationSchedule;
import software.amazon.awscdk.services.secretsmanager.RotationScheduleOptions;
import software.amazon.awscdk.services.secretsmanager.SecretAttributes;
import software.amazon.awscdk.services.secretsmanager.SecretProps;
import software.amazon.awscdk.services.secretsmanager.SecretStringGenerator;
import software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_secretsmanager.Secret")
public class Secret
extends Resource
implements ISecret {
    protected Secret(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Secret(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Secret(@NotNull Construct scope, @NotNull String id, @Nullable SecretProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Secret(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static ISecret fromSecretAttributes(@NotNull Construct scope, @NotNull String id, @NotNull SecretAttributes attrs) {
        return (ISecret)JsiiObject.jsiiStaticCall(Secret.class, (String)"fromSecretAttributes", (NativeType)NativeType.forClass(ISecret.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static ISecret fromSecretCompleteArn(@NotNull Construct scope, @NotNull String id, @NotNull String secretCompleteArn) {
        return (ISecret)JsiiObject.jsiiStaticCall(Secret.class, (String)"fromSecretCompleteArn", (NativeType)NativeType.forClass(ISecret.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(secretCompleteArn, "secretCompleteArn is required")});
    }

    @NotNull
    public static ISecret fromSecretNameV2(@NotNull Construct scope, @NotNull String id, @NotNull String secretName) {
        return (ISecret)JsiiObject.jsiiStaticCall(Secret.class, (String)"fromSecretNameV2", (NativeType)NativeType.forClass(ISecret.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(secretName, "secretName is required")});
    }

    @NotNull
    public static ISecret fromSecretPartialArn(@NotNull Construct scope, @NotNull String id, @NotNull String secretPartialArn) {
        return (ISecret)JsiiObject.jsiiStaticCall(Secret.class, (String)"fromSecretPartialArn", (NativeType)NativeType.forClass(ISecret.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(secretPartialArn, "secretPartialArn is required")});
    }

    @NotNull
    public static Boolean isSecret(@NotNull Object x) {
        return (Boolean)JsiiObject.jsiiStaticCall(Secret.class, (String)"isSecret", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{x});
    }

    public void addReplicaRegion(@NotNull String region, @Nullable IKey encryptionKey) {
        Kernel.call((Object)this, (String)"addReplicaRegion", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(region, "region is required"), encryptionKey});
    }

    public void addReplicaRegion(@NotNull String region) {
        Kernel.call((Object)this, (String)"addReplicaRegion", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(region, "region is required")});
    }

    @Override
    @NotNull
    public RotationSchedule addRotationSchedule(@NotNull String id, @NotNull RotationScheduleOptions options) {
        return (RotationSchedule)Kernel.call((Object)this, (String)"addRotationSchedule", (NativeType)NativeType.forClass(RotationSchedule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement statement) {
        return (AddToResourcePolicyResult)Kernel.call((Object)this, (String)"addToResourcePolicy", (NativeType)NativeType.forClass(AddToResourcePolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    public ISecret attach(@NotNull ISecretAttachmentTarget target) {
        return (ISecret)Kernel.call((Object)this, (String)"attach", (NativeType)NativeType.forClass(ISecret.class), (Object[])new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    @Override
    public void denyAccountRootDelete() {
        Kernel.call((Object)this, (String)"denyAccountRootDelete", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable grantee, @Nullable List<String> versionStages) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required"), versionStages}));
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public SecretValue secretValueFromJson(@NotNull String jsonField) {
        return (SecretValue)Kernel.call((Object)this, (String)"secretValueFromJson", (NativeType)NativeType.forClass(SecretValue.class), (Object[])new Object[]{Objects.requireNonNull(jsonField, "jsonField is required")});
    }

    @NotNull
    protected String getArnForPolicies() {
        return (String)Kernel.get((Object)this, (String)"arnForPolicies", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Boolean getAutoCreatePolicy() {
        return (Boolean)Kernel.get((Object)this, (String)"autoCreatePolicy", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @NotNull
    public String getSecretArn() {
        return (String)Kernel.get((Object)this, (String)"secretArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getSecretName() {
        return (String)Kernel.get((Object)this, (String)"secretName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public SecretValue getSecretValue() {
        return (SecretValue)Kernel.get((Object)this, (String)"secretValue", (NativeType)NativeType.forClass(SecretValue.class));
    }

    @Override
    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)Kernel.get((Object)this, (String)"encryptionKey", (NativeType)NativeType.forClass(IKey.class));
    }

    @Nullable
    public String getExcludeCharacters() {
        return (String)Kernel.get((Object)this, (String)"excludeCharacters", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public String getSecretFullArn() {
        return (String)Kernel.get((Object)this, (String)"secretFullArn", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Secret> {
        private final Construct scope;
        private final String id;
        private SecretProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        public Builder generateSecretString(SecretStringGenerator generateSecretString) {
            this.props().generateSecretString(generateSecretString);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        public Builder replicaRegions(List<? extends ReplicaRegion> replicaRegions) {
            this.props().replicaRegions(replicaRegions);
            return this;
        }

        public Builder secretName(String secretName) {
            this.props().secretName(secretName);
            return this;
        }

        public Builder secretObjectValue(Map<String, ? extends SecretValue> secretObjectValue) {
            this.props().secretObjectValue(secretObjectValue);
            return this;
        }

        @Deprecated
        public Builder secretStringBeta1(SecretStringValueBeta1 secretStringBeta1) {
            this.props().secretStringBeta1(secretStringBeta1);
            return this;
        }

        public Builder secretStringValue(SecretValue secretStringValue) {
            this.props().secretStringValue(secretStringValue);
            return this;
        }

        public Secret build() {
            return new Secret(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private SecretProps.Builder props() {
            if (this.props == null) {
                this.props = new SecretProps.Builder();
            }
            return this.props;
        }
    }
}

