/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.apigateway.CfnMethod;
import software.amazon.awscdk.services.apigateway.CfnMethodProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_apigateway.CfnMethod")
public class CfnMethod
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnMethod.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnMethod(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMethod(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnMethod(@NotNull Construct scope, @NotNull String id, @NotNull CfnMethodProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getHttpMethod() {
        return (String)Kernel.get((Object)this, (String)"httpMethod", (NativeType)NativeType.forClass(String.class));
    }

    public void setHttpMethod(@NotNull String value) {
        Kernel.set((Object)this, (String)"httpMethod", (Object)Objects.requireNonNull(value, "httpMethod is required"));
    }

    @NotNull
    public String getResourceId() {
        return (String)Kernel.get((Object)this, (String)"resourceId", (NativeType)NativeType.forClass(String.class));
    }

    public void setResourceId(@NotNull String value) {
        Kernel.set((Object)this, (String)"resourceId", (Object)Objects.requireNonNull(value, "resourceId is required"));
    }

    @NotNull
    public String getRestApiId() {
        return (String)Kernel.get((Object)this, (String)"restApiId", (NativeType)NativeType.forClass(String.class));
    }

    public void setRestApiId(@NotNull String value) {
        Kernel.set((Object)this, (String)"restApiId", (Object)Objects.requireNonNull(value, "restApiId is required"));
    }

    @Nullable
    public Object getApiKeyRequired() {
        return Kernel.get((Object)this, (String)"apiKeyRequired", (NativeType)NativeType.forClass(Object.class));
    }

    public void setApiKeyRequired(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"apiKeyRequired", (Object)value);
    }

    public void setApiKeyRequired(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"apiKeyRequired", (Object)value);
    }

    @Nullable
    public List<String> getAuthorizationScopes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"authorizationScopes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAuthorizationScopes(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"authorizationScopes", value);
    }

    @Nullable
    public String getAuthorizationType() {
        return (String)Kernel.get((Object)this, (String)"authorizationType", (NativeType)NativeType.forClass(String.class));
    }

    public void setAuthorizationType(@Nullable String value) {
        Kernel.set((Object)this, (String)"authorizationType", (Object)value);
    }

    @Nullable
    public String getAuthorizerId() {
        return (String)Kernel.get((Object)this, (String)"authorizerId", (NativeType)NativeType.forClass(String.class));
    }

    public void setAuthorizerId(@Nullable String value) {
        Kernel.set((Object)this, (String)"authorizerId", (Object)value);
    }

    @Nullable
    public Object getIntegration() {
        return Kernel.get((Object)this, (String)"integration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIntegration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"integration", (Object)value);
    }

    public void setIntegration(@Nullable IntegrationProperty value) {
        Kernel.set((Object)this, (String)"integration", (Object)value);
    }

    @Nullable
    public Object getMethodResponses() {
        return Kernel.get((Object)this, (String)"methodResponses", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMethodResponses(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"methodResponses", (Object)value);
    }

    public void setMethodResponses(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof MethodResponseProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.apigateway.CfnMethod.MethodResponseProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"methodResponses", value);
    }

    @Nullable
    public String getOperationName() {
        return (String)Kernel.get((Object)this, (String)"operationName", (NativeType)NativeType.forClass(String.class));
    }

    public void setOperationName(@Nullable String value) {
        Kernel.set((Object)this, (String)"operationName", (Object)value);
    }

    @Nullable
    public Object getRequestModels() {
        return Kernel.get((Object)this, (String)"requestModels", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRequestModels(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"requestModels", (Object)value);
    }

    public void setRequestModels(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"requestModels", value);
    }

    @Nullable
    public Object getRequestParameters() {
        return Kernel.get((Object)this, (String)"requestParameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRequestParameters(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"requestParameters", (Object)value);
    }

    public void setRequestParameters(@Nullable Map<String, Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException("Expected " + "value" + ".keySet()" + " to contain class String; received " + value.keySet().toArray()[0].getClass());
            }
            for (Map.Entry<String, Object> __item_ac66f0 : value.entrySet()) {
                Object __val_ac66f0 = __item_ac66f0.getValue();
                if (__val_ac66f0 instanceof Boolean || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(\"" + __item_ac66f0.getKey() + "\")" + " to be one of: java.lang.Boolean, software.amazon.awscdk.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"requestParameters", value);
    }

    @Nullable
    public String getRequestValidatorId() {
        return (String)Kernel.get((Object)this, (String)"requestValidatorId", (NativeType)NativeType.forClass(String.class));
    }

    public void setRequestValidatorId(@Nullable String value) {
        Kernel.set((Object)this, (String)"requestValidatorId", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnMethod> {
        private final Construct scope;
        private final String id;
        private final CfnMethodProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnMethodProps.Builder();
        }

        public Builder httpMethod(String httpMethod) {
            this.props.httpMethod(httpMethod);
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        public Builder restApiId(String restApiId) {
            this.props.restApiId(restApiId);
            return this;
        }

        public Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.props.apiKeyRequired(apiKeyRequired);
            return this;
        }

        public Builder apiKeyRequired(IResolvable apiKeyRequired) {
            this.props.apiKeyRequired(apiKeyRequired);
            return this;
        }

        public Builder authorizationScopes(List<String> authorizationScopes) {
            this.props.authorizationScopes(authorizationScopes);
            return this;
        }

        public Builder authorizationType(String authorizationType) {
            this.props.authorizationType(authorizationType);
            return this;
        }

        public Builder authorizerId(String authorizerId) {
            this.props.authorizerId(authorizerId);
            return this;
        }

        public Builder integration(IResolvable integration) {
            this.props.integration(integration);
            return this;
        }

        public Builder integration(IntegrationProperty integration) {
            this.props.integration(integration);
            return this;
        }

        public Builder methodResponses(IResolvable methodResponses) {
            this.props.methodResponses(methodResponses);
            return this;
        }

        public Builder methodResponses(List<? extends Object> methodResponses) {
            this.props.methodResponses(methodResponses);
            return this;
        }

        public Builder operationName(String operationName) {
            this.props.operationName(operationName);
            return this;
        }

        public Builder requestModels(IResolvable requestModels) {
            this.props.requestModels(requestModels);
            return this;
        }

        public Builder requestModels(Map<String, String> requestModels) {
            this.props.requestModels(requestModels);
            return this;
        }

        public Builder requestParameters(IResolvable requestParameters) {
            this.props.requestParameters(requestParameters);
            return this;
        }

        public Builder requestParameters(Map<String, ? extends Object> requestParameters) {
            this.props.requestParameters(requestParameters);
            return this;
        }

        public Builder requestValidatorId(String requestValidatorId) {
            this.props.requestValidatorId(requestValidatorId);
            return this;
        }

        public CfnMethod build() {
            return new CfnMethod(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_apigateway.CfnMethod.MethodResponseProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MethodResponseProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatusCode();

        @Nullable
        default public Object getResponseModels() {
            return null;
        }

        @Nullable
        default public Object getResponseParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MethodResponseProperty> {
            String statusCode;
            Object responseModels;
            Object responseParameters;

            public Builder statusCode(String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            public Builder responseModels(IResolvable responseModels) {
                this.responseModels = responseModels;
                return this;
            }

            public Builder responseModels(Map<String, String> responseModels) {
                this.responseModels = responseModels;
                return this;
            }

            public Builder responseParameters(IResolvable responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            public Builder responseParameters(Map<String, ? extends Object> responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            public MethodResponseProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_apigateway.CfnMethod.IntegrationResponseProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IntegrationResponseProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatusCode();

        @Nullable
        default public String getContentHandling() {
            return null;
        }

        @Nullable
        default public Object getResponseParameters() {
            return null;
        }

        @Nullable
        default public Object getResponseTemplates() {
            return null;
        }

        @Nullable
        default public String getSelectionPattern() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IntegrationResponseProperty> {
            String statusCode;
            String contentHandling;
            Object responseParameters;
            Object responseTemplates;
            String selectionPattern;

            public Builder statusCode(String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            public Builder contentHandling(String contentHandling) {
                this.contentHandling = contentHandling;
                return this;
            }

            public Builder responseParameters(IResolvable responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            public Builder responseParameters(Map<String, String> responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            public Builder responseTemplates(IResolvable responseTemplates) {
                this.responseTemplates = responseTemplates;
                return this;
            }

            public Builder responseTemplates(Map<String, String> responseTemplates) {
                this.responseTemplates = responseTemplates;
                return this;
            }

            public Builder selectionPattern(String selectionPattern) {
                this.selectionPattern = selectionPattern;
                return this;
            }

            public IntegrationResponseProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_apigateway.CfnMethod.IntegrationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IntegrationProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getCacheKeyParameters() {
            return null;
        }

        @Nullable
        default public String getCacheNamespace() {
            return null;
        }

        @Nullable
        default public String getConnectionId() {
            return null;
        }

        @Nullable
        default public String getConnectionType() {
            return null;
        }

        @Nullable
        default public String getContentHandling() {
            return null;
        }

        @Nullable
        default public String getCredentials() {
            return null;
        }

        @Nullable
        default public String getIntegrationHttpMethod() {
            return null;
        }

        @Nullable
        default public Object getIntegrationResponses() {
            return null;
        }

        @Nullable
        default public String getPassthroughBehavior() {
            return null;
        }

        @Nullable
        default public Object getRequestParameters() {
            return null;
        }

        @Nullable
        default public Object getRequestTemplates() {
            return null;
        }

        @Nullable
        default public Number getTimeoutInMillis() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public String getUri() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IntegrationProperty> {
            List<String> cacheKeyParameters;
            String cacheNamespace;
            String connectionId;
            String connectionType;
            String contentHandling;
            String credentials;
            String integrationHttpMethod;
            Object integrationResponses;
            String passthroughBehavior;
            Object requestParameters;
            Object requestTemplates;
            Number timeoutInMillis;
            String type;
            String uri;

            public Builder cacheKeyParameters(List<String> cacheKeyParameters) {
                this.cacheKeyParameters = cacheKeyParameters;
                return this;
            }

            public Builder cacheNamespace(String cacheNamespace) {
                this.cacheNamespace = cacheNamespace;
                return this;
            }

            public Builder connectionId(String connectionId) {
                this.connectionId = connectionId;
                return this;
            }

            public Builder connectionType(String connectionType) {
                this.connectionType = connectionType;
                return this;
            }

            public Builder contentHandling(String contentHandling) {
                this.contentHandling = contentHandling;
                return this;
            }

            public Builder credentials(String credentials) {
                this.credentials = credentials;
                return this;
            }

            public Builder integrationHttpMethod(String integrationHttpMethod) {
                this.integrationHttpMethod = integrationHttpMethod;
                return this;
            }

            public Builder integrationResponses(IResolvable integrationResponses) {
                this.integrationResponses = integrationResponses;
                return this;
            }

            public Builder integrationResponses(List<? extends Object> integrationResponses) {
                this.integrationResponses = integrationResponses;
                return this;
            }

            public Builder passthroughBehavior(String passthroughBehavior) {
                this.passthroughBehavior = passthroughBehavior;
                return this;
            }

            public Builder requestParameters(IResolvable requestParameters) {
                this.requestParameters = requestParameters;
                return this;
            }

            public Builder requestParameters(Map<String, String> requestParameters) {
                this.requestParameters = requestParameters;
                return this;
            }

            public Builder requestTemplates(IResolvable requestTemplates) {
                this.requestTemplates = requestTemplates;
                return this;
            }

            public Builder requestTemplates(Map<String, String> requestTemplates) {
                this.requestTemplates = requestTemplates;
                return this;
            }

            public Builder timeoutInMillis(Number timeoutInMillis) {
                this.timeoutInMillis = timeoutInMillis;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder uri(String uri) {
                this.uri = uri;
                return this;
            }

            public IntegrationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

