/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cognito;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.cognito.CfnUserPoolClient;
import software.amazon.awscdk.services.cognito.CfnUserPoolClientProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPoolClient")
public class CfnUserPoolClient
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnUserPoolClient.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnUserPoolClient(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUserPoolClient(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnUserPoolClient(@NotNull Construct scope, @NotNull String id, @NotNull CfnUserPoolClientProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrClientSecret() {
        return (String)Kernel.get((Object)this, (String)"attrClientSecret", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrName() {
        return (String)Kernel.get((Object)this, (String)"attrName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getUserPoolId() {
        return (String)Kernel.get((Object)this, (String)"userPoolId", (NativeType)NativeType.forClass(String.class));
    }

    public void setUserPoolId(@NotNull String value) {
        Kernel.set((Object)this, (String)"userPoolId", (Object)Objects.requireNonNull(value, "userPoolId is required"));
    }

    @Nullable
    public Number getAccessTokenValidity() {
        return (Number)Kernel.get((Object)this, (String)"accessTokenValidity", (NativeType)NativeType.forClass(Number.class));
    }

    public void setAccessTokenValidity(@Nullable Number value) {
        Kernel.set((Object)this, (String)"accessTokenValidity", (Object)value);
    }

    @Nullable
    public List<String> getAllowedOAuthFlows() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"allowedOAuthFlows", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAllowedOAuthFlows(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"allowedOAuthFlows", value);
    }

    @Nullable
    public Object getAllowedOAuthFlowsUserPoolClient() {
        return Kernel.get((Object)this, (String)"allowedOAuthFlowsUserPoolClient", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAllowedOAuthFlowsUserPoolClient(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"allowedOAuthFlowsUserPoolClient", (Object)value);
    }

    public void setAllowedOAuthFlowsUserPoolClient(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"allowedOAuthFlowsUserPoolClient", (Object)value);
    }

    @Nullable
    public List<String> getAllowedOAuthScopes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"allowedOAuthScopes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAllowedOAuthScopes(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"allowedOAuthScopes", value);
    }

    @Nullable
    public Object getAnalyticsConfiguration() {
        return Kernel.get((Object)this, (String)"analyticsConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAnalyticsConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"analyticsConfiguration", (Object)value);
    }

    public void setAnalyticsConfiguration(@Nullable AnalyticsConfigurationProperty value) {
        Kernel.set((Object)this, (String)"analyticsConfiguration", (Object)value);
    }

    @Nullable
    public Number getAuthSessionValidity() {
        return (Number)Kernel.get((Object)this, (String)"authSessionValidity", (NativeType)NativeType.forClass(Number.class));
    }

    public void setAuthSessionValidity(@Nullable Number value) {
        Kernel.set((Object)this, (String)"authSessionValidity", (Object)value);
    }

    @Nullable
    public List<String> getCallbackUrLs() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"callbackUrLs", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setCallbackUrLs(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"callbackUrLs", value);
    }

    @Nullable
    public String getClientName() {
        return (String)Kernel.get((Object)this, (String)"clientName", (NativeType)NativeType.forClass(String.class));
    }

    public void setClientName(@Nullable String value) {
        Kernel.set((Object)this, (String)"clientName", (Object)value);
    }

    @Nullable
    public String getDefaultRedirectUri() {
        return (String)Kernel.get((Object)this, (String)"defaultRedirectUri", (NativeType)NativeType.forClass(String.class));
    }

    public void setDefaultRedirectUri(@Nullable String value) {
        Kernel.set((Object)this, (String)"defaultRedirectUri", (Object)value);
    }

    @Nullable
    public Object getEnablePropagateAdditionalUserContextData() {
        return Kernel.get((Object)this, (String)"enablePropagateAdditionalUserContextData", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnablePropagateAdditionalUserContextData(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enablePropagateAdditionalUserContextData", (Object)value);
    }

    public void setEnablePropagateAdditionalUserContextData(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enablePropagateAdditionalUserContextData", (Object)value);
    }

    @Nullable
    public Object getEnableTokenRevocation() {
        return Kernel.get((Object)this, (String)"enableTokenRevocation", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnableTokenRevocation(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableTokenRevocation", (Object)value);
    }

    public void setEnableTokenRevocation(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enableTokenRevocation", (Object)value);
    }

    @Nullable
    public List<String> getExplicitAuthFlows() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"explicitAuthFlows", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setExplicitAuthFlows(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"explicitAuthFlows", value);
    }

    @Nullable
    public Object getGenerateSecret() {
        return Kernel.get((Object)this, (String)"generateSecret", (NativeType)NativeType.forClass(Object.class));
    }

    public void setGenerateSecret(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"generateSecret", (Object)value);
    }

    public void setGenerateSecret(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"generateSecret", (Object)value);
    }

    @Nullable
    public Number getIdTokenValidity() {
        return (Number)Kernel.get((Object)this, (String)"idTokenValidity", (NativeType)NativeType.forClass(Number.class));
    }

    public void setIdTokenValidity(@Nullable Number value) {
        Kernel.set((Object)this, (String)"idTokenValidity", (Object)value);
    }

    @Nullable
    public List<String> getLogoutUrLs() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"logoutUrLs", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setLogoutUrLs(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"logoutUrLs", value);
    }

    @Nullable
    public String getPreventUserExistenceErrors() {
        return (String)Kernel.get((Object)this, (String)"preventUserExistenceErrors", (NativeType)NativeType.forClass(String.class));
    }

    public void setPreventUserExistenceErrors(@Nullable String value) {
        Kernel.set((Object)this, (String)"preventUserExistenceErrors", (Object)value);
    }

    @Nullable
    public List<String> getReadAttributes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"readAttributes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setReadAttributes(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"readAttributes", value);
    }

    @Nullable
    public Number getRefreshTokenValidity() {
        return (Number)Kernel.get((Object)this, (String)"refreshTokenValidity", (NativeType)NativeType.forClass(Number.class));
    }

    public void setRefreshTokenValidity(@Nullable Number value) {
        Kernel.set((Object)this, (String)"refreshTokenValidity", (Object)value);
    }

    @Nullable
    public List<String> getSupportedIdentityProviders() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"supportedIdentityProviders", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSupportedIdentityProviders(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"supportedIdentityProviders", value);
    }

    @Nullable
    public Object getTokenValidityUnits() {
        return Kernel.get((Object)this, (String)"tokenValidityUnits", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTokenValidityUnits(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"tokenValidityUnits", (Object)value);
    }

    public void setTokenValidityUnits(@Nullable TokenValidityUnitsProperty value) {
        Kernel.set((Object)this, (String)"tokenValidityUnits", (Object)value);
    }

    @Nullable
    public List<String> getWriteAttributes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"writeAttributes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setWriteAttributes(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"writeAttributes", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnUserPoolClient> {
        private final Construct scope;
        private final String id;
        private final CfnUserPoolClientProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnUserPoolClientProps.Builder();
        }

        public Builder userPoolId(String userPoolId) {
            this.props.userPoolId(userPoolId);
            return this;
        }

        public Builder accessTokenValidity(Number accessTokenValidity) {
            this.props.accessTokenValidity(accessTokenValidity);
            return this;
        }

        public Builder allowedOAuthFlows(List<String> allowedOAuthFlows) {
            this.props.allowedOAuthFlows(allowedOAuthFlows);
            return this;
        }

        public Builder allowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient) {
            this.props.allowedOAuthFlowsUserPoolClient(allowedOAuthFlowsUserPoolClient);
            return this;
        }

        public Builder allowedOAuthFlowsUserPoolClient(IResolvable allowedOAuthFlowsUserPoolClient) {
            this.props.allowedOAuthFlowsUserPoolClient(allowedOAuthFlowsUserPoolClient);
            return this;
        }

        public Builder allowedOAuthScopes(List<String> allowedOAuthScopes) {
            this.props.allowedOAuthScopes(allowedOAuthScopes);
            return this;
        }

        public Builder analyticsConfiguration(IResolvable analyticsConfiguration) {
            this.props.analyticsConfiguration(analyticsConfiguration);
            return this;
        }

        public Builder analyticsConfiguration(AnalyticsConfigurationProperty analyticsConfiguration) {
            this.props.analyticsConfiguration(analyticsConfiguration);
            return this;
        }

        public Builder authSessionValidity(Number authSessionValidity) {
            this.props.authSessionValidity(authSessionValidity);
            return this;
        }

        public Builder callbackUrLs(List<String> callbackUrLs) {
            this.props.callbackUrLs(callbackUrLs);
            return this;
        }

        public Builder clientName(String clientName) {
            this.props.clientName(clientName);
            return this;
        }

        public Builder defaultRedirectUri(String defaultRedirectUri) {
            this.props.defaultRedirectUri(defaultRedirectUri);
            return this;
        }

        public Builder enablePropagateAdditionalUserContextData(Boolean enablePropagateAdditionalUserContextData) {
            this.props.enablePropagateAdditionalUserContextData(enablePropagateAdditionalUserContextData);
            return this;
        }

        public Builder enablePropagateAdditionalUserContextData(IResolvable enablePropagateAdditionalUserContextData) {
            this.props.enablePropagateAdditionalUserContextData(enablePropagateAdditionalUserContextData);
            return this;
        }

        public Builder enableTokenRevocation(Boolean enableTokenRevocation) {
            this.props.enableTokenRevocation(enableTokenRevocation);
            return this;
        }

        public Builder enableTokenRevocation(IResolvable enableTokenRevocation) {
            this.props.enableTokenRevocation(enableTokenRevocation);
            return this;
        }

        public Builder explicitAuthFlows(List<String> explicitAuthFlows) {
            this.props.explicitAuthFlows(explicitAuthFlows);
            return this;
        }

        public Builder generateSecret(Boolean generateSecret) {
            this.props.generateSecret(generateSecret);
            return this;
        }

        public Builder generateSecret(IResolvable generateSecret) {
            this.props.generateSecret(generateSecret);
            return this;
        }

        public Builder idTokenValidity(Number idTokenValidity) {
            this.props.idTokenValidity(idTokenValidity);
            return this;
        }

        public Builder logoutUrLs(List<String> logoutUrLs) {
            this.props.logoutUrLs(logoutUrLs);
            return this;
        }

        public Builder preventUserExistenceErrors(String preventUserExistenceErrors) {
            this.props.preventUserExistenceErrors(preventUserExistenceErrors);
            return this;
        }

        public Builder readAttributes(List<String> readAttributes) {
            this.props.readAttributes(readAttributes);
            return this;
        }

        public Builder refreshTokenValidity(Number refreshTokenValidity) {
            this.props.refreshTokenValidity(refreshTokenValidity);
            return this;
        }

        public Builder supportedIdentityProviders(List<String> supportedIdentityProviders) {
            this.props.supportedIdentityProviders(supportedIdentityProviders);
            return this;
        }

        public Builder tokenValidityUnits(IResolvable tokenValidityUnits) {
            this.props.tokenValidityUnits(tokenValidityUnits);
            return this;
        }

        public Builder tokenValidityUnits(TokenValidityUnitsProperty tokenValidityUnits) {
            this.props.tokenValidityUnits(tokenValidityUnits);
            return this;
        }

        public Builder writeAttributes(List<String> writeAttributes) {
            this.props.writeAttributes(writeAttributes);
            return this;
        }

        public CfnUserPoolClient build() {
            return new CfnUserPoolClient(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPoolClient.TokenValidityUnitsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TokenValidityUnitsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccessToken() {
            return null;
        }

        @Nullable
        default public String getIdToken() {
            return null;
        }

        @Nullable
        default public String getRefreshToken() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TokenValidityUnitsProperty> {
            String accessToken;
            String idToken;
            String refreshToken;

            public Builder accessToken(String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            public Builder idToken(String idToken) {
                this.idToken = idToken;
                return this;
            }

            public Builder refreshToken(String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            public TokenValidityUnitsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPoolClient.AnalyticsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalyticsConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getApplicationArn() {
            return null;
        }

        @Nullable
        default public String getApplicationId() {
            return null;
        }

        @Nullable
        default public String getExternalId() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        @Nullable
        default public Object getUserDataShared() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalyticsConfigurationProperty> {
            String applicationArn;
            String applicationId;
            String externalId;
            String roleArn;
            Object userDataShared;

            public Builder applicationArn(String applicationArn) {
                this.applicationArn = applicationArn;
                return this;
            }

            public Builder applicationId(String applicationId) {
                this.applicationId = applicationId;
                return this;
            }

            public Builder externalId(String externalId) {
                this.externalId = externalId;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder userDataShared(Boolean userDataShared) {
                this.userDataShared = userDataShared;
                return this;
            }

            public Builder userDataShared(IResolvable userDataShared) {
                this.userDataShared = userDataShared;
                return this;
            }

            public AnalyticsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

