/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iot;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.iot.CfnTopicRule;
import software.amazon.awscdk.services.iot.CfnTopicRuleProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule")
public class CfnTopicRule
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnTopicRule.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnTopicRule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTopicRule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnTopicRule(@NotNull Construct scope, @NotNull String id, @NotNull CfnTopicRuleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getTopicRulePayload() {
        return Kernel.get((Object)this, (String)"topicRulePayload", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTopicRulePayload(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"topicRulePayload", (Object)Objects.requireNonNull(value, "topicRulePayload is required"));
    }

    public void setTopicRulePayload(@NotNull TopicRulePayloadProperty value) {
        Kernel.set((Object)this, (String)"topicRulePayload", (Object)Objects.requireNonNull(value, "topicRulePayload is required"));
    }

    @Nullable
    public String getRuleName() {
        return (String)Kernel.get((Object)this, (String)"ruleName", (NativeType)NativeType.forClass(String.class));
    }

    public void setRuleName(@Nullable String value) {
        Kernel.set((Object)this, (String)"ruleName", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnTopicRule> {
        private final Construct scope;
        private final String id;
        private final CfnTopicRuleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnTopicRuleProps.Builder();
        }

        public Builder topicRulePayload(IResolvable topicRulePayload) {
            this.props.topicRulePayload(topicRulePayload);
            return this;
        }

        public Builder topicRulePayload(TopicRulePayloadProperty topicRulePayload) {
            this.props.topicRulePayload(topicRulePayload);
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.props.ruleName(ruleName);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnTopicRule build() {
            return new CfnTopicRule(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.UserPropertyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UserPropertyProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UserPropertyProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public UserPropertyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.TopicRulePayloadProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TopicRulePayloadProperty
    extends JsiiSerializable {
        @NotNull
        public Object getActions();

        @NotNull
        public String getSql();

        @Nullable
        default public String getAwsIotSqlVersion() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public Object getErrorAction() {
            return null;
        }

        @Nullable
        default public Object getRuleDisabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TopicRulePayloadProperty> {
            Object actions;
            String sql;
            String awsIotSqlVersion;
            String description;
            Object errorAction;
            Object ruleDisabled;

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder sql(String sql) {
                this.sql = sql;
                return this;
            }

            public Builder awsIotSqlVersion(String awsIotSqlVersion) {
                this.awsIotSqlVersion = awsIotSqlVersion;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder errorAction(IResolvable errorAction) {
                this.errorAction = errorAction;
                return this;
            }

            public Builder errorAction(ActionProperty errorAction) {
                this.errorAction = errorAction;
                return this;
            }

            public Builder ruleDisabled(Boolean ruleDisabled) {
                this.ruleDisabled = ruleDisabled;
                return this;
            }

            public Builder ruleDisabled(IResolvable ruleDisabled) {
                this.ruleDisabled = ruleDisabled;
                return this;
            }

            public TopicRulePayloadProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.TimestreamTimestampProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimestreamTimestampProperty
    extends JsiiSerializable {
        @NotNull
        public String getUnit();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimestreamTimestampProperty> {
            String unit;
            String value;

            public Builder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TimestreamTimestampProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.TimestreamDimensionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimestreamDimensionProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimestreamDimensionProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TimestreamDimensionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.TimestreamActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimestreamActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabaseName();

        @NotNull
        public Object getDimensions();

        @NotNull
        public String getRoleArn();

        @NotNull
        public String getTableName();

        @Nullable
        default public Object getTimestamp() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimestreamActionProperty> {
            String databaseName;
            Object dimensions;
            String roleArn;
            String tableName;
            Object timestamp;

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder dimensions(IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder dimensions(List<? extends Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder timestamp(IResolvable timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public Builder timestamp(TimestreamTimestampProperty timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public TimestreamActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.TimestampProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimestampProperty
    extends JsiiSerializable {
        @NotNull
        public String getValue();

        @Nullable
        default public String getUnit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimestampProperty> {
            String value;
            String unit;

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Builder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public TimestampProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.StepFunctionsActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StepFunctionsActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @NotNull
        public String getStateMachineName();

        @Nullable
        default public String getExecutionNamePrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StepFunctionsActionProperty> {
            String roleArn;
            String stateMachineName;
            String executionNamePrefix;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder stateMachineName(String stateMachineName) {
                this.stateMachineName = stateMachineName;
                return this;
            }

            public Builder executionNamePrefix(String executionNamePrefix) {
                this.executionNamePrefix = executionNamePrefix;
                return this;
            }

            public StepFunctionsActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.SqsActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SqsActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getQueueUrl();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public Object getUseBase64() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SqsActionProperty> {
            String queueUrl;
            String roleArn;
            Object useBase64;

            public Builder queueUrl(String queueUrl) {
                this.queueUrl = queueUrl;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder useBase64(Boolean useBase64) {
                this.useBase64 = useBase64;
                return this;
            }

            public Builder useBase64(IResolvable useBase64) {
                this.useBase64 = useBase64;
                return this;
            }

            public SqsActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.SnsActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SnsActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @NotNull
        public String getTargetArn();

        @Nullable
        default public String getMessageFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SnsActionProperty> {
            String roleArn;
            String targetArn;
            String messageFormat;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder targetArn(String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            public Builder messageFormat(String messageFormat) {
                this.messageFormat = messageFormat;
                return this;
            }

            public SnsActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.SigV4AuthorizationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SigV4AuthorizationProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @NotNull
        public String getServiceName();

        @NotNull
        public String getSigningRegion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SigV4AuthorizationProperty> {
            String roleArn;
            String serviceName;
            String signingRegion;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder serviceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            public Builder signingRegion(String signingRegion) {
                this.signingRegion = signingRegion;
                return this;
            }

            public SigV4AuthorizationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.S3ActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3ActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        @NotNull
        public String getKey();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public String getCannedAcl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3ActionProperty> {
            String bucketName;
            String key;
            String roleArn;
            String cannedAcl;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder cannedAcl(String cannedAcl) {
                this.cannedAcl = cannedAcl;
                return this;
            }

            public S3ActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.RepublishActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RepublishActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @NotNull
        public String getTopic();

        @Nullable
        default public Object getHeaders() {
            return null;
        }

        @Nullable
        default public Number getQos() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RepublishActionProperty> {
            String roleArn;
            String topic;
            Object headers;
            Number qos;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder topic(String topic) {
                this.topic = topic;
                return this;
            }

            public Builder headers(IResolvable headers) {
                this.headers = headers;
                return this;
            }

            public Builder headers(RepublishActionHeadersProperty headers) {
                this.headers = headers;
                return this;
            }

            public Builder qos(Number qos) {
                this.qos = qos;
                return this;
            }

            public RepublishActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.RepublishActionHeadersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RepublishActionHeadersProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContentType() {
            return null;
        }

        @Nullable
        default public String getCorrelationData() {
            return null;
        }

        @Nullable
        default public String getMessageExpiry() {
            return null;
        }

        @Nullable
        default public String getPayloadFormatIndicator() {
            return null;
        }

        @Nullable
        default public String getResponseTopic() {
            return null;
        }

        @Nullable
        default public Object getUserProperties() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RepublishActionHeadersProperty> {
            String contentType;
            String correlationData;
            String messageExpiry;
            String payloadFormatIndicator;
            String responseTopic;
            Object userProperties;

            public Builder contentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            public Builder correlationData(String correlationData) {
                this.correlationData = correlationData;
                return this;
            }

            public Builder messageExpiry(String messageExpiry) {
                this.messageExpiry = messageExpiry;
                return this;
            }

            public Builder payloadFormatIndicator(String payloadFormatIndicator) {
                this.payloadFormatIndicator = payloadFormatIndicator;
                return this;
            }

            public Builder responseTopic(String responseTopic) {
                this.responseTopic = responseTopic;
                return this;
            }

            public Builder userProperties(IResolvable userProperties) {
                this.userProperties = userProperties;
                return this;
            }

            public Builder userProperties(List<? extends Object> userProperties) {
                this.userProperties = userProperties;
                return this;
            }

            public RepublishActionHeadersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.PutItemInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PutItemInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PutItemInputProperty> {
            String tableName;

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public PutItemInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.PutAssetPropertyValueEntryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PutAssetPropertyValueEntryProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPropertyValues();

        @Nullable
        default public String getAssetId() {
            return null;
        }

        @Nullable
        default public String getEntryId() {
            return null;
        }

        @Nullable
        default public String getPropertyAlias() {
            return null;
        }

        @Nullable
        default public String getPropertyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PutAssetPropertyValueEntryProperty> {
            Object propertyValues;
            String assetId;
            String entryId;
            String propertyAlias;
            String propertyId;

            public Builder propertyValues(IResolvable propertyValues) {
                this.propertyValues = propertyValues;
                return this;
            }

            public Builder propertyValues(List<? extends Object> propertyValues) {
                this.propertyValues = propertyValues;
                return this;
            }

            public Builder assetId(String assetId) {
                this.assetId = assetId;
                return this;
            }

            public Builder entryId(String entryId) {
                this.entryId = entryId;
                return this;
            }

            public Builder propertyAlias(String propertyAlias) {
                this.propertyAlias = propertyAlias;
                return this;
            }

            public Builder propertyId(String propertyId) {
                this.propertyId = propertyId;
                return this;
            }

            public PutAssetPropertyValueEntryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.OpenSearchActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OpenSearchActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getEndpoint();

        @NotNull
        public String getId();

        @NotNull
        public String getIndex();

        @NotNull
        public String getRoleArn();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OpenSearchActionProperty> {
            String endpoint;
            String id;
            String index;
            String roleArn;
            String type;

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder index(String index) {
                this.index = index;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public OpenSearchActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.LocationActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LocationActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getDeviceId();

        @NotNull
        public String getLatitude();

        @NotNull
        public String getLongitude();

        @NotNull
        public String getRoleArn();

        @NotNull
        public String getTrackerName();

        @Nullable
        default public Object getTimestamp() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LocationActionProperty> {
            String deviceId;
            String latitude;
            String longitude;
            String roleArn;
            String trackerName;
            Object timestamp;

            public Builder deviceId(String deviceId) {
                this.deviceId = deviceId;
                return this;
            }

            public Builder latitude(String latitude) {
                this.latitude = latitude;
                return this;
            }

            public Builder longitude(String longitude) {
                this.longitude = longitude;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder trackerName(String trackerName) {
                this.trackerName = trackerName;
                return this;
            }

            public Builder timestamp(IResolvable timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public Builder timestamp(Instant timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public LocationActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.LambdaActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaActionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getFunctionArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LambdaActionProperty> {
            String functionArn;

            public Builder functionArn(String functionArn) {
                this.functionArn = functionArn;
                return this;
            }

            public LambdaActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.KinesisActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @NotNull
        public String getStreamName();

        @Nullable
        default public String getPartitionKey() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisActionProperty> {
            String roleArn;
            String streamName;
            String partitionKey;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder streamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            public Builder partitionKey(String partitionKey) {
                this.partitionKey = partitionKey;
                return this;
            }

            public KinesisActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.KafkaActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KafkaActionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getClientProperties();

        @NotNull
        public String getDestinationArn();

        @NotNull
        public String getTopic();

        @Nullable
        default public String getKey() {
            return null;
        }

        @Nullable
        default public String getPartition() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KafkaActionProperty> {
            Object clientProperties;
            String destinationArn;
            String topic;
            String key;
            String partition;

            public Builder clientProperties(IResolvable clientProperties) {
                this.clientProperties = clientProperties;
                return this;
            }

            public Builder clientProperties(Map<String, String> clientProperties) {
                this.clientProperties = clientProperties;
                return this;
            }

            public Builder destinationArn(String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            public Builder topic(String topic) {
                this.topic = topic;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder partition(String partition) {
                this.partition = partition;
                return this;
            }

            public KafkaActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.IotSiteWiseActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IotSiteWiseActionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPutAssetPropertyValueEntries();

        @NotNull
        public String getRoleArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IotSiteWiseActionProperty> {
            Object putAssetPropertyValueEntries;
            String roleArn;

            public Builder putAssetPropertyValueEntries(IResolvable putAssetPropertyValueEntries) {
                this.putAssetPropertyValueEntries = putAssetPropertyValueEntries;
                return this;
            }

            public Builder putAssetPropertyValueEntries(List<? extends Object> putAssetPropertyValueEntries) {
                this.putAssetPropertyValueEntries = putAssetPropertyValueEntries;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public IotSiteWiseActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.IotEventsActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IotEventsActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getInputName();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public Object getBatchMode() {
            return null;
        }

        @Nullable
        default public String getMessageId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IotEventsActionProperty> {
            String inputName;
            String roleArn;
            Object batchMode;
            String messageId;

            public Builder inputName(String inputName) {
                this.inputName = inputName;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder batchMode(Boolean batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            public Builder batchMode(IResolvable batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            public Builder messageId(String messageId) {
                this.messageId = messageId;
                return this;
            }

            public IotEventsActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.IotAnalyticsActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IotAnalyticsActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getChannelName();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public Object getBatchMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IotAnalyticsActionProperty> {
            String channelName;
            String roleArn;
            Object batchMode;

            public Builder channelName(String channelName) {
                this.channelName = channelName;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder batchMode(Boolean batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            public Builder batchMode(IResolvable batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            public IotAnalyticsActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.HttpAuthorizationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HttpAuthorizationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSigv4() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HttpAuthorizationProperty> {
            Object sigv4;

            public Builder sigv4(IResolvable sigv4) {
                this.sigv4 = sigv4;
                return this;
            }

            public Builder sigv4(SigV4AuthorizationProperty sigv4) {
                this.sigv4 = sigv4;
                return this;
            }

            public HttpAuthorizationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.HttpActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HttpActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getUrl();

        @Nullable
        default public Object getAuth() {
            return null;
        }

        @Nullable
        default public String getConfirmationUrl() {
            return null;
        }

        @Nullable
        default public Object getHeaders() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HttpActionProperty> {
            String url;
            Object auth;
            String confirmationUrl;
            Object headers;

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public Builder auth(IResolvable auth) {
                this.auth = auth;
                return this;
            }

            public Builder auth(HttpAuthorizationProperty auth) {
                this.auth = auth;
                return this;
            }

            public Builder confirmationUrl(String confirmationUrl) {
                this.confirmationUrl = confirmationUrl;
                return this;
            }

            public Builder headers(IResolvable headers) {
                this.headers = headers;
                return this;
            }

            public Builder headers(List<? extends Object> headers) {
                this.headers = headers;
                return this;
            }

            public HttpActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.HttpActionHeaderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HttpActionHeaderProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HttpActionHeaderProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public HttpActionHeaderProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.FirehoseActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FirehoseActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getDeliveryStreamName();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public Object getBatchMode() {
            return null;
        }

        @Nullable
        default public String getSeparator() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FirehoseActionProperty> {
            String deliveryStreamName;
            String roleArn;
            Object batchMode;
            String separator;

            public Builder deliveryStreamName(String deliveryStreamName) {
                this.deliveryStreamName = deliveryStreamName;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder batchMode(Boolean batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            public Builder batchMode(IResolvable batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            public Builder separator(String separator) {
                this.separator = separator;
                return this;
            }

            public FirehoseActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.ElasticsearchActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticsearchActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getEndpoint();

        @NotNull
        public String getId();

        @NotNull
        public String getIndex();

        @NotNull
        public String getRoleArn();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticsearchActionProperty> {
            String endpoint;
            String id;
            String index;
            String roleArn;
            String type;

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder index(String index) {
                this.index = index;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ElasticsearchActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.DynamoDBv2ActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDBv2ActionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPutItem() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamoDBv2ActionProperty> {
            Object putItem;
            String roleArn;

            public Builder putItem(IResolvable putItem) {
                this.putItem = putItem;
                return this;
            }

            public Builder putItem(PutItemInputProperty putItem) {
                this.putItem = putItem;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public DynamoDBv2ActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.DynamoDBActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDBActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getHashKeyField();

        @NotNull
        public String getHashKeyValue();

        @NotNull
        public String getRoleArn();

        @NotNull
        public String getTableName();

        @Nullable
        default public String getHashKeyType() {
            return null;
        }

        @Nullable
        default public String getPayloadField() {
            return null;
        }

        @Nullable
        default public String getRangeKeyField() {
            return null;
        }

        @Nullable
        default public String getRangeKeyType() {
            return null;
        }

        @Nullable
        default public String getRangeKeyValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamoDBActionProperty> {
            String hashKeyField;
            String hashKeyValue;
            String roleArn;
            String tableName;
            String hashKeyType;
            String payloadField;
            String rangeKeyField;
            String rangeKeyType;
            String rangeKeyValue;

            public Builder hashKeyField(String hashKeyField) {
                this.hashKeyField = hashKeyField;
                return this;
            }

            public Builder hashKeyValue(String hashKeyValue) {
                this.hashKeyValue = hashKeyValue;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder hashKeyType(String hashKeyType) {
                this.hashKeyType = hashKeyType;
                return this;
            }

            public Builder payloadField(String payloadField) {
                this.payloadField = payloadField;
                return this;
            }

            public Builder rangeKeyField(String rangeKeyField) {
                this.rangeKeyField = rangeKeyField;
                return this;
            }

            public Builder rangeKeyType(String rangeKeyType) {
                this.rangeKeyType = rangeKeyType;
                return this;
            }

            public Builder rangeKeyValue(String rangeKeyValue) {
                this.rangeKeyValue = rangeKeyValue;
                return this;
            }

            public DynamoDBActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.CloudwatchMetricActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudwatchMetricActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getMetricName();

        @NotNull
        public String getMetricNamespace();

        @NotNull
        public String getMetricUnit();

        @NotNull
        public String getMetricValue();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public String getMetricTimestamp() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudwatchMetricActionProperty> {
            String metricName;
            String metricNamespace;
            String metricUnit;
            String metricValue;
            String roleArn;
            String metricTimestamp;

            public Builder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            public Builder metricNamespace(String metricNamespace) {
                this.metricNamespace = metricNamespace;
                return this;
            }

            public Builder metricUnit(String metricUnit) {
                this.metricUnit = metricUnit;
                return this;
            }

            public Builder metricValue(String metricValue) {
                this.metricValue = metricValue;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder metricTimestamp(String metricTimestamp) {
                this.metricTimestamp = metricTimestamp;
                return this;
            }

            public CloudwatchMetricActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.CloudwatchLogsActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudwatchLogsActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getLogGroupName();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public Object getBatchMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudwatchLogsActionProperty> {
            String logGroupName;
            String roleArn;
            Object batchMode;

            public Builder logGroupName(String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder batchMode(Boolean batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            public Builder batchMode(IResolvable batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            public CloudwatchLogsActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.CloudwatchAlarmActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudwatchAlarmActionProperty
    extends JsiiSerializable {
        @NotNull
        public String getAlarmName();

        @NotNull
        public String getRoleArn();

        @NotNull
        public String getStateReason();

        @NotNull
        public String getStateValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudwatchAlarmActionProperty> {
            String alarmName;
            String roleArn;
            String stateReason;
            String stateValue;

            public Builder alarmName(String alarmName) {
                this.alarmName = alarmName;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder stateReason(String stateReason) {
                this.stateReason = stateReason;
                return this;
            }

            public Builder stateValue(String stateValue) {
                this.stateValue = stateValue;
                return this;
            }

            public CloudwatchAlarmActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.AssetPropertyVariantProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AssetPropertyVariantProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBooleanValue() {
            return null;
        }

        @Nullable
        default public String getDoubleValue() {
            return null;
        }

        @Nullable
        default public String getIntegerValue() {
            return null;
        }

        @Nullable
        default public String getStringValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AssetPropertyVariantProperty> {
            String booleanValue;
            String doubleValue;
            String integerValue;
            String stringValue;

            public Builder booleanValue(String booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            public Builder doubleValue(String doubleValue) {
                this.doubleValue = doubleValue;
                return this;
            }

            public Builder integerValue(String integerValue) {
                this.integerValue = integerValue;
                return this;
            }

            public Builder stringValue(String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            public AssetPropertyVariantProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.AssetPropertyValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AssetPropertyValueProperty
    extends JsiiSerializable {
        @NotNull
        public Object getTimestamp();

        @NotNull
        public Object getValue();

        @Nullable
        default public String getQuality() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AssetPropertyValueProperty> {
            Object timestamp;
            Object value;
            String quality;

            public Builder timestamp(IResolvable timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public Builder timestamp(AssetPropertyTimestampProperty timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public Builder value(IResolvable value) {
                this.value = value;
                return this;
            }

            public Builder value(AssetPropertyVariantProperty value) {
                this.value = value;
                return this;
            }

            public Builder quality(String quality) {
                this.quality = quality;
                return this;
            }

            public AssetPropertyValueProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.AssetPropertyTimestampProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AssetPropertyTimestampProperty
    extends JsiiSerializable {
        @NotNull
        public String getTimeInSeconds();

        @Nullable
        default public String getOffsetInNanos() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AssetPropertyTimestampProperty> {
            String timeInSeconds;
            String offsetInNanos;

            public Builder timeInSeconds(String timeInSeconds) {
                this.timeInSeconds = timeInSeconds;
                return this;
            }

            public Builder offsetInNanos(String offsetInNanos) {
                this.offsetInNanos = offsetInNanos;
                return this;
            }

            public AssetPropertyTimestampProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iot.CfnTopicRule.ActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ActionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCloudwatchAlarm() {
            return null;
        }

        @Nullable
        default public Object getCloudwatchLogs() {
            return null;
        }

        @Nullable
        default public Object getCloudwatchMetric() {
            return null;
        }

        @Nullable
        default public Object getDynamoDb() {
            return null;
        }

        @Nullable
        default public Object getDynamoDBv2() {
            return null;
        }

        @Nullable
        default public Object getElasticsearch() {
            return null;
        }

        @Nullable
        default public Object getFirehose() {
            return null;
        }

        @Nullable
        default public Object getHttp() {
            return null;
        }

        @Nullable
        default public Object getIotAnalytics() {
            return null;
        }

        @Nullable
        default public Object getIotEvents() {
            return null;
        }

        @Nullable
        default public Object getIotSiteWise() {
            return null;
        }

        @Nullable
        default public Object getKafka() {
            return null;
        }

        @Nullable
        default public Object getKinesis() {
            return null;
        }

        @Nullable
        default public Object getLambda() {
            return null;
        }

        @Nullable
        default public Object getLocation() {
            return null;
        }

        @Nullable
        default public Object getOpenSearch() {
            return null;
        }

        @Nullable
        default public Object getRepublish() {
            return null;
        }

        @Nullable
        default public Object getS3() {
            return null;
        }

        @Nullable
        default public Object getSns() {
            return null;
        }

        @Nullable
        default public Object getSqs() {
            return null;
        }

        @Nullable
        default public Object getStepFunctions() {
            return null;
        }

        @Nullable
        default public Object getTimestream() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ActionProperty> {
            Object cloudwatchAlarm;
            Object cloudwatchLogs;
            Object cloudwatchMetric;
            Object dynamoDb;
            Object dynamoDBv2;
            Object elasticsearch;
            Object firehose;
            Object http;
            Object iotAnalytics;
            Object iotEvents;
            Object iotSiteWise;
            Object kafka;
            Object kinesis;
            Object lambda;
            Object location;
            Object openSearch;
            Object republish;
            Object s3;
            Object sns;
            Object sqs;
            Object stepFunctions;
            Object timestream;

            public Builder cloudwatchAlarm(IResolvable cloudwatchAlarm) {
                this.cloudwatchAlarm = cloudwatchAlarm;
                return this;
            }

            public Builder cloudwatchAlarm(CloudwatchAlarmActionProperty cloudwatchAlarm) {
                this.cloudwatchAlarm = cloudwatchAlarm;
                return this;
            }

            public Builder cloudwatchLogs(IResolvable cloudwatchLogs) {
                this.cloudwatchLogs = cloudwatchLogs;
                return this;
            }

            public Builder cloudwatchLogs(CloudwatchLogsActionProperty cloudwatchLogs) {
                this.cloudwatchLogs = cloudwatchLogs;
                return this;
            }

            public Builder cloudwatchMetric(IResolvable cloudwatchMetric) {
                this.cloudwatchMetric = cloudwatchMetric;
                return this;
            }

            public Builder cloudwatchMetric(CloudwatchMetricActionProperty cloudwatchMetric) {
                this.cloudwatchMetric = cloudwatchMetric;
                return this;
            }

            public Builder dynamoDb(IResolvable dynamoDb) {
                this.dynamoDb = dynamoDb;
                return this;
            }

            public Builder dynamoDb(DynamoDBActionProperty dynamoDb) {
                this.dynamoDb = dynamoDb;
                return this;
            }

            public Builder dynamoDBv2(IResolvable dynamoDBv2) {
                this.dynamoDBv2 = dynamoDBv2;
                return this;
            }

            public Builder dynamoDBv2(DynamoDBv2ActionProperty dynamoDBv2) {
                this.dynamoDBv2 = dynamoDBv2;
                return this;
            }

            public Builder elasticsearch(IResolvable elasticsearch) {
                this.elasticsearch = elasticsearch;
                return this;
            }

            public Builder elasticsearch(ElasticsearchActionProperty elasticsearch) {
                this.elasticsearch = elasticsearch;
                return this;
            }

            public Builder firehose(IResolvable firehose) {
                this.firehose = firehose;
                return this;
            }

            public Builder firehose(FirehoseActionProperty firehose) {
                this.firehose = firehose;
                return this;
            }

            public Builder http(IResolvable http) {
                this.http = http;
                return this;
            }

            public Builder http(HttpActionProperty http) {
                this.http = http;
                return this;
            }

            public Builder iotAnalytics(IResolvable iotAnalytics) {
                this.iotAnalytics = iotAnalytics;
                return this;
            }

            public Builder iotAnalytics(IotAnalyticsActionProperty iotAnalytics) {
                this.iotAnalytics = iotAnalytics;
                return this;
            }

            public Builder iotEvents(IResolvable iotEvents) {
                this.iotEvents = iotEvents;
                return this;
            }

            public Builder iotEvents(IotEventsActionProperty iotEvents) {
                this.iotEvents = iotEvents;
                return this;
            }

            public Builder iotSiteWise(IResolvable iotSiteWise) {
                this.iotSiteWise = iotSiteWise;
                return this;
            }

            public Builder iotSiteWise(IotSiteWiseActionProperty iotSiteWise) {
                this.iotSiteWise = iotSiteWise;
                return this;
            }

            public Builder kafka(IResolvable kafka) {
                this.kafka = kafka;
                return this;
            }

            public Builder kafka(KafkaActionProperty kafka) {
                this.kafka = kafka;
                return this;
            }

            public Builder kinesis(IResolvable kinesis) {
                this.kinesis = kinesis;
                return this;
            }

            public Builder kinesis(KinesisActionProperty kinesis) {
                this.kinesis = kinesis;
                return this;
            }

            public Builder lambda(IResolvable lambda) {
                this.lambda = lambda;
                return this;
            }

            public Builder lambda(LambdaActionProperty lambda) {
                this.lambda = lambda;
                return this;
            }

            public Builder location(IResolvable location) {
                this.location = location;
                return this;
            }

            public Builder location(LocationActionProperty location) {
                this.location = location;
                return this;
            }

            public Builder openSearch(IResolvable openSearch) {
                this.openSearch = openSearch;
                return this;
            }

            public Builder openSearch(OpenSearchActionProperty openSearch) {
                this.openSearch = openSearch;
                return this;
            }

            public Builder republish(IResolvable republish) {
                this.republish = republish;
                return this;
            }

            public Builder republish(RepublishActionProperty republish) {
                this.republish = republish;
                return this;
            }

            public Builder s3(IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            public Builder s3(S3ActionProperty s3) {
                this.s3 = s3;
                return this;
            }

            public Builder sns(IResolvable sns) {
                this.sns = sns;
                return this;
            }

            public Builder sns(SnsActionProperty sns) {
                this.sns = sns;
                return this;
            }

            public Builder sqs(IResolvable sqs) {
                this.sqs = sqs;
                return this;
            }

            public Builder sqs(SqsActionProperty sqs) {
                this.sqs = sqs;
                return this;
            }

            public Builder stepFunctions(IResolvable stepFunctions) {
                this.stepFunctions = stepFunctions;
                return this;
            }

            public Builder stepFunctions(StepFunctionsActionProperty stepFunctions) {
                this.stepFunctions = stepFunctions;
                return this;
            }

            public Builder timestream(IResolvable timestream) {
                this.timestream = timestream;
                return this;
            }

            public Builder timestream(TimestreamActionProperty timestream) {
                this.timestream = timestream;
                return this;
            }

            public ActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

