/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kendra;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.kendra.CfnDataSource;
import software.amazon.awscdk.services.kendra.CfnDataSourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource")
public class CfnDataSource
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDataSource.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDataSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDataSource(@NotNull Construct scope, @NotNull String id, @NotNull CfnDataSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getIndexId() {
        return (String)Kernel.get((Object)this, (String)"indexId", (NativeType)NativeType.forClass(String.class));
    }

    public void setIndexId(@NotNull String value) {
        Kernel.set((Object)this, (String)"indexId", (Object)Objects.requireNonNull(value, "indexId is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@NotNull String value) {
        Kernel.set((Object)this, (String)"type", (Object)Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public Object getCustomDocumentEnrichmentConfiguration() {
        return Kernel.get((Object)this, (String)"customDocumentEnrichmentConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCustomDocumentEnrichmentConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"customDocumentEnrichmentConfiguration", (Object)value);
    }

    public void setCustomDocumentEnrichmentConfiguration(@Nullable CustomDocumentEnrichmentConfigurationProperty value) {
        Kernel.set((Object)this, (String)"customDocumentEnrichmentConfiguration", (Object)value);
    }

    @Nullable
    public Object getDataSourceConfiguration() {
        return Kernel.get((Object)this, (String)"dataSourceConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDataSourceConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"dataSourceConfiguration", (Object)value);
    }

    public void setDataSourceConfiguration(@Nullable DataSourceConfigurationProperty value) {
        Kernel.set((Object)this, (String)"dataSourceConfiguration", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"roleArn", (Object)value);
    }

    @Nullable
    public String getSchedule() {
        return (String)Kernel.get((Object)this, (String)"schedule", (NativeType)NativeType.forClass(String.class));
    }

    public void setSchedule(@Nullable String value) {
        Kernel.set((Object)this, (String)"schedule", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDataSource> {
        private final Construct scope;
        private final String id;
        private final CfnDataSourceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDataSourceProps.Builder();
        }

        public Builder indexId(String indexId) {
            this.props.indexId(indexId);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder customDocumentEnrichmentConfiguration(IResolvable customDocumentEnrichmentConfiguration) {
            this.props.customDocumentEnrichmentConfiguration(customDocumentEnrichmentConfiguration);
            return this;
        }

        public Builder customDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfigurationProperty customDocumentEnrichmentConfiguration) {
            this.props.customDocumentEnrichmentConfiguration(customDocumentEnrichmentConfiguration);
            return this;
        }

        public Builder dataSourceConfiguration(IResolvable dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }

        public Builder dataSourceConfiguration(DataSourceConfigurationProperty dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder schedule(String schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnDataSource build() {
            return new CfnDataSource(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.WorkDocsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WorkDocsConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getOrganizationId();

        @Nullable
        default public Object getCrawlComments() {
            return null;
        }

        @Nullable
        default public List<String> getExclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getUseChangeLog() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WorkDocsConfigurationProperty> {
            String organizationId;
            Object crawlComments;
            List<String> exclusionPatterns;
            Object fieldMappings;
            List<String> inclusionPatterns;
            Object useChangeLog;

            public Builder organizationId(String organizationId) {
                this.organizationId = organizationId;
                return this;
            }

            public Builder crawlComments(Boolean crawlComments) {
                this.crawlComments = crawlComments;
                return this;
            }

            public Builder crawlComments(IResolvable crawlComments) {
                this.crawlComments = crawlComments;
                return this;
            }

            public Builder exclusionPatterns(List<String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder inclusionPatterns(List<String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public Builder useChangeLog(Boolean useChangeLog) {
                this.useChangeLog = useChangeLog;
                return this;
            }

            public Builder useChangeLog(IResolvable useChangeLog) {
                this.useChangeLog = useChangeLog;
                return this;
            }

            public WorkDocsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerUrlsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WebCrawlerUrlsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSeedUrlConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSiteMapsConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WebCrawlerUrlsProperty> {
            Object seedUrlConfiguration;
            Object siteMapsConfiguration;

            public Builder seedUrlConfiguration(IResolvable seedUrlConfiguration) {
                this.seedUrlConfiguration = seedUrlConfiguration;
                return this;
            }

            public Builder seedUrlConfiguration(WebCrawlerSeedUrlConfigurationProperty seedUrlConfiguration) {
                this.seedUrlConfiguration = seedUrlConfiguration;
                return this;
            }

            public Builder siteMapsConfiguration(IResolvable siteMapsConfiguration) {
                this.siteMapsConfiguration = siteMapsConfiguration;
                return this;
            }

            public Builder siteMapsConfiguration(WebCrawlerSiteMapsConfigurationProperty siteMapsConfiguration) {
                this.siteMapsConfiguration = siteMapsConfiguration;
                return this;
            }

            public WebCrawlerUrlsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerSiteMapsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WebCrawlerSiteMapsConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSiteMaps();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WebCrawlerSiteMapsConfigurationProperty> {
            List<String> siteMaps;

            public Builder siteMaps(List<String> siteMaps) {
                this.siteMaps = siteMaps;
                return this;
            }

            public WebCrawlerSiteMapsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerSeedUrlConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WebCrawlerSeedUrlConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSeedUrls();

        @Nullable
        default public String getWebCrawlerMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WebCrawlerSeedUrlConfigurationProperty> {
            List<String> seedUrls;
            String webCrawlerMode;

            public Builder seedUrls(List<String> seedUrls) {
                this.seedUrls = seedUrls;
                return this;
            }

            public Builder webCrawlerMode(String webCrawlerMode) {
                this.webCrawlerMode = webCrawlerMode;
                return this;
            }

            public WebCrawlerSeedUrlConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WebCrawlerConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getUrls();

        @Nullable
        default public Object getAuthenticationConfiguration() {
            return null;
        }

        @Nullable
        default public Number getCrawlDepth() {
            return null;
        }

        @Nullable
        default public Number getMaxContentSizePerPageInMegaBytes() {
            return null;
        }

        @Nullable
        default public Number getMaxLinksPerPage() {
            return null;
        }

        @Nullable
        default public Number getMaxUrlsPerMinuteCrawlRate() {
            return null;
        }

        @Nullable
        default public Object getProxyConfiguration() {
            return null;
        }

        @Nullable
        default public List<String> getUrlExclusionPatterns() {
            return null;
        }

        @Nullable
        default public List<String> getUrlInclusionPatterns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WebCrawlerConfigurationProperty> {
            Object urls;
            Object authenticationConfiguration;
            Number crawlDepth;
            Number maxContentSizePerPageInMegaBytes;
            Number maxLinksPerPage;
            Number maxUrlsPerMinuteCrawlRate;
            Object proxyConfiguration;
            List<String> urlExclusionPatterns;
            List<String> urlInclusionPatterns;

            public Builder urls(IResolvable urls) {
                this.urls = urls;
                return this;
            }

            public Builder urls(WebCrawlerUrlsProperty urls) {
                this.urls = urls;
                return this;
            }

            public Builder authenticationConfiguration(IResolvable authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            public Builder authenticationConfiguration(WebCrawlerAuthenticationConfigurationProperty authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            public Builder crawlDepth(Number crawlDepth) {
                this.crawlDepth = crawlDepth;
                return this;
            }

            public Builder maxContentSizePerPageInMegaBytes(Number maxContentSizePerPageInMegaBytes) {
                this.maxContentSizePerPageInMegaBytes = maxContentSizePerPageInMegaBytes;
                return this;
            }

            public Builder maxLinksPerPage(Number maxLinksPerPage) {
                this.maxLinksPerPage = maxLinksPerPage;
                return this;
            }

            public Builder maxUrlsPerMinuteCrawlRate(Number maxUrlsPerMinuteCrawlRate) {
                this.maxUrlsPerMinuteCrawlRate = maxUrlsPerMinuteCrawlRate;
                return this;
            }

            public Builder proxyConfiguration(IResolvable proxyConfiguration) {
                this.proxyConfiguration = proxyConfiguration;
                return this;
            }

            public Builder proxyConfiguration(ProxyConfigurationProperty proxyConfiguration) {
                this.proxyConfiguration = proxyConfiguration;
                return this;
            }

            public Builder urlExclusionPatterns(List<String> urlExclusionPatterns) {
                this.urlExclusionPatterns = urlExclusionPatterns;
                return this;
            }

            public Builder urlInclusionPatterns(List<String> urlInclusionPatterns) {
                this.urlInclusionPatterns = urlInclusionPatterns;
                return this;
            }

            public WebCrawlerConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerBasicAuthenticationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WebCrawlerBasicAuthenticationProperty
    extends JsiiSerializable {
        @NotNull
        public String getCredentials();

        @NotNull
        public String getHost();

        @NotNull
        public Number getPort();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WebCrawlerBasicAuthenticationProperty> {
            String credentials;
            String host;
            Number port;

            public Builder credentials(String credentials) {
                this.credentials = credentials;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public WebCrawlerBasicAuthenticationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerAuthenticationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WebCrawlerAuthenticationConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBasicAuthentication() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WebCrawlerAuthenticationConfigurationProperty> {
            Object basicAuthentication;

            public Builder basicAuthentication(IResolvable basicAuthentication) {
                this.basicAuthentication = basicAuthentication;
                return this;
            }

            public Builder basicAuthentication(List<? extends Object> basicAuthentication) {
                this.basicAuthentication = basicAuthentication;
                return this;
            }

            public WebCrawlerAuthenticationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.SqlConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SqlConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getQueryIdentifiersEnclosingOption() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SqlConfigurationProperty> {
            String queryIdentifiersEnclosingOption;

            public Builder queryIdentifiersEnclosingOption(String queryIdentifiersEnclosingOption) {
                this.queryIdentifiersEnclosingOption = queryIdentifiersEnclosingOption;
                return this;
            }

            public SqlConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.SharePointConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SharePointConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSecretArn();

        @NotNull
        public String getSharePointVersion();

        @NotNull
        public List<String> getUrls();

        @Nullable
        default public Object getCrawlAttachments() {
            return null;
        }

        @Nullable
        default public Object getDisableLocalGroups() {
            return null;
        }

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public List<String> getExclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getSslCertificateS3Path() {
            return null;
        }

        @Nullable
        default public Object getUseChangeLog() {
            return null;
        }

        @Nullable
        default public Object getVpcConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SharePointConfigurationProperty> {
            String secretArn;
            String sharePointVersion;
            List<String> urls;
            Object crawlAttachments;
            Object disableLocalGroups;
            String documentTitleFieldName;
            List<String> exclusionPatterns;
            Object fieldMappings;
            List<String> inclusionPatterns;
            Object sslCertificateS3Path;
            Object useChangeLog;
            Object vpcConfiguration;

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder sharePointVersion(String sharePointVersion) {
                this.sharePointVersion = sharePointVersion;
                return this;
            }

            public Builder urls(List<String> urls) {
                this.urls = urls;
                return this;
            }

            public Builder crawlAttachments(Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder crawlAttachments(IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder disableLocalGroups(Boolean disableLocalGroups) {
                this.disableLocalGroups = disableLocalGroups;
                return this;
            }

            public Builder disableLocalGroups(IResolvable disableLocalGroups) {
                this.disableLocalGroups = disableLocalGroups;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder exclusionPatterns(List<String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder inclusionPatterns(List<String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public Builder sslCertificateS3Path(IResolvable sslCertificateS3Path) {
                this.sslCertificateS3Path = sslCertificateS3Path;
                return this;
            }

            public Builder sslCertificateS3Path(S3PathProperty sslCertificateS3Path) {
                this.sslCertificateS3Path = sslCertificateS3Path;
                return this;
            }

            public Builder useChangeLog(Boolean useChangeLog) {
                this.useChangeLog = useChangeLog;
                return this;
            }

            public Builder useChangeLog(IResolvable useChangeLog) {
                this.useChangeLog = useChangeLog;
                return this;
            }

            public Builder vpcConfiguration(IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public Builder vpcConfiguration(DataSourceVpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public SharePointConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ServiceNowServiceCatalogConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceNowServiceCatalogConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @Nullable
        default public Object getCrawlAttachments() {
            return null;
        }

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public List<String> getExcludeAttachmentFilePatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public List<String> getIncludeAttachmentFilePatterns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceNowServiceCatalogConfigurationProperty> {
            String documentDataFieldName;
            Object crawlAttachments;
            String documentTitleFieldName;
            List<String> excludeAttachmentFilePatterns;
            Object fieldMappings;
            List<String> includeAttachmentFilePatterns;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder crawlAttachments(Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder crawlAttachments(IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder excludeAttachmentFilePatterns(List<String> excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder includeAttachmentFilePatterns(List<String> includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            public ServiceNowServiceCatalogConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceNowKnowledgeArticleConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @Nullable
        default public Object getCrawlAttachments() {
            return null;
        }

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public List<String> getExcludeAttachmentFilePatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public String getFilterQuery() {
            return null;
        }

        @Nullable
        default public List<String> getIncludeAttachmentFilePatterns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceNowKnowledgeArticleConfigurationProperty> {
            String documentDataFieldName;
            Object crawlAttachments;
            String documentTitleFieldName;
            List<String> excludeAttachmentFilePatterns;
            Object fieldMappings;
            String filterQuery;
            List<String> includeAttachmentFilePatterns;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder crawlAttachments(Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder crawlAttachments(IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder excludeAttachmentFilePatterns(List<String> excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder filterQuery(String filterQuery) {
                this.filterQuery = filterQuery;
                return this;
            }

            public Builder includeAttachmentFilePatterns(List<String> includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            public ServiceNowKnowledgeArticleConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ServiceNowConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceNowConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getHostUrl();

        @NotNull
        public String getSecretArn();

        @NotNull
        public String getServiceNowBuildVersion();

        @Nullable
        default public String getAuthenticationType() {
            return null;
        }

        @Nullable
        default public Object getKnowledgeArticleConfiguration() {
            return null;
        }

        @Nullable
        default public Object getServiceCatalogConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceNowConfigurationProperty> {
            String hostUrl;
            String secretArn;
            String serviceNowBuildVersion;
            String authenticationType;
            Object knowledgeArticleConfiguration;
            Object serviceCatalogConfiguration;

            public Builder hostUrl(String hostUrl) {
                this.hostUrl = hostUrl;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder serviceNowBuildVersion(String serviceNowBuildVersion) {
                this.serviceNowBuildVersion = serviceNowBuildVersion;
                return this;
            }

            public Builder authenticationType(String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            public Builder knowledgeArticleConfiguration(IResolvable knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            public Builder knowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfigurationProperty knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            public Builder serviceCatalogConfiguration(IResolvable serviceCatalogConfiguration) {
                this.serviceCatalogConfiguration = serviceCatalogConfiguration;
                return this;
            }

            public Builder serviceCatalogConfiguration(ServiceNowServiceCatalogConfigurationProperty serviceCatalogConfiguration) {
                this.serviceCatalogConfiguration = serviceCatalogConfiguration;
                return this;
            }

            public ServiceNowConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceStandardObjectConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceStandardObjectConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @NotNull
        public String getName();

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceStandardObjectConfigurationProperty> {
            String documentDataFieldName;
            String name;
            String documentTitleFieldName;
            Object fieldMappings;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public SalesforceStandardObjectConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceStandardObjectAttachmentConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceStandardObjectAttachmentConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceStandardObjectAttachmentConfigurationProperty> {
            String documentTitleFieldName;
            Object fieldMappings;

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public SalesforceStandardObjectAttachmentConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceStandardKnowledgeArticleTypeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceStandardKnowledgeArticleTypeConfigurationProperty> {
            String documentDataFieldName;
            String documentTitleFieldName;
            Object fieldMappings;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public SalesforceStandardKnowledgeArticleTypeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceKnowledgeArticleConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getIncludedStates();

        @Nullable
        default public Object getCustomKnowledgeArticleTypeConfigurations() {
            return null;
        }

        @Nullable
        default public Object getStandardKnowledgeArticleTypeConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceKnowledgeArticleConfigurationProperty> {
            List<String> includedStates;
            Object customKnowledgeArticleTypeConfigurations;
            Object standardKnowledgeArticleTypeConfiguration;

            public Builder includedStates(List<String> includedStates) {
                this.includedStates = includedStates;
                return this;
            }

            public Builder customKnowledgeArticleTypeConfigurations(IResolvable customKnowledgeArticleTypeConfigurations) {
                this.customKnowledgeArticleTypeConfigurations = customKnowledgeArticleTypeConfigurations;
                return this;
            }

            public Builder customKnowledgeArticleTypeConfigurations(List<? extends Object> customKnowledgeArticleTypeConfigurations) {
                this.customKnowledgeArticleTypeConfigurations = customKnowledgeArticleTypeConfigurations;
                return this;
            }

            public Builder standardKnowledgeArticleTypeConfiguration(IResolvable standardKnowledgeArticleTypeConfiguration) {
                this.standardKnowledgeArticleTypeConfiguration = standardKnowledgeArticleTypeConfiguration;
                return this;
            }

            public Builder standardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfigurationProperty standardKnowledgeArticleTypeConfiguration) {
                this.standardKnowledgeArticleTypeConfiguration = standardKnowledgeArticleTypeConfiguration;
                return this;
            }

            public SalesforceKnowledgeArticleConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceCustomKnowledgeArticleTypeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @NotNull
        public String getName();

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceCustomKnowledgeArticleTypeConfigurationProperty> {
            String documentDataFieldName;
            String name;
            String documentTitleFieldName;
            Object fieldMappings;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public SalesforceCustomKnowledgeArticleTypeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSecretArn();

        @NotNull
        public String getServerUrl();

        @Nullable
        default public Object getChatterFeedConfiguration() {
            return null;
        }

        @Nullable
        default public Object getCrawlAttachments() {
            return null;
        }

        @Nullable
        default public List<String> getExcludeAttachmentFilePatterns() {
            return null;
        }

        @Nullable
        default public List<String> getIncludeAttachmentFilePatterns() {
            return null;
        }

        @Nullable
        default public Object getKnowledgeArticleConfiguration() {
            return null;
        }

        @Nullable
        default public Object getStandardObjectAttachmentConfiguration() {
            return null;
        }

        @Nullable
        default public Object getStandardObjectConfigurations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceConfigurationProperty> {
            String secretArn;
            String serverUrl;
            Object chatterFeedConfiguration;
            Object crawlAttachments;
            List<String> excludeAttachmentFilePatterns;
            List<String> includeAttachmentFilePatterns;
            Object knowledgeArticleConfiguration;
            Object standardObjectAttachmentConfiguration;
            Object standardObjectConfigurations;

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder serverUrl(String serverUrl) {
                this.serverUrl = serverUrl;
                return this;
            }

            public Builder chatterFeedConfiguration(IResolvable chatterFeedConfiguration) {
                this.chatterFeedConfiguration = chatterFeedConfiguration;
                return this;
            }

            public Builder chatterFeedConfiguration(SalesforceChatterFeedConfigurationProperty chatterFeedConfiguration) {
                this.chatterFeedConfiguration = chatterFeedConfiguration;
                return this;
            }

            public Builder crawlAttachments(Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder crawlAttachments(IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder excludeAttachmentFilePatterns(List<String> excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            public Builder includeAttachmentFilePatterns(List<String> includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            public Builder knowledgeArticleConfiguration(IResolvable knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            public Builder knowledgeArticleConfiguration(SalesforceKnowledgeArticleConfigurationProperty knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            public Builder standardObjectAttachmentConfiguration(IResolvable standardObjectAttachmentConfiguration) {
                this.standardObjectAttachmentConfiguration = standardObjectAttachmentConfiguration;
                return this;
            }

            public Builder standardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfigurationProperty standardObjectAttachmentConfiguration) {
                this.standardObjectAttachmentConfiguration = standardObjectAttachmentConfiguration;
                return this;
            }

            public Builder standardObjectConfigurations(IResolvable standardObjectConfigurations) {
                this.standardObjectConfigurations = standardObjectConfigurations;
                return this;
            }

            public Builder standardObjectConfigurations(List<? extends Object> standardObjectConfigurations) {
                this.standardObjectConfigurations = standardObjectConfigurations;
                return this;
            }

            public SalesforceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceChatterFeedConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceChatterFeedConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public List<String> getIncludeFilterTypes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceChatterFeedConfigurationProperty> {
            String documentDataFieldName;
            String documentTitleFieldName;
            Object fieldMappings;
            List<String> includeFilterTypes;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder includeFilterTypes(List<String> includeFilterTypes) {
                this.includeFilterTypes = includeFilterTypes;
                return this;
            }

            public SalesforceChatterFeedConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.S3PathProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3PathProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3PathProperty> {
            String bucket;
            String key;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public S3PathProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.S3DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3DataSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        @Nullable
        default public Object getAccessControlListConfiguration() {
            return null;
        }

        @Nullable
        default public Object getDocumentsMetadataConfiguration() {
            return null;
        }

        @Nullable
        default public List<String> getExclusionPatterns() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPatterns() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPrefixes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3DataSourceConfigurationProperty> {
            String bucketName;
            Object accessControlListConfiguration;
            Object documentsMetadataConfiguration;
            List<String> exclusionPatterns;
            List<String> inclusionPatterns;
            List<String> inclusionPrefixes;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder accessControlListConfiguration(IResolvable accessControlListConfiguration) {
                this.accessControlListConfiguration = accessControlListConfiguration;
                return this;
            }

            public Builder accessControlListConfiguration(AccessControlListConfigurationProperty accessControlListConfiguration) {
                this.accessControlListConfiguration = accessControlListConfiguration;
                return this;
            }

            public Builder documentsMetadataConfiguration(IResolvable documentsMetadataConfiguration) {
                this.documentsMetadataConfiguration = documentsMetadataConfiguration;
                return this;
            }

            public Builder documentsMetadataConfiguration(DocumentsMetadataConfigurationProperty documentsMetadataConfiguration) {
                this.documentsMetadataConfiguration = documentsMetadataConfiguration;
                return this;
            }

            public Builder exclusionPatterns(List<String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder inclusionPatterns(List<String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public Builder inclusionPrefixes(List<String> inclusionPrefixes) {
                this.inclusionPrefixes = inclusionPrefixes;
                return this;
            }

            public S3DataSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ProxyConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProxyConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getHost();

        @NotNull
        public Number getPort();

        @Nullable
        default public String getCredentials() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProxyConfigurationProperty> {
            String host;
            Number port;
            String credentials;

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder credentials(String credentials) {
                this.credentials = credentials;
                return this;
            }

            public ProxyConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.OneDriveUsersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OneDriveUsersProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getOneDriveUserList() {
            return null;
        }

        @Nullable
        default public Object getOneDriveUserS3Path() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OneDriveUsersProperty> {
            List<String> oneDriveUserList;
            Object oneDriveUserS3Path;

            public Builder oneDriveUserList(List<String> oneDriveUserList) {
                this.oneDriveUserList = oneDriveUserList;
                return this;
            }

            public Builder oneDriveUserS3Path(IResolvable oneDriveUserS3Path) {
                this.oneDriveUserS3Path = oneDriveUserS3Path;
                return this;
            }

            public Builder oneDriveUserS3Path(S3PathProperty oneDriveUserS3Path) {
                this.oneDriveUserS3Path = oneDriveUserS3Path;
                return this;
            }

            public OneDriveUsersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.OneDriveConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OneDriveConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getOneDriveUsers();

        @NotNull
        public String getSecretArn();

        @NotNull
        public String getTenantDomain();

        @Nullable
        default public Object getDisableLocalGroups() {
            return null;
        }

        @Nullable
        default public List<String> getExclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPatterns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OneDriveConfigurationProperty> {
            Object oneDriveUsers;
            String secretArn;
            String tenantDomain;
            Object disableLocalGroups;
            List<String> exclusionPatterns;
            Object fieldMappings;
            List<String> inclusionPatterns;

            public Builder oneDriveUsers(IResolvable oneDriveUsers) {
                this.oneDriveUsers = oneDriveUsers;
                return this;
            }

            public Builder oneDriveUsers(OneDriveUsersProperty oneDriveUsers) {
                this.oneDriveUsers = oneDriveUsers;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder tenantDomain(String tenantDomain) {
                this.tenantDomain = tenantDomain;
                return this;
            }

            public Builder disableLocalGroups(Boolean disableLocalGroups) {
                this.disableLocalGroups = disableLocalGroups;
                return this;
            }

            public Builder disableLocalGroups(IResolvable disableLocalGroups) {
                this.disableLocalGroups = disableLocalGroups;
                return this;
            }

            public Builder exclusionPatterns(List<String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder inclusionPatterns(List<String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public OneDriveConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.InlineCustomDocumentEnrichmentConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InlineCustomDocumentEnrichmentConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCondition() {
            return null;
        }

        @Nullable
        default public Object getDocumentContentDeletion() {
            return null;
        }

        @Nullable
        default public Object getTarget() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InlineCustomDocumentEnrichmentConfigurationProperty> {
            Object condition;
            Object documentContentDeletion;
            Object target;

            public Builder condition(IResolvable condition) {
                this.condition = condition;
                return this;
            }

            public Builder condition(DocumentAttributeConditionProperty condition) {
                this.condition = condition;
                return this;
            }

            public Builder documentContentDeletion(Boolean documentContentDeletion) {
                this.documentContentDeletion = documentContentDeletion;
                return this;
            }

            public Builder documentContentDeletion(IResolvable documentContentDeletion) {
                this.documentContentDeletion = documentContentDeletion;
                return this;
            }

            public Builder target(IResolvable target) {
                this.target = target;
                return this;
            }

            public Builder target(DocumentAttributeTargetProperty target) {
                this.target = target;
                return this;
            }

            public InlineCustomDocumentEnrichmentConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.HookConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HookConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getLambdaArn();

        @NotNull
        public String getS3Bucket();

        @Nullable
        default public Object getInvocationCondition() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HookConfigurationProperty> {
            String lambdaArn;
            String s3Bucket;
            Object invocationCondition;

            public Builder lambdaArn(String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            public Builder s3Bucket(String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            public Builder invocationCondition(IResolvable invocationCondition) {
                this.invocationCondition = invocationCondition;
                return this;
            }

            public Builder invocationCondition(DocumentAttributeConditionProperty invocationCondition) {
                this.invocationCondition = invocationCondition;
                return this;
            }

            public HookConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.GoogleDriveConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GoogleDriveConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSecretArn();

        @Nullable
        default public List<String> getExcludeMimeTypes() {
            return null;
        }

        @Nullable
        default public List<String> getExcludeSharedDrives() {
            return null;
        }

        @Nullable
        default public List<String> getExcludeUserAccounts() {
            return null;
        }

        @Nullable
        default public List<String> getExclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPatterns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GoogleDriveConfigurationProperty> {
            String secretArn;
            List<String> excludeMimeTypes;
            List<String> excludeSharedDrives;
            List<String> excludeUserAccounts;
            List<String> exclusionPatterns;
            Object fieldMappings;
            List<String> inclusionPatterns;

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder excludeMimeTypes(List<String> excludeMimeTypes) {
                this.excludeMimeTypes = excludeMimeTypes;
                return this;
            }

            public Builder excludeSharedDrives(List<String> excludeSharedDrives) {
                this.excludeSharedDrives = excludeSharedDrives;
                return this;
            }

            public Builder excludeUserAccounts(List<String> excludeUserAccounts) {
                this.excludeUserAccounts = excludeUserAccounts;
                return this;
            }

            public Builder exclusionPatterns(List<String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder inclusionPatterns(List<String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public GoogleDriveConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.DocumentsMetadataConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DocumentsMetadataConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getS3Prefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DocumentsMetadataConfigurationProperty> {
            String s3Prefix;

            public Builder s3Prefix(String s3Prefix) {
                this.s3Prefix = s3Prefix;
                return this;
            }

            public DocumentsMetadataConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.DocumentAttributeValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DocumentAttributeValueProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDateValue() {
            return null;
        }

        @Nullable
        default public Number getLongValue() {
            return null;
        }

        @Nullable
        default public List<String> getStringListValue() {
            return null;
        }

        @Nullable
        default public String getStringValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DocumentAttributeValueProperty> {
            String dateValue;
            Number longValue;
            List<String> stringListValue;
            String stringValue;

            public Builder dateValue(String dateValue) {
                this.dateValue = dateValue;
                return this;
            }

            public Builder longValue(Number longValue) {
                this.longValue = longValue;
                return this;
            }

            public Builder stringListValue(List<String> stringListValue) {
                this.stringListValue = stringListValue;
                return this;
            }

            public Builder stringValue(String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            public DocumentAttributeValueProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.DocumentAttributeTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DocumentAttributeTargetProperty
    extends JsiiSerializable {
        @NotNull
        public String getTargetDocumentAttributeKey();

        @Nullable
        default public Object getTargetDocumentAttributeValue() {
            return null;
        }

        @Nullable
        default public Object getTargetDocumentAttributeValueDeletion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DocumentAttributeTargetProperty> {
            String targetDocumentAttributeKey;
            Object targetDocumentAttributeValue;
            Object targetDocumentAttributeValueDeletion;

            public Builder targetDocumentAttributeKey(String targetDocumentAttributeKey) {
                this.targetDocumentAttributeKey = targetDocumentAttributeKey;
                return this;
            }

            public Builder targetDocumentAttributeValue(IResolvable targetDocumentAttributeValue) {
                this.targetDocumentAttributeValue = targetDocumentAttributeValue;
                return this;
            }

            public Builder targetDocumentAttributeValue(DocumentAttributeValueProperty targetDocumentAttributeValue) {
                this.targetDocumentAttributeValue = targetDocumentAttributeValue;
                return this;
            }

            public Builder targetDocumentAttributeValueDeletion(Boolean targetDocumentAttributeValueDeletion) {
                this.targetDocumentAttributeValueDeletion = targetDocumentAttributeValueDeletion;
                return this;
            }

            public Builder targetDocumentAttributeValueDeletion(IResolvable targetDocumentAttributeValueDeletion) {
                this.targetDocumentAttributeValueDeletion = targetDocumentAttributeValueDeletion;
                return this;
            }

            public DocumentAttributeTargetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.DocumentAttributeConditionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DocumentAttributeConditionProperty
    extends JsiiSerializable {
        @NotNull
        public String getConditionDocumentAttributeKey();

        @NotNull
        public String getOperator();

        @Nullable
        default public Object getConditionOnValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DocumentAttributeConditionProperty> {
            String conditionDocumentAttributeKey;
            String operator;
            Object conditionOnValue;

            public Builder conditionDocumentAttributeKey(String conditionDocumentAttributeKey) {
                this.conditionDocumentAttributeKey = conditionDocumentAttributeKey;
                return this;
            }

            public Builder operator(String operator) {
                this.operator = operator;
                return this;
            }

            public Builder conditionOnValue(IResolvable conditionOnValue) {
                this.conditionOnValue = conditionOnValue;
                return this;
            }

            public Builder conditionOnValue(DocumentAttributeValueProperty conditionOnValue) {
                this.conditionOnValue = conditionOnValue;
                return this;
            }

            public DocumentAttributeConditionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.DatabaseConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatabaseConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumnConfiguration();

        @NotNull
        public Object getConnectionConfiguration();

        @NotNull
        public String getDatabaseEngineType();

        @Nullable
        default public Object getAclConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSqlConfiguration() {
            return null;
        }

        @Nullable
        default public Object getVpcConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatabaseConfigurationProperty> {
            Object columnConfiguration;
            Object connectionConfiguration;
            String databaseEngineType;
            Object aclConfiguration;
            Object sqlConfiguration;
            Object vpcConfiguration;

            public Builder columnConfiguration(IResolvable columnConfiguration) {
                this.columnConfiguration = columnConfiguration;
                return this;
            }

            public Builder columnConfiguration(ColumnConfigurationProperty columnConfiguration) {
                this.columnConfiguration = columnConfiguration;
                return this;
            }

            public Builder connectionConfiguration(IResolvable connectionConfiguration) {
                this.connectionConfiguration = connectionConfiguration;
                return this;
            }

            public Builder connectionConfiguration(ConnectionConfigurationProperty connectionConfiguration) {
                this.connectionConfiguration = connectionConfiguration;
                return this;
            }

            public Builder databaseEngineType(String databaseEngineType) {
                this.databaseEngineType = databaseEngineType;
                return this;
            }

            public Builder aclConfiguration(IResolvable aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            public Builder aclConfiguration(AclConfigurationProperty aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            public Builder sqlConfiguration(IResolvable sqlConfiguration) {
                this.sqlConfiguration = sqlConfiguration;
                return this;
            }

            public Builder sqlConfiguration(SqlConfigurationProperty sqlConfiguration) {
                this.sqlConfiguration = sqlConfiguration;
                return this;
            }

            public Builder vpcConfiguration(IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public Builder vpcConfiguration(DataSourceVpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public DatabaseConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.DataSourceVpcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceVpcConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnetIds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceVpcConfigurationProperty> {
            List<String> securityGroupIds;
            List<String> subnetIds;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public DataSourceVpcConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.DataSourceToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceToIndexFieldMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSourceFieldName();

        @NotNull
        public String getIndexFieldName();

        @Nullable
        default public String getDateFieldFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceToIndexFieldMappingProperty> {
            String dataSourceFieldName;
            String indexFieldName;
            String dateFieldFormat;

            public Builder dataSourceFieldName(String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            public Builder indexFieldName(String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            public Builder dateFieldFormat(String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            public DataSourceToIndexFieldMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConfluenceConfiguration() {
            return null;
        }

        @Nullable
        default public Object getDatabaseConfiguration() {
            return null;
        }

        @Nullable
        default public Object getGoogleDriveConfiguration() {
            return null;
        }

        @Nullable
        default public Object getOneDriveConfiguration() {
            return null;
        }

        @Nullable
        default public Object getS3Configuration() {
            return null;
        }

        @Nullable
        default public Object getSalesforceConfiguration() {
            return null;
        }

        @Nullable
        default public Object getServiceNowConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSharePointConfiguration() {
            return null;
        }

        @Nullable
        default public Object getWebCrawlerConfiguration() {
            return null;
        }

        @Nullable
        default public Object getWorkDocsConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceConfigurationProperty> {
            Object confluenceConfiguration;
            Object databaseConfiguration;
            Object googleDriveConfiguration;
            Object oneDriveConfiguration;
            Object s3Configuration;
            Object salesforceConfiguration;
            Object serviceNowConfiguration;
            Object sharePointConfiguration;
            Object webCrawlerConfiguration;
            Object workDocsConfiguration;

            public Builder confluenceConfiguration(IResolvable confluenceConfiguration) {
                this.confluenceConfiguration = confluenceConfiguration;
                return this;
            }

            public Builder confluenceConfiguration(ConfluenceConfigurationProperty confluenceConfiguration) {
                this.confluenceConfiguration = confluenceConfiguration;
                return this;
            }

            public Builder databaseConfiguration(IResolvable databaseConfiguration) {
                this.databaseConfiguration = databaseConfiguration;
                return this;
            }

            public Builder databaseConfiguration(DatabaseConfigurationProperty databaseConfiguration) {
                this.databaseConfiguration = databaseConfiguration;
                return this;
            }

            public Builder googleDriveConfiguration(IResolvable googleDriveConfiguration) {
                this.googleDriveConfiguration = googleDriveConfiguration;
                return this;
            }

            public Builder googleDriveConfiguration(GoogleDriveConfigurationProperty googleDriveConfiguration) {
                this.googleDriveConfiguration = googleDriveConfiguration;
                return this;
            }

            public Builder oneDriveConfiguration(IResolvable oneDriveConfiguration) {
                this.oneDriveConfiguration = oneDriveConfiguration;
                return this;
            }

            public Builder oneDriveConfiguration(OneDriveConfigurationProperty oneDriveConfiguration) {
                this.oneDriveConfiguration = oneDriveConfiguration;
                return this;
            }

            public Builder s3Configuration(IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder s3Configuration(S3DataSourceConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder salesforceConfiguration(IResolvable salesforceConfiguration) {
                this.salesforceConfiguration = salesforceConfiguration;
                return this;
            }

            public Builder salesforceConfiguration(SalesforceConfigurationProperty salesforceConfiguration) {
                this.salesforceConfiguration = salesforceConfiguration;
                return this;
            }

            public Builder serviceNowConfiguration(IResolvable serviceNowConfiguration) {
                this.serviceNowConfiguration = serviceNowConfiguration;
                return this;
            }

            public Builder serviceNowConfiguration(ServiceNowConfigurationProperty serviceNowConfiguration) {
                this.serviceNowConfiguration = serviceNowConfiguration;
                return this;
            }

            public Builder sharePointConfiguration(IResolvable sharePointConfiguration) {
                this.sharePointConfiguration = sharePointConfiguration;
                return this;
            }

            public Builder sharePointConfiguration(SharePointConfigurationProperty sharePointConfiguration) {
                this.sharePointConfiguration = sharePointConfiguration;
                return this;
            }

            public Builder webCrawlerConfiguration(IResolvable webCrawlerConfiguration) {
                this.webCrawlerConfiguration = webCrawlerConfiguration;
                return this;
            }

            public Builder webCrawlerConfiguration(WebCrawlerConfigurationProperty webCrawlerConfiguration) {
                this.webCrawlerConfiguration = webCrawlerConfiguration;
                return this;
            }

            public Builder workDocsConfiguration(IResolvable workDocsConfiguration) {
                this.workDocsConfiguration = workDocsConfiguration;
                return this;
            }

            public Builder workDocsConfiguration(WorkDocsConfigurationProperty workDocsConfiguration) {
                this.workDocsConfiguration = workDocsConfiguration;
                return this;
            }

            public DataSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.CustomDocumentEnrichmentConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomDocumentEnrichmentConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getInlineConfigurations() {
            return null;
        }

        @Nullable
        default public Object getPostExtractionHookConfiguration() {
            return null;
        }

        @Nullable
        default public Object getPreExtractionHookConfiguration() {
            return null;
        }

        @Nullable
        default public String getRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomDocumentEnrichmentConfigurationProperty> {
            Object inlineConfigurations;
            Object postExtractionHookConfiguration;
            Object preExtractionHookConfiguration;
            String roleArn;

            public Builder inlineConfigurations(IResolvable inlineConfigurations) {
                this.inlineConfigurations = inlineConfigurations;
                return this;
            }

            public Builder inlineConfigurations(List<? extends Object> inlineConfigurations) {
                this.inlineConfigurations = inlineConfigurations;
                return this;
            }

            public Builder postExtractionHookConfiguration(IResolvable postExtractionHookConfiguration) {
                this.postExtractionHookConfiguration = postExtractionHookConfiguration;
                return this;
            }

            public Builder postExtractionHookConfiguration(HookConfigurationProperty postExtractionHookConfiguration) {
                this.postExtractionHookConfiguration = postExtractionHookConfiguration;
                return this;
            }

            public Builder preExtractionHookConfiguration(IResolvable preExtractionHookConfiguration) {
                this.preExtractionHookConfiguration = preExtractionHookConfiguration;
                return this;
            }

            public Builder preExtractionHookConfiguration(HookConfigurationProperty preExtractionHookConfiguration) {
                this.preExtractionHookConfiguration = preExtractionHookConfiguration;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public CustomDocumentEnrichmentConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConnectionConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabaseHost();

        @NotNull
        public String getDatabaseName();

        @NotNull
        public Number getDatabasePort();

        @NotNull
        public String getSecretArn();

        @NotNull
        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConnectionConfigurationProperty> {
            String databaseHost;
            String databaseName;
            Number databasePort;
            String secretArn;
            String tableName;

            public Builder databaseHost(String databaseHost) {
                this.databaseHost = databaseHost;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder databasePort(Number databasePort) {
                this.databasePort = databasePort;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public ConnectionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceSpaceToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceSpaceToIndexFieldMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSourceFieldName();

        @NotNull
        public String getIndexFieldName();

        @Nullable
        default public String getDateFieldFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceSpaceToIndexFieldMappingProperty> {
            String dataSourceFieldName;
            String indexFieldName;
            String dateFieldFormat;

            public Builder dataSourceFieldName(String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            public Builder indexFieldName(String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            public Builder dateFieldFormat(String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            public ConfluenceSpaceToIndexFieldMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceSpaceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceSpaceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCrawlArchivedSpaces() {
            return null;
        }

        @Nullable
        default public Object getCrawlPersonalSpaces() {
            return null;
        }

        @Nullable
        default public List<String> getExcludeSpaces() {
            return null;
        }

        @Nullable
        default public List<String> getIncludeSpaces() {
            return null;
        }

        @Nullable
        default public Object getSpaceFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceSpaceConfigurationProperty> {
            Object crawlArchivedSpaces;
            Object crawlPersonalSpaces;
            List<String> excludeSpaces;
            List<String> includeSpaces;
            Object spaceFieldMappings;

            public Builder crawlArchivedSpaces(Boolean crawlArchivedSpaces) {
                this.crawlArchivedSpaces = crawlArchivedSpaces;
                return this;
            }

            public Builder crawlArchivedSpaces(IResolvable crawlArchivedSpaces) {
                this.crawlArchivedSpaces = crawlArchivedSpaces;
                return this;
            }

            public Builder crawlPersonalSpaces(Boolean crawlPersonalSpaces) {
                this.crawlPersonalSpaces = crawlPersonalSpaces;
                return this;
            }

            public Builder crawlPersonalSpaces(IResolvable crawlPersonalSpaces) {
                this.crawlPersonalSpaces = crawlPersonalSpaces;
                return this;
            }

            public Builder excludeSpaces(List<String> excludeSpaces) {
                this.excludeSpaces = excludeSpaces;
                return this;
            }

            public Builder includeSpaces(List<String> includeSpaces) {
                this.includeSpaces = includeSpaces;
                return this;
            }

            public Builder spaceFieldMappings(IResolvable spaceFieldMappings) {
                this.spaceFieldMappings = spaceFieldMappings;
                return this;
            }

            public Builder spaceFieldMappings(List<? extends Object> spaceFieldMappings) {
                this.spaceFieldMappings = spaceFieldMappings;
                return this;
            }

            public ConfluenceSpaceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ConfluencePageToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluencePageToIndexFieldMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSourceFieldName();

        @NotNull
        public String getIndexFieldName();

        @Nullable
        default public String getDateFieldFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluencePageToIndexFieldMappingProperty> {
            String dataSourceFieldName;
            String indexFieldName;
            String dateFieldFormat;

            public Builder dataSourceFieldName(String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            public Builder indexFieldName(String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            public Builder dateFieldFormat(String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            public ConfluencePageToIndexFieldMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ConfluencePageConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluencePageConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPageFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluencePageConfigurationProperty> {
            Object pageFieldMappings;

            public Builder pageFieldMappings(IResolvable pageFieldMappings) {
                this.pageFieldMappings = pageFieldMappings;
                return this;
            }

            public Builder pageFieldMappings(List<? extends Object> pageFieldMappings) {
                this.pageFieldMappings = pageFieldMappings;
                return this;
            }

            public ConfluencePageConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSecretArn();

        @NotNull
        public String getServerUrl();

        @NotNull
        public String getVersion();

        @Nullable
        default public Object getAttachmentConfiguration() {
            return null;
        }

        @Nullable
        default public Object getBlogConfiguration() {
            return null;
        }

        @Nullable
        default public List<String> getExclusionPatterns() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getPageConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSpaceConfiguration() {
            return null;
        }

        @Nullable
        default public Object getVpcConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceConfigurationProperty> {
            String secretArn;
            String serverUrl;
            String version;
            Object attachmentConfiguration;
            Object blogConfiguration;
            List<String> exclusionPatterns;
            List<String> inclusionPatterns;
            Object pageConfiguration;
            Object spaceConfiguration;
            Object vpcConfiguration;

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder serverUrl(String serverUrl) {
                this.serverUrl = serverUrl;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public Builder attachmentConfiguration(IResolvable attachmentConfiguration) {
                this.attachmentConfiguration = attachmentConfiguration;
                return this;
            }

            public Builder attachmentConfiguration(ConfluenceAttachmentConfigurationProperty attachmentConfiguration) {
                this.attachmentConfiguration = attachmentConfiguration;
                return this;
            }

            public Builder blogConfiguration(IResolvable blogConfiguration) {
                this.blogConfiguration = blogConfiguration;
                return this;
            }

            public Builder blogConfiguration(ConfluenceBlogConfigurationProperty blogConfiguration) {
                this.blogConfiguration = blogConfiguration;
                return this;
            }

            public Builder exclusionPatterns(List<String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder inclusionPatterns(List<String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public Builder pageConfiguration(IResolvable pageConfiguration) {
                this.pageConfiguration = pageConfiguration;
                return this;
            }

            public Builder pageConfiguration(ConfluencePageConfigurationProperty pageConfiguration) {
                this.pageConfiguration = pageConfiguration;
                return this;
            }

            public Builder spaceConfiguration(IResolvable spaceConfiguration) {
                this.spaceConfiguration = spaceConfiguration;
                return this;
            }

            public Builder spaceConfiguration(ConfluenceSpaceConfigurationProperty spaceConfiguration) {
                this.spaceConfiguration = spaceConfiguration;
                return this;
            }

            public Builder vpcConfiguration(IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public Builder vpcConfiguration(DataSourceVpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public ConfluenceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceBlogToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceBlogToIndexFieldMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSourceFieldName();

        @NotNull
        public String getIndexFieldName();

        @Nullable
        default public String getDateFieldFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceBlogToIndexFieldMappingProperty> {
            String dataSourceFieldName;
            String indexFieldName;
            String dateFieldFormat;

            public Builder dataSourceFieldName(String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            public Builder indexFieldName(String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            public Builder dateFieldFormat(String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            public ConfluenceBlogToIndexFieldMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceBlogConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceBlogConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBlogFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceBlogConfigurationProperty> {
            Object blogFieldMappings;

            public Builder blogFieldMappings(IResolvable blogFieldMappings) {
                this.blogFieldMappings = blogFieldMappings;
                return this;
            }

            public Builder blogFieldMappings(List<? extends Object> blogFieldMappings) {
                this.blogFieldMappings = blogFieldMappings;
                return this;
            }

            public ConfluenceBlogConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceAttachmentToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceAttachmentToIndexFieldMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSourceFieldName();

        @NotNull
        public String getIndexFieldName();

        @Nullable
        default public String getDateFieldFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceAttachmentToIndexFieldMappingProperty> {
            String dataSourceFieldName;
            String indexFieldName;
            String dateFieldFormat;

            public Builder dataSourceFieldName(String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            public Builder indexFieldName(String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            public Builder dateFieldFormat(String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            public ConfluenceAttachmentToIndexFieldMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceAttachmentConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceAttachmentConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAttachmentFieldMappings() {
            return null;
        }

        @Nullable
        default public Object getCrawlAttachments() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceAttachmentConfigurationProperty> {
            Object attachmentFieldMappings;
            Object crawlAttachments;

            public Builder attachmentFieldMappings(IResolvable attachmentFieldMappings) {
                this.attachmentFieldMappings = attachmentFieldMappings;
                return this;
            }

            public Builder attachmentFieldMappings(List<? extends Object> attachmentFieldMappings) {
                this.attachmentFieldMappings = attachmentFieldMappings;
                return this;
            }

            public Builder crawlAttachments(Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder crawlAttachments(IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public ConfluenceAttachmentConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.ColumnConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColumnConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getChangeDetectingColumns();

        @NotNull
        public String getDocumentDataColumnName();

        @NotNull
        public String getDocumentIdColumnName();

        @Nullable
        default public String getDocumentTitleColumnName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColumnConfigurationProperty> {
            List<String> changeDetectingColumns;
            String documentDataColumnName;
            String documentIdColumnName;
            String documentTitleColumnName;
            Object fieldMappings;

            public Builder changeDetectingColumns(List<String> changeDetectingColumns) {
                this.changeDetectingColumns = changeDetectingColumns;
                return this;
            }

            public Builder documentDataColumnName(String documentDataColumnName) {
                this.documentDataColumnName = documentDataColumnName;
                return this;
            }

            public Builder documentIdColumnName(String documentIdColumnName) {
                this.documentIdColumnName = documentIdColumnName;
                return this;
            }

            public Builder documentTitleColumnName(String documentTitleColumnName) {
                this.documentTitleColumnName = documentTitleColumnName;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public ColumnConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.AclConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AclConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getAllowedGroupsColumnName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AclConfigurationProperty> {
            String allowedGroupsColumnName;

            public Builder allowedGroupsColumnName(String allowedGroupsColumnName) {
                this.allowedGroupsColumnName = allowedGroupsColumnName;
                return this;
            }

            public AclConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kendra.CfnDataSource.AccessControlListConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccessControlListConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKeyPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AccessControlListConfigurationProperty> {
            String keyPath;

            public Builder keyPath(String keyPath) {
                this.keyPath = keyPath;
                return this;
            }

            public AccessControlListConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

