/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lightsail;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.lightsail.CfnContainer;
import software.amazon.awscdk.services.lightsail.CfnContainerProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnContainer")
public class CfnContainer
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnContainer.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnContainer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnContainer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnContainer(@NotNull Construct scope, @NotNull String id, @NotNull CfnContainerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrContainerArn() {
        return (String)Kernel.get((Object)this, (String)"attrContainerArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrUrl() {
        return (String)Kernel.get((Object)this, (String)"attrUrl", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getPower() {
        return (String)Kernel.get((Object)this, (String)"power", (NativeType)NativeType.forClass(String.class));
    }

    public void setPower(@NotNull String value) {
        Kernel.set((Object)this, (String)"power", (Object)Objects.requireNonNull(value, "power is required"));
    }

    @NotNull
    public Number getScale() {
        return (Number)Kernel.get((Object)this, (String)"scale", (NativeType)NativeType.forClass(Number.class));
    }

    public void setScale(@NotNull Number value) {
        Kernel.set((Object)this, (String)"scale", (Object)Objects.requireNonNull(value, "scale is required"));
    }

    @NotNull
    public String getServiceName() {
        return (String)Kernel.get((Object)this, (String)"serviceName", (NativeType)NativeType.forClass(String.class));
    }

    public void setServiceName(@NotNull String value) {
        Kernel.set((Object)this, (String)"serviceName", (Object)Objects.requireNonNull(value, "serviceName is required"));
    }

    @Nullable
    public Object getContainerServiceDeployment() {
        return Kernel.get((Object)this, (String)"containerServiceDeployment", (NativeType)NativeType.forClass(Object.class));
    }

    public void setContainerServiceDeployment(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"containerServiceDeployment", (Object)value);
    }

    public void setContainerServiceDeployment(@Nullable ContainerServiceDeploymentProperty value) {
        Kernel.set((Object)this, (String)"containerServiceDeployment", (Object)value);
    }

    @Nullable
    public Object getIsDisabled() {
        return Kernel.get((Object)this, (String)"isDisabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIsDisabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"isDisabled", (Object)value);
    }

    public void setIsDisabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"isDisabled", (Object)value);
    }

    @Nullable
    public Object getPublicDomainNames() {
        return Kernel.get((Object)this, (String)"publicDomainNames", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPublicDomainNames(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"publicDomainNames", (Object)value);
    }

    public void setPublicDomainNames(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof PublicDomainNameProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.lightsail.CfnContainer.PublicDomainNameProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"publicDomainNames", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnContainer> {
        private final Construct scope;
        private final String id;
        private final CfnContainerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnContainerProps.Builder();
        }

        public Builder power(String power) {
            this.props.power(power);
            return this;
        }

        public Builder scale(Number scale) {
            this.props.scale(scale);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        public Builder containerServiceDeployment(IResolvable containerServiceDeployment) {
            this.props.containerServiceDeployment(containerServiceDeployment);
            return this;
        }

        public Builder containerServiceDeployment(ContainerServiceDeploymentProperty containerServiceDeployment) {
            this.props.containerServiceDeployment(containerServiceDeployment);
            return this;
        }

        public Builder isDisabled(Boolean isDisabled) {
            this.props.isDisabled(isDisabled);
            return this;
        }

        public Builder isDisabled(IResolvable isDisabled) {
            this.props.isDisabled(isDisabled);
            return this;
        }

        public Builder publicDomainNames(IResolvable publicDomainNames) {
            this.props.publicDomainNames(publicDomainNames);
            return this;
        }

        public Builder publicDomainNames(List<? extends Object> publicDomainNames) {
            this.props.publicDomainNames(publicDomainNames);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnContainer build() {
            return new CfnContainer(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnContainer.PublicEndpointProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PublicEndpointProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerName() {
            return null;
        }

        @Nullable
        default public Number getContainerPort() {
            return null;
        }

        @Nullable
        default public Object getHealthCheckConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PublicEndpointProperty> {
            String containerName;
            Number containerPort;
            Object healthCheckConfig;

            public Builder containerName(String containerName) {
                this.containerName = containerName;
                return this;
            }

            public Builder containerPort(Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            public Builder healthCheckConfig(IResolvable healthCheckConfig) {
                this.healthCheckConfig = healthCheckConfig;
                return this;
            }

            public Builder healthCheckConfig(HealthCheckConfigProperty healthCheckConfig) {
                this.healthCheckConfig = healthCheckConfig;
                return this;
            }

            public PublicEndpointProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnContainer.PublicDomainNameProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PublicDomainNameProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCertificateName() {
            return null;
        }

        @Nullable
        default public List<String> getDomainNames() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PublicDomainNameProperty> {
            String certificateName;
            List<String> domainNames;

            public Builder certificateName(String certificateName) {
                this.certificateName = certificateName;
                return this;
            }

            public Builder domainNames(List<String> domainNames) {
                this.domainNames = domainNames;
                return this;
            }

            public PublicDomainNameProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnContainer.PortInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PortInfoProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPort() {
            return null;
        }

        @Nullable
        default public String getProtocol() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PortInfoProperty> {
            String port;
            String protocol;

            public Builder port(String port) {
                this.port = port;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public PortInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnContainer.HealthCheckConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HealthCheckConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getHealthyThreshold() {
            return null;
        }

        @Nullable
        default public Number getIntervalSeconds() {
            return null;
        }

        @Nullable
        default public String getPath() {
            return null;
        }

        @Nullable
        default public String getSuccessCodes() {
            return null;
        }

        @Nullable
        default public Number getTimeoutSeconds() {
            return null;
        }

        @Nullable
        default public Number getUnhealthyThreshold() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HealthCheckConfigProperty> {
            Number healthyThreshold;
            Number intervalSeconds;
            String path;
            String successCodes;
            Number timeoutSeconds;
            Number unhealthyThreshold;

            public Builder healthyThreshold(Number healthyThreshold) {
                this.healthyThreshold = healthyThreshold;
                return this;
            }

            public Builder intervalSeconds(Number intervalSeconds) {
                this.intervalSeconds = intervalSeconds;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder successCodes(String successCodes) {
                this.successCodes = successCodes;
                return this;
            }

            public Builder timeoutSeconds(Number timeoutSeconds) {
                this.timeoutSeconds = timeoutSeconds;
                return this;
            }

            public Builder unhealthyThreshold(Number unhealthyThreshold) {
                this.unhealthyThreshold = unhealthyThreshold;
                return this;
            }

            public HealthCheckConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnContainer.EnvironmentVariableProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnvironmentVariableProperty
    extends JsiiSerializable {
        @Nullable
        default public String getValue() {
            return null;
        }

        @Nullable
        default public String getVariable() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnvironmentVariableProperty> {
            String value;
            String variable;

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Builder variable(String variable) {
                this.variable = variable;
                return this;
            }

            public EnvironmentVariableProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnContainer.ContainerServiceDeploymentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ContainerServiceDeploymentProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getContainers() {
            return null;
        }

        @Nullable
        default public Object getPublicEndpoint() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ContainerServiceDeploymentProperty> {
            Object containers;
            Object publicEndpoint;

            public Builder containers(IResolvable containers) {
                this.containers = containers;
                return this;
            }

            public Builder containers(List<? extends Object> containers) {
                this.containers = containers;
                return this;
            }

            public Builder publicEndpoint(IResolvable publicEndpoint) {
                this.publicEndpoint = publicEndpoint;
                return this;
            }

            public Builder publicEndpoint(PublicEndpointProperty publicEndpoint) {
                this.publicEndpoint = publicEndpoint;
                return this;
            }

            public ContainerServiceDeploymentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lightsail.CfnContainer.ContainerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ContainerProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getCommand() {
            return null;
        }

        @Nullable
        default public String getContainerName() {
            return null;
        }

        @Nullable
        default public Object getEnvironment() {
            return null;
        }

        @Nullable
        default public String getImage() {
            return null;
        }

        @Nullable
        default public Object getPorts() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ContainerProperty> {
            List<String> command;
            String containerName;
            Object environment;
            String image;
            Object ports;

            public Builder command(List<String> command) {
                this.command = command;
                return this;
            }

            public Builder containerName(String containerName) {
                this.containerName = containerName;
                return this;
            }

            public Builder environment(IResolvable environment) {
                this.environment = environment;
                return this;
            }

            public Builder environment(List<? extends Object> environment) {
                this.environment = environment;
                return this;
            }

            public Builder image(String image) {
                this.image = image;
                return this;
            }

            public Builder ports(IResolvable ports) {
                this.ports = ports;
                return this;
            }

            public Builder ports(List<? extends Object> ports) {
                this.ports = ports;
                return this;
            }

            public ContainerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

