/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3.deployment;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Expiration;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.cloudfront.IDistribution;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.s3.BucketAccessControl;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.deployment.BucketDeploymentProps;
import software.amazon.awscdk.services.s3.deployment.CacheControl;
import software.amazon.awscdk.services.s3.deployment.ISource;
import software.amazon.awscdk.services.s3.deployment.ServerSideEncryption;
import software.amazon.awscdk.services.s3.deployment.StorageClass;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_s3_deployment.BucketDeploymentProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface BucketDeploymentProps
extends JsiiSerializable {
    @NotNull
    public IBucket getDestinationBucket();

    @NotNull
    public List<ISource> getSources();

    @Nullable
    default public BucketAccessControl getAccessControl() {
        return null;
    }

    @Nullable
    default public List<CacheControl> getCacheControl() {
        return null;
    }

    @Nullable
    default public String getContentDisposition() {
        return null;
    }

    @Nullable
    default public String getContentEncoding() {
        return null;
    }

    @Nullable
    default public String getContentLanguage() {
        return null;
    }

    @Nullable
    default public String getContentType() {
        return null;
    }

    @Nullable
    default public String getDestinationKeyPrefix() {
        return null;
    }

    @Nullable
    default public IDistribution getDistribution() {
        return null;
    }

    @Nullable
    default public List<String> getDistributionPaths() {
        return null;
    }

    @Nullable
    default public Size getEphemeralStorageSize() {
        return null;
    }

    @Nullable
    default public List<String> getExclude() {
        return null;
    }

    @Nullable
    default public Expiration getExpires() {
        return null;
    }

    @Nullable
    default public Boolean getExtract() {
        return null;
    }

    @Nullable
    default public List<String> getInclude() {
        return null;
    }

    @Nullable
    default public RetentionDays getLogRetention() {
        return null;
    }

    @Nullable
    default public Number getMemoryLimit() {
        return null;
    }

    @Nullable
    default public Map<String, String> getMetadata() {
        return null;
    }

    @Nullable
    default public Boolean getPrune() {
        return null;
    }

    @Nullable
    default public Boolean getRetainOnDelete() {
        return null;
    }

    @Nullable
    default public IRole getRole() {
        return null;
    }

    @Nullable
    default public ServerSideEncryption getServerSideEncryption() {
        return null;
    }

    @Nullable
    default public String getServerSideEncryptionAwsKmsKeyId() {
        return null;
    }

    @Nullable
    default public String getServerSideEncryptionCustomerAlgorithm() {
        return null;
    }

    @Nullable
    default public StorageClass getStorageClass() {
        return null;
    }

    @Nullable
    default public Boolean getUseEfs() {
        return null;
    }

    @Nullable
    default public IVpc getVpc() {
        return null;
    }

    @Nullable
    default public SubnetSelection getVpcSubnets() {
        return null;
    }

    @Nullable
    default public String getWebsiteRedirectLocation() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<BucketDeploymentProps> {
        IBucket destinationBucket;
        List<ISource> sources;
        BucketAccessControl accessControl;
        List<CacheControl> cacheControl;
        String contentDisposition;
        String contentEncoding;
        String contentLanguage;
        String contentType;
        String destinationKeyPrefix;
        IDistribution distribution;
        List<String> distributionPaths;
        Size ephemeralStorageSize;
        List<String> exclude;
        Expiration expires;
        Boolean extract;
        List<String> include;
        RetentionDays logRetention;
        Number memoryLimit;
        Map<String, String> metadata;
        Boolean prune;
        Boolean retainOnDelete;
        IRole role;
        ServerSideEncryption serverSideEncryption;
        String serverSideEncryptionAwsKmsKeyId;
        String serverSideEncryptionCustomerAlgorithm;
        StorageClass storageClass;
        Boolean useEfs;
        IVpc vpc;
        SubnetSelection vpcSubnets;
        String websiteRedirectLocation;

        public Builder destinationBucket(IBucket destinationBucket) {
            this.destinationBucket = destinationBucket;
            return this;
        }

        public Builder sources(List<? extends ISource> sources) {
            this.sources = sources;
            return this;
        }

        public Builder accessControl(BucketAccessControl accessControl) {
            this.accessControl = accessControl;
            return this;
        }

        public Builder cacheControl(List<? extends CacheControl> cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder destinationKeyPrefix(String destinationKeyPrefix) {
            this.destinationKeyPrefix = destinationKeyPrefix;
            return this;
        }

        public Builder distribution(IDistribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public Builder distributionPaths(List<String> distributionPaths) {
            this.distributionPaths = distributionPaths;
            return this;
        }

        public Builder ephemeralStorageSize(Size ephemeralStorageSize) {
            this.ephemeralStorageSize = ephemeralStorageSize;
            return this;
        }

        public Builder exclude(List<String> exclude) {
            this.exclude = exclude;
            return this;
        }

        public Builder expires(Expiration expires) {
            this.expires = expires;
            return this;
        }

        public Builder extract(Boolean extract) {
            this.extract = extract;
            return this;
        }

        public Builder include(List<String> include) {
            this.include = include;
            return this;
        }

        public Builder logRetention(RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        public Builder memoryLimit(Number memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder prune(Boolean prune) {
            this.prune = prune;
            return this;
        }

        public Builder retainOnDelete(Boolean retainOnDelete) {
            this.retainOnDelete = retainOnDelete;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public Builder serverSideEncryptionAwsKmsKeyId(String serverSideEncryptionAwsKmsKeyId) {
            this.serverSideEncryptionAwsKmsKeyId = serverSideEncryptionAwsKmsKeyId;
            return this;
        }

        public Builder serverSideEncryptionCustomerAlgorithm(String serverSideEncryptionCustomerAlgorithm) {
            this.serverSideEncryptionCustomerAlgorithm = serverSideEncryptionCustomerAlgorithm;
            return this;
        }

        public Builder storageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public Builder useEfs(Boolean useEfs) {
            this.useEfs = useEfs;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public Builder websiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        public BucketDeploymentProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

