/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.stepfunctions.Condition;
import software.amazon.awscdk.services.stepfunctions.FindStateOptions;
import software.amazon.awscdk.services.stepfunctions.IChainable;
import software.amazon.awscdk.services.stepfunctions.INextable;
import software.amazon.awscdk.services.stepfunctions.StateGraph;
import software.amazon.awscdk.services.stepfunctions.StateProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;
import software.constructs.IConstruct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_stepfunctions.State")
public abstract class State
extends Construct
implements IChainable {
    protected State(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected State(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected State(@NotNull Construct scope, @NotNull String id, @NotNull StateProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static List<INextable> filterNextables(@NotNull List<? extends State> states) {
        return Collections.unmodifiableList((List)JsiiObject.jsiiStaticCall(State.class, (String)"filterNextables", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(INextable.class)), (Object[])new Object[]{Objects.requireNonNull(states, "states is required")}));
    }

    @NotNull
    public static List<State> findReachableEndStates(@NotNull State start, @Nullable FindStateOptions options) {
        return Collections.unmodifiableList((List)JsiiObject.jsiiStaticCall(State.class, (String)"findReachableEndStates", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(State.class)), (Object[])new Object[]{Objects.requireNonNull(start, "start is required"), options}));
    }

    @NotNull
    public static List<State> findReachableEndStates(@NotNull State start) {
        return Collections.unmodifiableList((List)JsiiObject.jsiiStaticCall(State.class, (String)"findReachableEndStates", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(State.class)), (Object[])new Object[]{Objects.requireNonNull(start, "start is required")}));
    }

    @NotNull
    public static List<State> findReachableStates(@NotNull State start, @Nullable FindStateOptions options) {
        return Collections.unmodifiableList((List)JsiiObject.jsiiStaticCall(State.class, (String)"findReachableStates", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(State.class)), (Object[])new Object[]{Objects.requireNonNull(start, "start is required"), options}));
    }

    @NotNull
    public static List<State> findReachableStates(@NotNull State start) {
        return Collections.unmodifiableList((List)JsiiObject.jsiiStaticCall(State.class, (String)"findReachableStates", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(State.class)), (Object[])new Object[]{Objects.requireNonNull(start, "start is required")}));
    }

    public static void prefixStates(@NotNull IConstruct root, @NotNull String prefix) {
        JsiiObject.jsiiStaticCall(State.class, (String)"prefixStates", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(root, "root is required"), Objects.requireNonNull(prefix, "prefix is required")});
    }

    protected void addBranch(@NotNull StateGraph branch) {
        Kernel.call((Object)this, (String)"addBranch", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(branch, "branch is required")});
    }

    protected void addChoice(@NotNull Condition condition, @NotNull State next) {
        Kernel.call((Object)this, (String)"addChoice", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(condition, "condition is required"), Objects.requireNonNull(next, "next is required")});
    }

    protected void addIterator(@NotNull StateGraph iteration) {
        Kernel.call((Object)this, (String)"addIterator", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(iteration, "iteration is required")});
    }

    public void addPrefix(@NotNull String x) {
        Kernel.call((Object)this, (String)"addPrefix", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(x, "x is required")});
    }

    public void bindToGraph(@NotNull StateGraph graph) {
        Kernel.call((Object)this, (String)"bindToGraph", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(graph, "graph is required")});
    }

    protected void makeDefault(@NotNull State def) {
        Kernel.call((Object)this, (String)"makeDefault", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(def, "def is required")});
    }

    protected void makeNext(@NotNull State next) {
        Kernel.call((Object)this, (String)"makeNext", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(next, "next is required")});
    }

    @NotNull
    protected Object renderBranches() {
        return Kernel.call((Object)this, (String)"renderBranches", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[0]);
    }

    @NotNull
    protected Object renderChoices() {
        return Kernel.call((Object)this, (String)"renderChoices", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[0]);
    }

    @NotNull
    protected Object renderInputOutput() {
        return Kernel.call((Object)this, (String)"renderInputOutput", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[0]);
    }

    @NotNull
    protected Object renderIterator() {
        return Kernel.call((Object)this, (String)"renderIterator", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[0]);
    }

    @NotNull
    protected Object renderNextEnd() {
        return Kernel.call((Object)this, (String)"renderNextEnd", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[0]);
    }

    @NotNull
    protected Object renderResultSelector() {
        return Kernel.call((Object)this, (String)"renderResultSelector", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[0]);
    }

    @NotNull
    protected Object renderRetryCatch() {
        return Kernel.call((Object)this, (String)"renderRetryCatch", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[0]);
    }

    @NotNull
    public abstract ObjectNode toStateJson();

    @NotNull
    protected List<String> validateState() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"validateState", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    protected void whenBoundToGraph(@NotNull StateGraph graph) {
        Kernel.call((Object)this, (String)"whenBoundToGraph", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(graph, "graph is required")});
    }

    @NotNull
    protected List<StateGraph> getBranches() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"branches", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(StateGraph.class))));
    }

    @Override
    @NotNull
    public abstract List<INextable> getEndStates();

    @Override
    @NotNull
    public String getId() {
        return (String)Kernel.get((Object)this, (String)"id", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public State getStartState() {
        return (State)Kernel.get((Object)this, (String)"startState", (NativeType)NativeType.forClass(State.class));
    }

    @NotNull
    public String getStateId() {
        return (String)Kernel.get((Object)this, (String)"stateId", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    protected String getComment() {
        return (String)Kernel.get((Object)this, (String)"comment", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    protected String getInputPath() {
        return (String)Kernel.get((Object)this, (String)"inputPath", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    protected String getOutputPath() {
        return (String)Kernel.get((Object)this, (String)"outputPath", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    protected ObjectNode getParameters() {
        return (ObjectNode)Kernel.get((Object)this, (String)"parameters", (NativeType)NativeType.forClass(ObjectNode.class));
    }

    @Nullable
    protected String getResultPath() {
        return (String)Kernel.get((Object)this, (String)"resultPath", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    protected ObjectNode getResultSelector() {
        return (ObjectNode)Kernel.get((Object)this, (String)"resultSelector", (NativeType)NativeType.forClass(ObjectNode.class));
    }

    @Nullable
    protected State getDefaultChoice() {
        return (State)Kernel.get((Object)this, (String)"defaultChoice", (NativeType)NativeType.forClass(State.class));
    }

    protected void setDefaultChoice(@Nullable State value) {
        Kernel.set((Object)this, (String)"defaultChoice", (Object)value);
    }

    @Nullable
    protected StateGraph getIteration() {
        return (StateGraph)((Object)Kernel.get((Object)this, (String)"iteration", (NativeType)NativeType.forClass(StateGraph.class)));
    }

    protected void setIteration(@Nullable StateGraph value) {
        Kernel.set((Object)this, (String)"iteration", (Object)((Object)value));
    }
}

