/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.pipelines;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.pipelines.;
import software.amazon.awscdk.pipelines.ShellScriptActionProps;
import software.amazon.awscdk.pipelines.StackOutput;
import software.amazon.awscdk.services.codebuild.BuildEnvironment;
import software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable;
import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/pipelines.ShellScriptActionProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ShellScriptActionProps
extends JsiiSerializable {
    @NotNull
    public String getActionName();

    @NotNull
    public List<String> getCommands();

    @Nullable
    default public List<Artifact> getAdditionalArtifacts() {
        return null;
    }

    @Nullable
    default public String getBashOptions() {
        return null;
    }

    @Nullable
    default public BuildEnvironment getEnvironment() {
        return null;
    }

    @Nullable
    default public Map<String, BuildEnvironmentVariable> getEnvironmentVariables() {
        return null;
    }

    @Nullable
    default public List<PolicyStatement> getRolePolicyStatements() {
        return null;
    }

    @Nullable
    default public Number getRunOrder() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public SubnetSelection getSubnetSelection() {
        return null;
    }

    @Nullable
    default public Map<String, StackOutput> getUseOutputs() {
        return null;
    }

    @Nullable
    default public IVpc getVpc() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ShellScriptActionProps> {
        private String actionName;
        private List<String> commands;
        private List<Artifact> additionalArtifacts;
        private String bashOptions;
        private BuildEnvironment environment;
        private Map<String, BuildEnvironmentVariable> environmentVariables;
        private List<PolicyStatement> rolePolicyStatements;
        private Number runOrder;
        private List<ISecurityGroup> securityGroups;
        private SubnetSelection subnetSelection;
        private Map<String, StackOutput> useOutputs;
        private IVpc vpc;

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder commands(List<String> commands) {
            this.commands = commands;
            return this;
        }

        public Builder additionalArtifacts(List<? extends Artifact> additionalArtifacts) {
            this.additionalArtifacts = additionalArtifacts;
            return this;
        }

        public Builder bashOptions(String bashOptions) {
            this.bashOptions = bashOptions;
            return this;
        }

        public Builder environment(BuildEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public Builder environmentVariables(Map<String, ? extends BuildEnvironmentVariable> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        public Builder rolePolicyStatements(List<? extends PolicyStatement> rolePolicyStatements) {
            this.rolePolicyStatements = rolePolicyStatements;
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        public Builder useOutputs(Map<String, ? extends StackOutput> useOutputs) {
            this.useOutputs = useOutputs;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public ShellScriptActionProps build() {
            return new Jsii.Proxy(this.actionName, this.commands, this.additionalArtifacts, this.bashOptions, this.environment, this.environmentVariables, this.rolePolicyStatements, this.runOrder, this.securityGroups, this.subnetSelection, this.useOutputs, this.vpc);
        }
    }
}

