/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.autoscaling.BlockDevice;
import software.amazon.awscdk.services.autoscaling.CommonAutoScalingGroupProps;
import software.amazon.awscdk.services.autoscaling.GroupMetrics;
import software.amazon.awscdk.services.autoscaling.HealthCheck;
import software.amazon.awscdk.services.autoscaling.Monitoring;
import software.amazon.awscdk.services.autoscaling.NotificationConfiguration;
import software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration;
import software.amazon.awscdk.services.autoscaling.Signals;
import software.amazon.awscdk.services.autoscaling.UpdatePolicy;
import software.amazon.awscdk.services.autoscaling.UpdateType;
import software.amazon.awscdk.services.ec2.IMachineImage;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.$Module;
import software.amazon.awscdk.services.ecs.AddAutoScalingGroupCapacityOptions;
import software.amazon.awscdk.services.ecs.AddCapacityOptions;
import software.amazon.awscdk.services.ecs.MachineImageType;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ecs.AddCapacityOptions")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface AddCapacityOptions
extends JsiiSerializable,
AddAutoScalingGroupCapacityOptions,
CommonAutoScalingGroupProps {
    @NotNull
    public InstanceType getInstanceType();

    @Nullable
    default public IMachineImage getMachineImage() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AddCapacityOptions> {
        private InstanceType instanceType;
        private IMachineImage machineImage;
        private Boolean canContainersAccessInstanceRole;
        private MachineImageType machineImageType;
        private Boolean spotInstanceDraining;
        private Duration taskDrainTime;
        private IKey topicEncryptionKey;
        private Boolean allowAllOutbound;
        private Boolean associatePublicIpAddress;
        private String autoScalingGroupName;
        private List<BlockDevice> blockDevices;
        private Duration cooldown;
        private Number desiredCapacity;
        private List<GroupMetrics> groupMetrics;
        private HealthCheck healthCheck;
        private Boolean ignoreUnmodifiedSizeProperties;
        private Monitoring instanceMonitoring;
        private String keyName;
        private Number maxCapacity;
        private Duration maxInstanceLifetime;
        private Number minCapacity;
        private List<NotificationConfiguration> notifications;
        private ITopic notificationsTopic;
        private Number replacingUpdateMinSuccessfulInstancesPercent;
        private Number resourceSignalCount;
        private Duration resourceSignalTimeout;
        private RollingUpdateConfiguration rollingUpdateConfiguration;
        private Signals signals;
        private String spotPrice;
        private UpdatePolicy updatePolicy;
        private UpdateType updateType;
        private SubnetSelection vpcSubnets;

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder machineImage(IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        public Builder canContainersAccessInstanceRole(Boolean canContainersAccessInstanceRole) {
            this.canContainersAccessInstanceRole = canContainersAccessInstanceRole;
            return this;
        }

        public Builder machineImageType(MachineImageType machineImageType) {
            this.machineImageType = machineImageType;
            return this;
        }

        public Builder spotInstanceDraining(Boolean spotInstanceDraining) {
            this.spotInstanceDraining = spotInstanceDraining;
            return this;
        }

        public Builder taskDrainTime(Duration taskDrainTime) {
            this.taskDrainTime = taskDrainTime;
            return this;
        }

        public Builder topicEncryptionKey(IKey topicEncryptionKey) {
            this.topicEncryptionKey = topicEncryptionKey;
            return this;
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public Builder blockDevices(List<? extends BlockDevice> blockDevices) {
            this.blockDevices = blockDevices;
            return this;
        }

        public Builder cooldown(Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder desiredCapacity(Number desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public Builder groupMetrics(List<? extends GroupMetrics> groupMetrics) {
            this.groupMetrics = groupMetrics;
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder ignoreUnmodifiedSizeProperties(Boolean ignoreUnmodifiedSizeProperties) {
            this.ignoreUnmodifiedSizeProperties = ignoreUnmodifiedSizeProperties;
            return this;
        }

        public Builder instanceMonitoring(Monitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder maxCapacity(Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public Builder maxInstanceLifetime(Duration maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        public Builder minCapacity(Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public Builder notifications(List<? extends NotificationConfiguration> notifications) {
            this.notifications = notifications;
            return this;
        }

        @Deprecated
        public Builder notificationsTopic(ITopic notificationsTopic) {
            this.notificationsTopic = notificationsTopic;
            return this;
        }

        @Deprecated
        public Builder replacingUpdateMinSuccessfulInstancesPercent(Number replacingUpdateMinSuccessfulInstancesPercent) {
            this.replacingUpdateMinSuccessfulInstancesPercent = replacingUpdateMinSuccessfulInstancesPercent;
            return this;
        }

        @Deprecated
        public Builder resourceSignalCount(Number resourceSignalCount) {
            this.resourceSignalCount = resourceSignalCount;
            return this;
        }

        @Deprecated
        public Builder resourceSignalTimeout(Duration resourceSignalTimeout) {
            this.resourceSignalTimeout = resourceSignalTimeout;
            return this;
        }

        @Deprecated
        public Builder rollingUpdateConfiguration(RollingUpdateConfiguration rollingUpdateConfiguration) {
            this.rollingUpdateConfiguration = rollingUpdateConfiguration;
            return this;
        }

        public Builder signals(Signals signals) {
            this.signals = signals;
            return this;
        }

        public Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public Builder updatePolicy(UpdatePolicy updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        @Deprecated
        public Builder updateType(UpdateType updateType) {
            this.updateType = updateType;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public AddCapacityOptions build() {
            return new Jsii.Proxy(this.instanceType, this.machineImage, this.canContainersAccessInstanceRole, this.machineImageType, this.spotInstanceDraining, this.taskDrainTime, this.topicEncryptionKey, this.allowAllOutbound, this.associatePublicIpAddress, this.autoScalingGroupName, this.blockDevices, this.cooldown, this.desiredCapacity, this.groupMetrics, this.healthCheck, this.ignoreUnmodifiedSizeProperties, this.instanceMonitoring, this.keyName, this.maxCapacity, this.maxInstanceLifetime, this.minCapacity, this.notifications, this.notificationsTopic, this.replacingUpdateMinSuccessfulInstancesPercent, this.resourceSignalCount, this.resourceSignalTimeout, this.rollingUpdateConfiguration, this.signals, this.spotPrice, this.updatePolicy, this.updateType, this.vpcSubnets);
        }
    }
}

