/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.rds.$Module;
import software.amazon.awscdk.services.rds.BackupProps;
import software.amazon.awscdk.services.rds.CfnDBClusterProps;
import software.amazon.awscdk.services.rds.Credentials;
import software.amazon.awscdk.services.rds.DatabaseClusterAttributes;
import software.amazon.awscdk.services.rds.DatabaseClusterBase;
import software.amazon.awscdk.services.rds.DatabaseClusterProps;
import software.amazon.awscdk.services.rds.Endpoint;
import software.amazon.awscdk.services.rds.IClusterEngine;
import software.amazon.awscdk.services.rds.IDatabaseCluster;
import software.amazon.awscdk.services.rds.IParameterGroup;
import software.amazon.awscdk.services.rds.ISubnetGroup;
import software.amazon.awscdk.services.rds.InstanceProps;
import software.amazon.awscdk.services.rds.RotationMultiUserOptions;
import software.amazon.awscdk.services.rds.RotationSingleUserOptions;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.SecretRotation;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-rds.DatabaseCluster")
public class DatabaseCluster
extends DatabaseClusterBase {
    protected DatabaseCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DatabaseCluster(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IDatabaseCluster fromDatabaseClusterAttributes(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseClusterAttributes attrs) {
        return (IDatabaseCluster)JsiiObject.jsiiStaticCall(DatabaseCluster.class, (String)"fromDatabaseClusterAttributes", (NativeType)NativeType.forClass(IDatabaseCluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public SecretRotation addRotationMultiUser(@NotNull String id, @NotNull RotationMultiUserOptions options) {
        return (SecretRotation)Kernel.call((Object)this, (String)"addRotationMultiUser", (NativeType)NativeType.forClass(SecretRotation.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public SecretRotation addRotationSingleUser(@Nullable RotationSingleUserOptions options) {
        return (SecretRotation)Kernel.call((Object)this, (String)"addRotationSingleUser", (NativeType)NativeType.forClass(SecretRotation.class), (Object[])new Object[]{options});
    }

    @NotNull
    public SecretRotation addRotationSingleUser() {
        return (SecretRotation)Kernel.call((Object)this, (String)"addRotationSingleUser", (NativeType)NativeType.forClass(SecretRotation.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Endpoint getClusterEndpoint() {
        return (Endpoint)((Object)Kernel.get((Object)this, (String)"clusterEndpoint", (NativeType)NativeType.forClass(Endpoint.class)));
    }

    @Override
    @NotNull
    public String getClusterIdentifier() {
        return (String)Kernel.get((Object)this, (String)"clusterIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Endpoint getClusterReadEndpoint() {
        return (Endpoint)((Object)Kernel.get((Object)this, (String)"clusterReadEndpoint", (NativeType)NativeType.forClass(Endpoint.class)));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public List<Endpoint> getInstanceEndpoints() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"instanceEndpoints", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Endpoint.class))));
    }

    @Override
    @NotNull
    public List<String> getInstanceIdentifiers() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"instanceIdentifiers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    protected CfnDBClusterProps getNewCfnProps() {
        return (CfnDBClusterProps)Kernel.get((Object)this, (String)"newCfnProps", (NativeType)NativeType.forClass(CfnDBClusterProps.class));
    }

    @NotNull
    protected List<ISecurityGroup> getSecurityGroups() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"securityGroups", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ISecurityGroup.class))));
    }

    @NotNull
    protected ISubnetGroup getSubnetGroup() {
        return (ISubnetGroup)Kernel.get((Object)this, (String)"subnetGroup", (NativeType)NativeType.forClass(ISubnetGroup.class));
    }

    @Override
    @Nullable
    public IClusterEngine getEngine() {
        return (IClusterEngine)Kernel.get((Object)this, (String)"engine", (NativeType)NativeType.forClass(IClusterEngine.class));
    }

    @Nullable
    public ISecret getSecret() {
        return (ISecret)Kernel.get((Object)this, (String)"secret", (NativeType)NativeType.forClass(ISecret.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseCluster> {
        private final Construct scope;
        private final String id;
        private final DatabaseClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DatabaseClusterProps.Builder();
        }

        public Builder engine(IClusterEngine engine) {
            this.props.engine(engine);
            return this;
        }

        public Builder instanceProps(InstanceProps instanceProps) {
            this.props.instanceProps(instanceProps);
            return this;
        }

        public Builder backup(BackupProps backup) {
            this.props.backup(backup);
            return this;
        }

        public Builder cloudwatchLogsExports(List<String> cloudwatchLogsExports) {
            this.props.cloudwatchLogsExports(cloudwatchLogsExports);
            return this;
        }

        public Builder cloudwatchLogsRetention(RetentionDays cloudwatchLogsRetention) {
            this.props.cloudwatchLogsRetention(cloudwatchLogsRetention);
            return this;
        }

        public Builder cloudwatchLogsRetentionRole(IRole cloudwatchLogsRetentionRole) {
            this.props.cloudwatchLogsRetentionRole(cloudwatchLogsRetentionRole);
            return this;
        }

        public Builder clusterIdentifier(String clusterIdentifier) {
            this.props.clusterIdentifier(clusterIdentifier);
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        public Builder defaultDatabaseName(String defaultDatabaseName) {
            this.props.defaultDatabaseName(defaultDatabaseName);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        public Builder instanceIdentifierBase(String instanceIdentifierBase) {
            this.props.instanceIdentifierBase(instanceIdentifierBase);
            return this;
        }

        public Builder instances(Number instances) {
            this.props.instances(instances);
            return this;
        }

        public Builder monitoringInterval(Duration monitoringInterval) {
            this.props.monitoringInterval(monitoringInterval);
            return this;
        }

        public Builder monitoringRole(IRole monitoringRole) {
            this.props.monitoringRole(monitoringRole);
            return this;
        }

        public Builder parameterGroup(IParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder s3ExportBuckets(List<? extends IBucket> s3ExportBuckets) {
            this.props.s3ExportBuckets(s3ExportBuckets);
            return this;
        }

        public Builder s3ExportRole(IRole s3ExportRole) {
            this.props.s3ExportRole(s3ExportRole);
            return this;
        }

        public Builder s3ImportBuckets(List<? extends IBucket> s3ImportBuckets) {
            this.props.s3ImportBuckets(s3ImportBuckets);
            return this;
        }

        public Builder s3ImportRole(IRole s3ImportRole) {
            this.props.s3ImportRole(s3ImportRole);
            return this;
        }

        public Builder storageEncrypted(Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        public Builder storageEncryptionKey(IKey storageEncryptionKey) {
            this.props.storageEncryptionKey(storageEncryptionKey);
            return this;
        }

        public Builder subnetGroup(ISubnetGroup subnetGroup) {
            this.props.subnetGroup(subnetGroup);
            return this;
        }

        public DatabaseCluster build() {
            return new DatabaseCluster(this.scope, this.id, this.props.build());
        }
    }
}

