/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acm.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportCertificateRequest extends AcmRequest implements
        ToCopyableBuilder<ImportCertificateRequest.Builder, ImportCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportCertificateRequest::certificateArn)).setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()).build();

    private static final SdkField<SdkBytes> CERTIFICATE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(ImportCertificateRequest::certificate)).setter(setter(Builder::certificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final SdkField<SdkBytes> PRIVATE_KEY_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(ImportCertificateRequest::privateKey)).setter(setter(Builder::privateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKey").build()).build();

    private static final SdkField<SdkBytes> CERTIFICATE_CHAIN_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(ImportCertificateRequest::certificateChain)).setter(setter(Builder::certificateChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateChain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD,
            CERTIFICATE_FIELD, PRIVATE_KEY_FIELD, CERTIFICATE_CHAIN_FIELD));

    private final String certificateArn;

    private final SdkBytes certificate;

    private final SdkBytes privateKey;

    private final SdkBytes certificateChain;

    private ImportCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateArn = builder.certificateArn;
        this.certificate = builder.certificate;
        this.privateKey = builder.privateKey;
        this.certificateChain = builder.certificateChain;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     * (ARN)</a> of an imported certificate to replace. To import a new certificate, omit this field.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *         Name (ARN)</a> of an imported certificate to replace. To import a new certificate, omit this field.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The certificate to import.
     * </p>
     * 
     * @return The certificate to import.
     */
    public SdkBytes certificate() {
        return certificate;
    }

    /**
     * <p>
     * The private key that matches the public key in the certificate.
     * </p>
     * 
     * @return The private key that matches the public key in the certificate.
     */
    public SdkBytes privateKey() {
        return privateKey;
    }

    /**
     * <p>
     * The PEM encoded certificate chain.
     * </p>
     * 
     * @return The PEM encoded certificate chain.
     */
    public SdkBytes certificateChain() {
        return certificateChain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(certificateChain());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportCertificateRequest)) {
            return false;
        }
        ImportCertificateRequest other = (ImportCertificateRequest) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(certificate(), other.certificate())
                && Objects.equals(privateKey(), other.privateKey())
                && Objects.equals(certificateChain(), other.certificateChain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImportCertificateRequest").add("CertificateArn", certificateArn())
                .add("Certificate", certificate())
                .add("PrivateKey", privateKey() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CertificateChain", certificateChain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "PrivateKey":
            return Optional.ofNullable(clazz.cast(privateKey()));
        case "CertificateChain":
            return Optional.ofNullable(clazz.cast(certificateChain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportCertificateRequest, T> g) {
        return obj -> g.apply((ImportCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportCertificateRequest> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of an imported certificate to replace. To import a new certificate, omit this field.
         * </p>
         * 
         * @param certificateArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        Resource Name (ARN)</a> of an imported certificate to replace. To import a new certificate, omit this
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The certificate to import.
         * </p>
         * 
         * @param certificate
         *        The certificate to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(SdkBytes certificate);

        /**
         * <p>
         * The private key that matches the public key in the certificate.
         * </p>
         * 
         * @param privateKey
         *        The private key that matches the public key in the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKey(SdkBytes privateKey);

        /**
         * <p>
         * The PEM encoded certificate chain.
         * </p>
         * 
         * @param certificateChain
         *        The PEM encoded certificate chain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateChain(SdkBytes certificateChain);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AcmRequest.BuilderImpl implements Builder {
        private String certificateArn;

        private SdkBytes certificate;

        private SdkBytes privateKey;

        private SdkBytes certificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportCertificateRequest model) {
            super(model);
            certificateArn(model.certificateArn);
            certificate(model.certificate);
            privateKey(model.privateKey);
            certificateChain(model.certificateChain);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final ByteBuffer getCertificate() {
            return certificate == null ? null : certificate.asByteBuffer();
        }

        @Override
        public final Builder certificate(SdkBytes certificate) {
            this.certificate = StandardMemberCopier.copy(certificate);
            return this;
        }

        public final void setCertificate(ByteBuffer certificate) {
            certificate(certificate == null ? null : SdkBytes.fromByteBuffer(certificate));
        }

        public final ByteBuffer getPrivateKey() {
            return privateKey == null ? null : privateKey.asByteBuffer();
        }

        @Override
        public final Builder privateKey(SdkBytes privateKey) {
            this.privateKey = StandardMemberCopier.copy(privateKey);
            return this;
        }

        public final void setPrivateKey(ByteBuffer privateKey) {
            privateKey(privateKey == null ? null : SdkBytes.fromByteBuffer(privateKey));
        }

        public final ByteBuffer getCertificateChain() {
            return certificateChain == null ? null : certificateChain.asByteBuffer();
        }

        @Override
        public final Builder certificateChain(SdkBytes certificateChain) {
            this.certificateChain = StandardMemberCopier.copy(certificateChain);
            return this;
        }

        public final void setCertificateChain(ByteBuffer certificateChain) {
            certificateChain(certificateChain == null ? null : SdkBytes.fromByteBuffer(certificateChain));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportCertificateRequest build() {
            return new ImportCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
