/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Feature {
    BLUETOOTH("BLUETOOTH"),
    VOLUME("VOLUME"),
    NOTIFICATIONS("NOTIFICATIONS"),
    LISTS("LISTS"),
    SKILLS("SKILLS"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Feature(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Feature fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Feature.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Feature> knownValues() {
        return Stream.of(Feature.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

