/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoomSkillParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoomSkillParameter> {
    private static final SdkField<String> PARAMETER_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoomSkillParameter.getter(RoomSkillParameter::parameterKey)).setter(RoomSkillParameter.setter(Builder::parameterKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterKey").build()}).build();
    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoomSkillParameter.getter(RoomSkillParameter::parameterValue)).setter(RoomSkillParameter.setter(Builder::parameterValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_KEY_FIELD, PARAMETER_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String parameterKey;
    private final String parameterValue;

    private RoomSkillParameter(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.parameterValue = builder.parameterValue;
    }

    public String parameterKey() {
        return this.parameterKey;
    }

    public String parameterValue() {
        return this.parameterValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoomSkillParameter)) {
            return false;
        }
        RoomSkillParameter other = (RoomSkillParameter)obj;
        return Objects.equals(this.parameterKey(), other.parameterKey()) && Objects.equals(this.parameterValue(), other.parameterValue());
    }

    public String toString() {
        return ToString.builder((String)"RoomSkillParameter").add("ParameterKey", (Object)this.parameterKey()).add("ParameterValue", (Object)this.parameterValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterKey": {
                return Optional.ofNullable(clazz.cast(this.parameterKey()));
            }
            case "ParameterValue": {
                return Optional.ofNullable(clazz.cast(this.parameterValue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoomSkillParameter, T> g) {
        return obj -> g.apply((RoomSkillParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterKey;
        private String parameterValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RoomSkillParameter model) {
            this.parameterKey(model.parameterKey);
            this.parameterValue(model.parameterValue);
        }

        public final String getParameterKey() {
            return this.parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        public final String getParameterValue() {
            return this.parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public RoomSkillParameter build() {
            return new RoomSkillParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoomSkillParameter> {
        public Builder parameterKey(String var1);

        public Builder parameterValue(String var1);
    }
}

