/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse;

public class SearchAddressBooksIterable
implements SdkIterable<SearchAddressBooksResponse> {
    private final AlexaForBusinessClient client;
    private final SearchAddressBooksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchAddressBooksIterable(AlexaForBusinessClient client, SearchAddressBooksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchAddressBooksResponseFetcher();
    }

    public Iterator<SearchAddressBooksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class SearchAddressBooksResponseFetcher
    implements SyncPageFetcher<SearchAddressBooksResponse> {
        private SearchAddressBooksResponseFetcher() {
        }

        public boolean hasNextPage(SearchAddressBooksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchAddressBooksResponse nextPage(SearchAddressBooksResponse previousPage) {
            if (previousPage == null) {
                return SearchAddressBooksIterable.this.client.searchAddressBooks(SearchAddressBooksIterable.this.firstRequest);
            }
            return SearchAddressBooksIterable.this.client.searchAddressBooks((SearchAddressBooksRequest)((Object)SearchAddressBooksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

