/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache5.internal.conn;

import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.DefaultConnectionKeepAliveStrategy;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public class SdkConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    private final TimeValue maxIdleTime;

    public SdkConnectionKeepAliveStrategy(long maxIdleTime) {
        this.maxIdleTime = TimeValue.of((long)maxIdleTime, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public TimeValue getKeepAliveDuration(HttpResponse response, HttpContext context) {
        TimeValue duration = DefaultConnectionKeepAliveStrategy.INSTANCE.getKeepAliveDuration(response, context);
        if (TimeValue.isPositive((TimeValue)duration) && duration.compareTo(this.maxIdleTime) < 0) {
            return duration;
        }
        return this.maxIdleTime;
    }
}

