/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The custom credentials required for custom authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomAuthCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomAuthCredentials.Builder, CustomAuthCredentials> {
    private static final SdkField<String> CUSTOM_AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customAuthenticationType").getter(getter(CustomAuthCredentials::customAuthenticationType))
            .setter(setter(Builder::customAuthenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAuthenticationType").build())
            .build();

    private static final SdkField<Map<String, String>> CREDENTIALS_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("credentialsMap")
            .getter(getter(CustomAuthCredentials::credentialsMap))
            .setter(setter(Builder::credentialsMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_AUTHENTICATION_TYPE_FIELD, CREDENTIALS_MAP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customAuthenticationType;

    private final Map<String, String> credentialsMap;

    private CustomAuthCredentials(BuilderImpl builder) {
        this.customAuthenticationType = builder.customAuthenticationType;
        this.credentialsMap = builder.credentialsMap;
    }

    /**
     * <p>
     * The custom authentication type that the connector uses.
     * </p>
     * 
     * @return The custom authentication type that the connector uses.
     */
    public final String customAuthenticationType() {
        return customAuthenticationType;
    }

    /**
     * For responses, this returns true if the service returned a value for the CredentialsMap property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCredentialsMap() {
        return credentialsMap != null && !(credentialsMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that holds custom authentication credentials.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCredentialsMap} method.
     * </p>
     * 
     * @return A map that holds custom authentication credentials.
     */
    public final Map<String, String> credentialsMap() {
        return credentialsMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customAuthenticationType());
        hashCode = 31 * hashCode + Objects.hashCode(hasCredentialsMap() ? credentialsMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomAuthCredentials)) {
            return false;
        }
        CustomAuthCredentials other = (CustomAuthCredentials) obj;
        return Objects.equals(customAuthenticationType(), other.customAuthenticationType())
                && hasCredentialsMap() == other.hasCredentialsMap() && Objects.equals(credentialsMap(), other.credentialsMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomAuthCredentials").add("CustomAuthenticationType", customAuthenticationType())
                .add("CredentialsMap", credentialsMap() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customAuthenticationType":
            return Optional.ofNullable(clazz.cast(customAuthenticationType()));
        case "credentialsMap":
            return Optional.ofNullable(clazz.cast(credentialsMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomAuthCredentials, T> g) {
        return obj -> g.apply((CustomAuthCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomAuthCredentials> {
        /**
         * <p>
         * The custom authentication type that the connector uses.
         * </p>
         * 
         * @param customAuthenticationType
         *        The custom authentication type that the connector uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAuthenticationType(String customAuthenticationType);

        /**
         * <p>
         * A map that holds custom authentication credentials.
         * </p>
         * 
         * @param credentialsMap
         *        A map that holds custom authentication credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsMap(Map<String, String> credentialsMap);
    }

    static final class BuilderImpl implements Builder {
        private String customAuthenticationType;

        private Map<String, String> credentialsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomAuthCredentials model) {
            customAuthenticationType(model.customAuthenticationType);
            credentialsMap(model.credentialsMap);
        }

        public final String getCustomAuthenticationType() {
            return customAuthenticationType;
        }

        public final void setCustomAuthenticationType(String customAuthenticationType) {
            this.customAuthenticationType = customAuthenticationType;
        }

        @Override
        public final Builder customAuthenticationType(String customAuthenticationType) {
            this.customAuthenticationType = customAuthenticationType;
            return this;
        }

        public final Map<String, String> getCredentialsMap() {
            if (credentialsMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return credentialsMap;
        }

        public final void setCredentialsMap(Map<String, String> credentialsMap) {
            this.credentialsMap = CredentialsMapCopier.copy(credentialsMap);
        }

        @Override
        public final Builder credentialsMap(Map<String, String> credentialsMap) {
            this.credentialsMap = CredentialsMapCopier.copy(credentialsMap);
            return this;
        }

        @Override
        public CustomAuthCredentials build() {
            return new CustomAuthCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
