/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example,
 * this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert
 * every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination
 * connector details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorHandlingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ErrorHandlingConfig.Builder, ErrorHandlingConfig> {
    private static final SdkField<Boolean> FAIL_ON_FIRST_DESTINATION_ERROR_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("failOnFirstDestinationError")
            .getter(getter(ErrorHandlingConfig::failOnFirstDestinationError))
            .setter(setter(Builder::failOnFirstDestinationError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failOnFirstDestinationError")
                    .build()).build();

    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketPrefix").getter(getter(ErrorHandlingConfig::bucketPrefix)).setter(setter(Builder::bucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPrefix").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(ErrorHandlingConfig::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FAIL_ON_FIRST_DESTINATION_ERROR_FIELD, BUCKET_PREFIX_FIELD, BUCKET_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean failOnFirstDestinationError;

    private final String bucketPrefix;

    private final String bucketName;

    private ErrorHandlingConfig(BuilderImpl builder) {
        this.failOnFirstDestinationError = builder.failOnFirstDestinationError;
        this.bucketPrefix = builder.bucketPrefix;
        this.bucketName = builder.bucketName;
    }

    /**
     * <p>
     * Specifies if the flow should fail after the first instance of a failure when attempting to place data in the
     * destination.
     * </p>
     * 
     * @return Specifies if the flow should fail after the first instance of a failure when attempting to place data in
     *         the destination.
     */
    public final Boolean failOnFirstDestinationError() {
        return failOnFirstDestinationError;
    }

    /**
     * <p>
     * Specifies the Amazon S3 bucket prefix.
     * </p>
     * 
     * @return Specifies the Amazon S3 bucket prefix.
     */
    public final String bucketPrefix() {
        return bucketPrefix;
    }

    /**
     * <p>
     * Specifies the name of the Amazon S3 bucket.
     * </p>
     * 
     * @return Specifies the name of the Amazon S3 bucket.
     */
    public final String bucketName() {
        return bucketName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failOnFirstDestinationError());
        hashCode = 31 * hashCode + Objects.hashCode(bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorHandlingConfig)) {
            return false;
        }
        ErrorHandlingConfig other = (ErrorHandlingConfig) obj;
        return Objects.equals(failOnFirstDestinationError(), other.failOnFirstDestinationError())
                && Objects.equals(bucketPrefix(), other.bucketPrefix()) && Objects.equals(bucketName(), other.bucketName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorHandlingConfig").add("FailOnFirstDestinationError", failOnFirstDestinationError())
                .add("BucketPrefix", bucketPrefix()).add("BucketName", bucketName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failOnFirstDestinationError":
            return Optional.ofNullable(clazz.cast(failOnFirstDestinationError()));
        case "bucketPrefix":
            return Optional.ofNullable(clazz.cast(bucketPrefix()));
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ErrorHandlingConfig, T> g) {
        return obj -> g.apply((ErrorHandlingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorHandlingConfig> {
        /**
         * <p>
         * Specifies if the flow should fail after the first instance of a failure when attempting to place data in the
         * destination.
         * </p>
         * 
         * @param failOnFirstDestinationError
         *        Specifies if the flow should fail after the first instance of a failure when attempting to place data
         *        in the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failOnFirstDestinationError(Boolean failOnFirstDestinationError);

        /**
         * <p>
         * Specifies the Amazon S3 bucket prefix.
         * </p>
         * 
         * @param bucketPrefix
         *        Specifies the Amazon S3 bucket prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketPrefix(String bucketPrefix);

        /**
         * <p>
         * Specifies the name of the Amazon S3 bucket.
         * </p>
         * 
         * @param bucketName
         *        Specifies the name of the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);
    }

    static final class BuilderImpl implements Builder {
        private Boolean failOnFirstDestinationError;

        private String bucketPrefix;

        private String bucketName;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorHandlingConfig model) {
            failOnFirstDestinationError(model.failOnFirstDestinationError);
            bucketPrefix(model.bucketPrefix);
            bucketName(model.bucketName);
        }

        public final Boolean getFailOnFirstDestinationError() {
            return failOnFirstDestinationError;
        }

        public final void setFailOnFirstDestinationError(Boolean failOnFirstDestinationError) {
            this.failOnFirstDestinationError = failOnFirstDestinationError;
        }

        @Override
        public final Builder failOnFirstDestinationError(Boolean failOnFirstDestinationError) {
            this.failOnFirstDestinationError = failOnFirstDestinationError;
            return this;
        }

        public final String getBucketPrefix() {
            return bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        @Override
        public ErrorHandlingConfig build() {
            return new ErrorHandlingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
