/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.services.appflow.model.DestinationFlowConfig;
import software.amazon.awssdk.services.appflow.model.DestinationFlowConfigListCopier;
import software.amazon.awssdk.services.appflow.model.MetadataCatalogConfig;
import software.amazon.awssdk.services.appflow.model.SourceFlowConfig;
import software.amazon.awssdk.services.appflow.model.Task;
import software.amazon.awssdk.services.appflow.model.TasksCopier;
import software.amazon.awssdk.services.appflow.model.TriggerConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlowRequest
extends AppflowRequest
implements ToCopyableBuilder<Builder, UpdateFlowRequest> {
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowName").getter(UpdateFlowRequest.getter(UpdateFlowRequest::flowName)).setter(UpdateFlowRequest.setter(Builder::flowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateFlowRequest.getter(UpdateFlowRequest::description)).setter(UpdateFlowRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<TriggerConfig> TRIGGER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("triggerConfig").getter(UpdateFlowRequest.getter(UpdateFlowRequest::triggerConfig)).setter(UpdateFlowRequest.setter(Builder::triggerConfig)).constructor(TriggerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerConfig").build()}).build();
    private static final SdkField<SourceFlowConfig> SOURCE_FLOW_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceFlowConfig").getter(UpdateFlowRequest.getter(UpdateFlowRequest::sourceFlowConfig)).setter(UpdateFlowRequest.setter(Builder::sourceFlowConfig)).constructor(SourceFlowConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFlowConfig").build()}).build();
    private static final SdkField<List<DestinationFlowConfig>> DESTINATION_FLOW_CONFIG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("destinationFlowConfigList").getter(UpdateFlowRequest.getter(UpdateFlowRequest::destinationFlowConfigList)).setter(UpdateFlowRequest.setter(Builder::destinationFlowConfigList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationFlowConfigList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DestinationFlowConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Task>> TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tasks").getter(UpdateFlowRequest.getter(UpdateFlowRequest::tasks)).setter(UpdateFlowRequest.setter(Builder::tasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Task::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MetadataCatalogConfig> METADATA_CATALOG_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadataCatalogConfig").getter(UpdateFlowRequest.getter(UpdateFlowRequest::metadataCatalogConfig)).setter(UpdateFlowRequest.setter(Builder::metadataCatalogConfig)).constructor(MetadataCatalogConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataCatalogConfig").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateFlowRequest.getter(UpdateFlowRequest::clientToken)).setter(UpdateFlowRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_NAME_FIELD, DESCRIPTION_FIELD, TRIGGER_CONFIG_FIELD, SOURCE_FLOW_CONFIG_FIELD, DESTINATION_FLOW_CONFIG_LIST_FIELD, TASKS_FIELD, METADATA_CATALOG_CONFIG_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFlowRequest.memberNameToFieldInitializer();
    private final String flowName;
    private final String description;
    private final TriggerConfig triggerConfig;
    private final SourceFlowConfig sourceFlowConfig;
    private final List<DestinationFlowConfig> destinationFlowConfigList;
    private final List<Task> tasks;
    private final MetadataCatalogConfig metadataCatalogConfig;
    private final String clientToken;

    private UpdateFlowRequest(BuilderImpl builder) {
        super(builder);
        this.flowName = builder.flowName;
        this.description = builder.description;
        this.triggerConfig = builder.triggerConfig;
        this.sourceFlowConfig = builder.sourceFlowConfig;
        this.destinationFlowConfigList = builder.destinationFlowConfigList;
        this.tasks = builder.tasks;
        this.metadataCatalogConfig = builder.metadataCatalogConfig;
        this.clientToken = builder.clientToken;
    }

    public final String flowName() {
        return this.flowName;
    }

    public final String description() {
        return this.description;
    }

    public final TriggerConfig triggerConfig() {
        return this.triggerConfig;
    }

    public final SourceFlowConfig sourceFlowConfig() {
        return this.sourceFlowConfig;
    }

    public final boolean hasDestinationFlowConfigList() {
        return this.destinationFlowConfigList != null && !(this.destinationFlowConfigList instanceof SdkAutoConstructList);
    }

    public final List<DestinationFlowConfig> destinationFlowConfigList() {
        return this.destinationFlowConfigList;
    }

    public final boolean hasTasks() {
        return this.tasks != null && !(this.tasks instanceof SdkAutoConstructList);
    }

    public final List<Task> tasks() {
        return this.tasks;
    }

    public final MetadataCatalogConfig metadataCatalogConfig() {
        return this.metadataCatalogConfig;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFlowConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationFlowConfigList() ? this.destinationFlowConfigList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTasks() ? this.tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataCatalogConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowRequest)) {
            return false;
        }
        UpdateFlowRequest other = (UpdateFlowRequest)((Object)obj);
        return Objects.equals(this.flowName(), other.flowName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.triggerConfig(), other.triggerConfig()) && Objects.equals(this.sourceFlowConfig(), other.sourceFlowConfig()) && this.hasDestinationFlowConfigList() == other.hasDestinationFlowConfigList() && Objects.equals(this.destinationFlowConfigList(), other.destinationFlowConfigList()) && this.hasTasks() == other.hasTasks() && Objects.equals(this.tasks(), other.tasks()) && Objects.equals(this.metadataCatalogConfig(), other.metadataCatalogConfig()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFlowRequest").add("FlowName", (Object)this.flowName()).add("Description", (Object)this.description()).add("TriggerConfig", (Object)this.triggerConfig()).add("SourceFlowConfig", (Object)this.sourceFlowConfig()).add("DestinationFlowConfigList", this.hasDestinationFlowConfigList() ? this.destinationFlowConfigList() : null).add("Tasks", this.hasTasks() ? this.tasks() : null).add("MetadataCatalogConfig", (Object)this.metadataCatalogConfig()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowName": {
                return Optional.ofNullable(clazz.cast(this.flowName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "triggerConfig": {
                return Optional.ofNullable(clazz.cast(this.triggerConfig()));
            }
            case "sourceFlowConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceFlowConfig()));
            }
            case "destinationFlowConfigList": {
                return Optional.ofNullable(clazz.cast(this.destinationFlowConfigList()));
            }
            case "tasks": {
                return Optional.ofNullable(clazz.cast(this.tasks()));
            }
            case "metadataCatalogConfig": {
                return Optional.ofNullable(clazz.cast(this.metadataCatalogConfig()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flowName", FLOW_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("triggerConfig", TRIGGER_CONFIG_FIELD);
        map.put("sourceFlowConfig", SOURCE_FLOW_CONFIG_FIELD);
        map.put("destinationFlowConfigList", DESTINATION_FLOW_CONFIG_LIST_FIELD);
        map.put("tasks", TASKS_FIELD);
        map.put("metadataCatalogConfig", METADATA_CATALOG_CONFIG_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowRequest, T> g) {
        return obj -> g.apply((UpdateFlowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowRequest.BuilderImpl
    implements Builder {
        private String flowName;
        private String description;
        private TriggerConfig triggerConfig;
        private SourceFlowConfig sourceFlowConfig;
        private List<DestinationFlowConfig> destinationFlowConfigList = DefaultSdkAutoConstructList.getInstance();
        private List<Task> tasks = DefaultSdkAutoConstructList.getInstance();
        private MetadataCatalogConfig metadataCatalogConfig;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowRequest model) {
            super(model);
            this.flowName(model.flowName);
            this.description(model.description);
            this.triggerConfig(model.triggerConfig);
            this.sourceFlowConfig(model.sourceFlowConfig);
            this.destinationFlowConfigList(model.destinationFlowConfigList);
            this.tasks(model.tasks);
            this.metadataCatalogConfig(model.metadataCatalogConfig);
            this.clientToken(model.clientToken);
        }

        public final String getFlowName() {
            return this.flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TriggerConfig.Builder getTriggerConfig() {
            return this.triggerConfig != null ? this.triggerConfig.toBuilder() : null;
        }

        public final void setTriggerConfig(TriggerConfig.BuilderImpl triggerConfig) {
            this.triggerConfig = triggerConfig != null ? triggerConfig.build() : null;
        }

        @Override
        public final Builder triggerConfig(TriggerConfig triggerConfig) {
            this.triggerConfig = triggerConfig;
            return this;
        }

        public final SourceFlowConfig.Builder getSourceFlowConfig() {
            return this.sourceFlowConfig != null ? this.sourceFlowConfig.toBuilder() : null;
        }

        public final void setSourceFlowConfig(SourceFlowConfig.BuilderImpl sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig != null ? sourceFlowConfig.build() : null;
        }

        @Override
        public final Builder sourceFlowConfig(SourceFlowConfig sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig;
            return this;
        }

        public final List<DestinationFlowConfig.Builder> getDestinationFlowConfigList() {
            List<DestinationFlowConfig.Builder> result = DestinationFlowConfigListCopier.copyToBuilder(this.destinationFlowConfigList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationFlowConfigList(Collection<DestinationFlowConfig.BuilderImpl> destinationFlowConfigList) {
            this.destinationFlowConfigList = DestinationFlowConfigListCopier.copyFromBuilder(destinationFlowConfigList);
        }

        @Override
        public final Builder destinationFlowConfigList(Collection<DestinationFlowConfig> destinationFlowConfigList) {
            this.destinationFlowConfigList = DestinationFlowConfigListCopier.copy(destinationFlowConfigList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationFlowConfigList(DestinationFlowConfig ... destinationFlowConfigList) {
            this.destinationFlowConfigList(Arrays.asList(destinationFlowConfigList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationFlowConfigList(Consumer<DestinationFlowConfig.Builder> ... destinationFlowConfigList) {
            this.destinationFlowConfigList(Stream.of(destinationFlowConfigList).map(c -> (DestinationFlowConfig)((DestinationFlowConfig.Builder)DestinationFlowConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Task.Builder> getTasks() {
            List<Task.Builder> result = TasksCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<Task.BuilderImpl> tasks) {
            this.tasks = TasksCopier.copyFromBuilder(tasks);
        }

        @Override
        public final Builder tasks(Collection<Task> tasks) {
            this.tasks = TasksCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Task ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<Task.Builder> ... tasks) {
            this.tasks(Stream.of(tasks).map(c -> (Task)((Task.Builder)Task.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MetadataCatalogConfig.Builder getMetadataCatalogConfig() {
            return this.metadataCatalogConfig != null ? this.metadataCatalogConfig.toBuilder() : null;
        }

        public final void setMetadataCatalogConfig(MetadataCatalogConfig.BuilderImpl metadataCatalogConfig) {
            this.metadataCatalogConfig = metadataCatalogConfig != null ? metadataCatalogConfig.build() : null;
        }

        @Override
        public final Builder metadataCatalogConfig(MetadataCatalogConfig metadataCatalogConfig) {
            this.metadataCatalogConfig = metadataCatalogConfig;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowRequest build() {
            return new UpdateFlowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppflowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlowRequest> {
        public Builder flowName(String var1);

        public Builder description(String var1);

        public Builder triggerConfig(TriggerConfig var1);

        default public Builder triggerConfig(Consumer<TriggerConfig.Builder> triggerConfig) {
            return this.triggerConfig((TriggerConfig)((TriggerConfig.Builder)TriggerConfig.builder().applyMutation(triggerConfig)).build());
        }

        public Builder sourceFlowConfig(SourceFlowConfig var1);

        default public Builder sourceFlowConfig(Consumer<SourceFlowConfig.Builder> sourceFlowConfig) {
            return this.sourceFlowConfig((SourceFlowConfig)((SourceFlowConfig.Builder)SourceFlowConfig.builder().applyMutation(sourceFlowConfig)).build());
        }

        public Builder destinationFlowConfigList(Collection<DestinationFlowConfig> var1);

        public Builder destinationFlowConfigList(DestinationFlowConfig ... var1);

        public Builder destinationFlowConfigList(Consumer<DestinationFlowConfig.Builder> ... var1);

        public Builder tasks(Collection<Task> var1);

        public Builder tasks(Task ... var1);

        public Builder tasks(Consumer<Task.Builder> ... var1);

        public Builder metadataCatalogConfig(MetadataCatalogConfig var1);

        default public Builder metadataCatalogConfig(Consumer<MetadataCatalogConfig.Builder> metadataCatalogConfig) {
            return this.metadataCatalogConfig((MetadataCatalogConfig)((MetadataCatalogConfig.Builder)MetadataCatalogConfig.builder().applyMutation(metadataCatalogConfig)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

