/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appflow.AppflowClient;
import software.amazon.awssdk.services.appflow.internal.UserAgentUtils;
import software.amazon.awssdk.services.appflow.model.ListConnectorsRequest;
import software.amazon.awssdk.services.appflow.model.ListConnectorsResponse;

public class ListConnectorsIterable
implements SdkIterable<ListConnectorsResponse> {
    private final AppflowClient client;
    private final ListConnectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConnectorsIterable(AppflowClient client, ListConnectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConnectorsResponseFetcher();
    }

    public Iterator<ListConnectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListConnectorsResponseFetcher
    implements SyncPageFetcher<ListConnectorsResponse> {
        private ListConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConnectorsResponse nextPage(ListConnectorsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectorsIterable.this.client.listConnectors(ListConnectorsIterable.this.firstRequest);
            }
            return ListConnectorsIterable.this.client.listConnectors((ListConnectorsRequest)((Object)ListConnectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

