/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AdjustmentType {
    CHANGE_IN_CAPACITY("ChangeInCapacity"),
    PERCENT_CHANGE_IN_CAPACITY("PercentChangeInCapacity"),
    EXACT_CAPACITY("ExactCapacity"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AdjustmentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AdjustmentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AdjustmentType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AdjustmentType> knownValues() {
        return Stream.of(AdjustmentType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

