/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationautoscaling.model.ApplicationAutoScalingRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace;
import software.amazon.awssdk.services.applicationautoscaling.model.SuspendedState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterScalableTargetRequest
extends ApplicationAutoScalingRequest
implements ToCopyableBuilder<Builder, RegisterScalableTargetRequest> {
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNamespace").getter(RegisterScalableTargetRequest.getter(RegisterScalableTargetRequest::serviceNamespaceAsString)).setter(RegisterScalableTargetRequest.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(RegisterScalableTargetRequest.getter(RegisterScalableTargetRequest::resourceId)).setter(RegisterScalableTargetRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalableDimension").getter(RegisterScalableTargetRequest.getter(RegisterScalableTargetRequest::scalableDimensionAsString)).setter(RegisterScalableTargetRequest.setter(Builder::scalableDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()}).build();
    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinCapacity").getter(RegisterScalableTargetRequest.getter(RegisterScalableTargetRequest::minCapacity)).setter(RegisterScalableTargetRequest.setter(Builder::minCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCapacity").getter(RegisterScalableTargetRequest.getter(RegisterScalableTargetRequest::maxCapacity)).setter(RegisterScalableTargetRequest.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(RegisterScalableTargetRequest.getter(RegisterScalableTargetRequest::roleARN)).setter(RegisterScalableTargetRequest.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<SuspendedState> SUSPENDED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SuspendedState").getter(RegisterScalableTargetRequest.getter(RegisterScalableTargetRequest::suspendedState)).setter(RegisterScalableTargetRequest.setter(Builder::suspendedState)).constructor(SuspendedState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuspendedState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMESPACE_FIELD, RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD, MIN_CAPACITY_FIELD, MAX_CAPACITY_FIELD, ROLE_ARN_FIELD, SUSPENDED_STATE_FIELD));
    private final String serviceNamespace;
    private final String resourceId;
    private final String scalableDimension;
    private final Integer minCapacity;
    private final Integer maxCapacity;
    private final String roleARN;
    private final SuspendedState suspendedState;

    private RegisterScalableTargetRequest(BuilderImpl builder) {
        super(builder);
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.roleARN = builder.roleARN;
        this.suspendedState = builder.suspendedState;
    }

    public ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(this.serviceNamespace);
    }

    public String serviceNamespaceAsString() {
        return this.serviceNamespace;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(this.scalableDimension);
    }

    public String scalableDimensionAsString() {
        return this.scalableDimension;
    }

    public Integer minCapacity() {
        return this.minCapacity;
    }

    public Integer maxCapacity() {
        return this.maxCapacity;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public SuspendedState suspendedState() {
        return this.suspendedState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.suspendedState());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterScalableTargetRequest)) {
            return false;
        }
        RegisterScalableTargetRequest other = (RegisterScalableTargetRequest)((Object)obj);
        return Objects.equals(this.serviceNamespaceAsString(), other.serviceNamespaceAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.scalableDimensionAsString(), other.scalableDimensionAsString()) && Objects.equals(this.minCapacity(), other.minCapacity()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.suspendedState(), other.suspendedState());
    }

    public String toString() {
        return ToString.builder((String)"RegisterScalableTargetRequest").add("ServiceNamespace", (Object)this.serviceNamespaceAsString()).add("ResourceId", (Object)this.resourceId()).add("ScalableDimension", (Object)this.scalableDimensionAsString()).add("MinCapacity", (Object)this.minCapacity()).add("MaxCapacity", (Object)this.maxCapacity()).add("RoleARN", (Object)this.roleARN()).add("SuspendedState", (Object)this.suspendedState()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespaceAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ScalableDimension": {
                return Optional.ofNullable(clazz.cast(this.scalableDimensionAsString()));
            }
            case "MinCapacity": {
                return Optional.ofNullable(clazz.cast(this.minCapacity()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "SuspendedState": {
                return Optional.ofNullable(clazz.cast(this.suspendedState()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterScalableTargetRequest, T> g) {
        return obj -> g.apply((RegisterScalableTargetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationAutoScalingRequest.BuilderImpl
    implements Builder {
        private String serviceNamespace;
        private String resourceId;
        private String scalableDimension;
        private Integer minCapacity;
        private Integer maxCapacity;
        private String roleARN;
        private SuspendedState suspendedState;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterScalableTargetRequest model) {
            super(model);
            this.serviceNamespace(model.serviceNamespace);
            this.resourceId(model.resourceId);
            this.scalableDimension(model.scalableDimension);
            this.minCapacity(model.minCapacity);
            this.maxCapacity(model.maxCapacity);
            this.roleARN(model.roleARN);
            this.suspendedState(model.suspendedState);
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace == null ? null : serviceNamespace.toString());
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getScalableDimension() {
            return this.scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension == null ? null : scalableDimension.toString());
            return this;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        public final Integer getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final SuspendedState.Builder getSuspendedState() {
            return this.suspendedState != null ? this.suspendedState.toBuilder() : null;
        }

        @Override
        public final Builder suspendedState(SuspendedState suspendedState) {
            this.suspendedState = suspendedState;
            return this;
        }

        public final void setSuspendedState(SuspendedState.BuilderImpl suspendedState) {
            this.suspendedState = suspendedState != null ? suspendedState.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterScalableTargetRequest build() {
            return new RegisterScalableTargetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationAutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterScalableTargetRequest> {
        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder minCapacity(Integer var1);

        public Builder maxCapacity(Integer var1);

        public Builder roleARN(String var1);

        public Builder suspendedState(SuspendedState var1);

        default public Builder suspendedState(Consumer<SuspendedState.Builder> suspendedState) {
            return this.suspendedState((SuspendedState)((SuspendedState.Builder)SuspendedState.builder().applyMutation(suspendedState)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

