/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure defines the CloudWatch metric to return, along with the statistic and unit.
 * </p>
 * <p>
 * For more information about the CloudWatch terminology below, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch
 * concepts</a> in the <i>Amazon CloudWatch User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetTrackingMetricStat implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetTrackingMetricStat.Builder, TargetTrackingMetricStat> {
    private static final SdkField<TargetTrackingMetric> METRIC_FIELD = SdkField
            .<TargetTrackingMetric> builder(MarshallingType.SDK_POJO).memberName("Metric")
            .getter(getter(TargetTrackingMetricStat::metric)).setter(setter(Builder::metric))
            .constructor(TargetTrackingMetric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final SdkField<String> STAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Stat")
            .getter(getter(TargetTrackingMetricStat::stat)).setter(setter(Builder::stat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stat").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(TargetTrackingMetricStat::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FIELD, STAT_FIELD,
            UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final TargetTrackingMetric metric;

    private final String stat;

    private final String unit;

    private TargetTrackingMetricStat(BuilderImpl builder) {
        this.metric = builder.metric;
        this.stat = builder.stat;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact metric
     * name, namespace, and dimensions, inspect the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that is
     * returned by a call to <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a>.
     * </p>
     * 
     * @return The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact
     *         metric name, namespace, and dimensions, inspect the <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object
     *         that is returned by a call to <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html"
     *         >ListMetrics</a>.
     */
    public final TargetTrackingMetric metric() {
        return metric;
    }

    /**
     * <p>
     * The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid
     * values, see the table in <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
     * >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * The most commonly used metric for scaling is <code>Average</code>.
     * </p>
     * 
     * @return The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of
     *         valid values, see the table in <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
     *         >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.</p>
     *         <p>
     *         The most commonly used metric for scaling is <code>Average</code>.
     */
    public final String stat() {
        return stat;
    }

    /**
     * <p>
     * The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see the
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a>
     * data type in the <i>Amazon CloudWatch API Reference</i>.
     * </p>
     * 
     * @return The unit to use for the returned data points. For a complete list of the units that CloudWatch supports,
     *         see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">
     *         MetricDatum</a> data type in the <i>Amazon CloudWatch API Reference</i>.
     */
    public final String unit() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(stat());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingMetricStat)) {
            return false;
        }
        TargetTrackingMetricStat other = (TargetTrackingMetricStat) obj;
        return Objects.equals(metric(), other.metric()) && Objects.equals(stat(), other.stat())
                && Objects.equals(unit(), other.unit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetTrackingMetricStat").add("Metric", metric()).add("Stat", stat()).add("Unit", unit())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "Stat":
            return Optional.ofNullable(clazz.cast(stat()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingMetricStat, T> g) {
        return obj -> g.apply((TargetTrackingMetricStat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetTrackingMetricStat> {
        /**
         * <p>
         * The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact
         * metric name, namespace, and dimensions, inspect the <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object
         * that is returned by a call to <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a>.
         * </p>
         * 
         * @param metric
         *        The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the
         *        exact metric name, namespace, and dimensions, inspect the <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a>
         *        object that is returned by a call to <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html"
         *        >ListMetrics</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(TargetTrackingMetric metric);

        /**
         * <p>
         * The CloudWatch metric to return, including the metric name, namespace, and dimensions. To get the exact
         * metric name, namespace, and dimensions, inspect the <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object
         * that is returned by a call to <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetTrackingMetric.Builder} avoiding
         * the need to create one manually via {@link TargetTrackingMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetTrackingMetric.Builder#build()} is called immediately and
         * its result is passed to {@link #metric(TargetTrackingMetric)}.
         * 
         * @param metric
         *        a consumer that will call methods on {@link TargetTrackingMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metric(TargetTrackingMetric)
         */
        default Builder metric(Consumer<TargetTrackingMetric.Builder> metric) {
            return metric(TargetTrackingMetric.builder().applyMutation(metric).build());
        }

        /**
         * <p>
         * The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of valid
         * values, see the table in <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
         * >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.
         * </p>
         * <p>
         * The most commonly used metric for scaling is <code>Average</code>.
         * </p>
         * 
         * @param stat
         *        The statistic to return. It can include any CloudWatch statistic or extended statistic. For a list of
         *        valid values, see the table in <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
         *        >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.</p>
         *        <p>
         *        The most commonly used metric for scaling is <code>Average</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stat(String stat);

        /**
         * <p>
         * The unit to use for the returned data points. For a complete list of the units that CloudWatch supports, see
         * the <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a>
         * data type in the <i>Amazon CloudWatch API Reference</i>.
         * </p>
         * 
         * @param unit
         *        The unit to use for the returned data points. For a complete list of the units that CloudWatch
         *        supports, see the <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html"
         *        >MetricDatum</a> data type in the <i>Amazon CloudWatch API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);
    }

    static final class BuilderImpl implements Builder {
        private TargetTrackingMetric metric;

        private String stat;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingMetricStat model) {
            metric(model.metric);
            stat(model.stat);
            unit(model.unit);
        }

        public final TargetTrackingMetric.Builder getMetric() {
            return metric != null ? metric.toBuilder() : null;
        }

        public final void setMetric(TargetTrackingMetric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        @Override
        public final Builder metric(TargetTrackingMetric metric) {
            this.metric = metric;
            return this;
        }

        public final String getStat() {
            return stat;
        }

        public final void setStat(String stat) {
            this.stat = stat;
        }

        @Override
        public final Builder stat(String stat) {
            this.stat = stat;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public TargetTrackingMetricStat build() {
            return new TargetTrackingMetricStat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
